/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.chat.plugins;

import com.palmergames.bukkit.towny.NotRegisteredException;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Resident;
import java.util.logging.Logger;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Chat_Towny
extends Chat {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "Towny";
    private Towny towny;
    private Vault plugin;

    public Chat_Towny(Vault plugin, Permission perms) {
        super(perms);
        Plugin p;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), (Plugin)plugin);
        if (this.towny == null && (p = plugin.getServer().getPluginManager().getPlugin("Towny")) != null) {
            this.towny = (Towny)p;
            log.info(String.format("[%s][Chat] %s hooked.", plugin.getDescription().getName(), "Towny"));
        }
    }

    @Override
    public String getName() {
        return "Towny";
    }

    @Override
    public boolean isEnabled() {
        return this.towny != null;
    }

    @Override
    public String getPlayerPrefix(String world, String player) {
        try {
            Resident r = this.towny.getTownyUniverse().getResident(player);
            return r.getTitle();
        }
        catch (NotRegisteredException notRegisteredException) {
            return "";
        }
    }

    @Override
    public void setPlayerPrefix(String world, String player, String prefix) {
        throw new UnsupportedOperationException("Towny does not support altering prefixes");
    }

    @Override
    public String getPlayerSuffix(String world, String player) {
        try {
            Resident r = this.towny.getTownyUniverse().getResident(player);
            return r.getSurname();
        }
        catch (NotRegisteredException notRegisteredException) {
            return "";
        }
    }

    @Override
    public void setPlayerSuffix(String world, String player, String suffix) {
        throw new UnsupportedOperationException("Towny does not support altering suffixes");
    }

    @Override
    public String getGroupPrefix(String world, String group) {
        try {
            return this.towny.getTownyUniverse().getTown(group).getTag();
        }
        catch (NotRegisteredException notRegisteredException) {
            return "";
        }
    }

    @Override
    public void setGroupPrefix(String world, String group, String prefix) {
        throw new UnsupportedOperationException("Towny does not support altering prefixes");
    }

    @Override
    public String getGroupSuffix(String world, String group) {
        throw new UnsupportedOperationException("Towny does not support group/town suffixes");
    }

    @Override
    public void setGroupSuffix(String world, String group, String suffix) {
        throw new UnsupportedOperationException("Towny does not support altering suffixes");
    }

    @Override
    public int getPlayerInfoInteger(String world, String player, String node, int defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setPlayerInfoInteger(String world, String player, String node, int value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public int getGroupInfoInteger(String world, String group, String node, int defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setGroupInfoInteger(String world, String group, String node, int value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public double getPlayerInfoDouble(String world, String player, String node, double defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setPlayerInfoDouble(String world, String player, String node, double value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public double getGroupInfoDouble(String world, String group, String node, double defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setGroupInfoDouble(String world, String group, String node, double value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public boolean getPlayerInfoBoolean(String world, String player, String node, boolean defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setPlayerInfoBoolean(String world, String player, String node, boolean value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public boolean getGroupInfoBoolean(String world, String group, String node, boolean defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setGroupInfoBoolean(String world, String group, String node, boolean value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public String getPlayerInfoString(String world, String player, String node, String defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setPlayerInfoString(String world, String player, String node, String value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public String getGroupInfoString(String world, String group, String node, String defaultValue) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    @Override
    public void setGroupInfoString(String world, String group, String node, String value) {
        throw new UnsupportedOperationException("Towny does not support info nodes");
    }

    public class PermissionServerListener
    implements Listener {
        Chat_Towny chat = null;

        public PermissionServerListener(Chat_Towny chat) {
            this.chat = chat;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            if (this.chat.towny == null) {
                Plugin towny = Chat_Towny.this.plugin.getServer().getPluginManager().getPlugin("Towny");
                if (this.chat != null) {
                    this.chat.towny = (Towny)towny;
                    log.info(String.format("[%s][Chat] %s hooked.", Chat_Towny.this.plugin.getDescription().getName(), "Towny"));
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.chat.towny != null && event.getPlugin().getDescription().getName().equals("Towny")) {
                this.chat.towny = null;
                log.info(String.format("[%s][Chat] %s un-hooked.", Chat_Towny.this.plugin.getDescription().getName(), "Towny"));
            }
        }
    }
}

