/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault;

import com.nijikokun.register.payment.Methods;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import net.milkbowl.vault.Metrics;
import net.milkbowl.vault.VaultEco;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.chat.plugins.Chat_GroupManager;
import net.milkbowl.vault.chat.plugins.Chat_Permissions3;
import net.milkbowl.vault.chat.plugins.Chat_PermissionsEx;
import net.milkbowl.vault.chat.plugins.Chat_Towny;
import net.milkbowl.vault.chat.plugins.Chat_bPermissions;
import net.milkbowl.vault.chat.plugins.Chat_bPermissions2;
import net.milkbowl.vault.chat.plugins.Chat_iChat;
import net.milkbowl.vault.chat.plugins.Chat_mChat;
import net.milkbowl.vault.chat.plugins.Chat_mChatSuite;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.plugins.Economy_3co;
import net.milkbowl.vault.economy.plugins.Economy_BOSE6;
import net.milkbowl.vault.economy.plugins.Economy_BOSE7;
import net.milkbowl.vault.economy.plugins.Economy_Craftconomy;
import net.milkbowl.vault.economy.plugins.Economy_CurrencyCore;
import net.milkbowl.vault.economy.plugins.Economy_EconXP;
import net.milkbowl.vault.economy.plugins.Economy_Essentials;
import net.milkbowl.vault.economy.plugins.Economy_McMoney;
import net.milkbowl.vault.economy.plugins.Economy_MineConomy;
import net.milkbowl.vault.economy.plugins.Economy_MultiCurrency;
import net.milkbowl.vault.economy.plugins.Economy_eWallet;
import net.milkbowl.vault.economy.plugins.Economy_iConomy4;
import net.milkbowl.vault.economy.plugins.Economy_iConomy5;
import net.milkbowl.vault.economy.plugins.Economy_iConomy6;
import net.milkbowl.vault.permission.Permission;
import net.milkbowl.vault.permission.plugins.Permission_GroupManager;
import net.milkbowl.vault.permission.plugins.Permission_Permissions3;
import net.milkbowl.vault.permission.plugins.Permission_PermissionsBukkit;
import net.milkbowl.vault.permission.plugins.Permission_PermissionsEx;
import net.milkbowl.vault.permission.plugins.Permission_Starburst;
import net.milkbowl.vault.permission.plugins.Permission_SuperPerms;
import net.milkbowl.vault.permission.plugins.Permission_bPermissions;
import net.milkbowl.vault.permission.plugins.Permission_bPermissions2;
import net.milkbowl.vault.permission.plugins.Permission_zPermissions;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Vault
extends JavaPlugin {
    private static final Logger log = Logger.getLogger("Minecraft");
    private Permission perms;
    private double newVersion;
    private double currentVersion;
    private ServicesManager sm;
    private Metrics metrics;

    public void onDisable() {
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        log.info(String.format("[%s] Disabled Version %s", this.getDescription().getName(), this.getDescription().getVersion()));
    }

    public void onEnable() {
        this.currentVersion = Double.valueOf(this.getDescription().getVersion().split("-")[0].replaceFirst("\\.", ""));
        this.sm = this.getServer().getServicesManager();
        this.loadEconomy();
        this.loadPermission();
        this.loadChat();
        this.getCommand("vault-info").setExecutor((CommandExecutor)this);
        this.getCommand("vault-reload").setExecutor((CommandExecutor)this);
        this.getCommand("vault-convert").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)new VaultListener(), (Plugin)this);
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    Vault.this.newVersion = Vault.this.updateCheck(Vault.this.currentVersion);
                    if (Vault.this.newVersion > Vault.this.currentVersion) {
                        log.warning("Vault " + Vault.this.newVersion + " is out! You are running: Vault " + Vault.this.currentVersion);
                        log.warning("Update Vault at: http://dev.bukkit.org/server-mods/vault");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 0L, 432000L);
        try {
            String authors = "";
            for (String author : this.getDescription().getAuthors()) {
                authors = authors + author + ", ";
            }
            if (!authors.isEmpty()) {
                authors = authors.substring(0, authors.length() - 2);
            }
            this.metrics = new Metrics(this.getDescription().getVersion(), authors);
            this.metrics.findCustomData(this);
            this.metrics.beginMeasuringPlugin((Plugin)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.info(String.format("[%s] Enabled Version %s", this.getDescription().getName(), this.getDescription().getVersion()));
    }

    private void loadChat() {
        Chat bPerms;
        Chat mChat2;
        if (Vault.packageExists("ru.tehkode.permissions.bukkit.PermissionsEx")) {
            Chat_PermissionsEx eChat = new Chat_PermissionsEx((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)eChat, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Chat] PermissionsEx found: %s", this.getDescription().getName(), ((Chat)eChat).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("in.mDev.MiracleM4n.mChatSuite.mChatSuite")) {
            mChat2 = new Chat_mChatSuite((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)mChat2, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Chat] mChatSuite found: %s", this.getDescription().getName(), mChat2.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("net.D3GN.MiracleM4n.mChat")) {
            mChat2 = new Chat_mChat((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)mChat2, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Chat] mChat found: %s", this.getDescription().getName(), mChat2.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("de.bananaco.bpermissions.api.ApiLayer")) {
            bPerms = new Chat_bPermissions2(this, this.perms);
            this.sm.register(Chat.class, (Object)bPerms, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Chat] bPermissions2 found: %s", this.getDescription().getName(), bPerms.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("de.bananaco.permissions.info.InfoReader")) {
            bPerms = new Chat_bPermissions(this, this.perms);
            this.sm.register(Chat.class, (Object)bPerms, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Chat] bPermissions found: %s", this.getDescription().getName(), bPerms.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("org.anjocaido.groupmanager.GroupManager")) {
            Chat_GroupManager gPerms = new Chat_GroupManager((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)gPerms, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Chat] GroupManager found: %s", this.getDescription().getName(), ((Chat)gPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.nijiko.permissions.ModularControl")) {
            Chat_Permissions3 nPerms = new Chat_Permissions3((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)nPerms, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Chat] Permissions 3 (Yeti) found: %s", this.getDescription().getName(), ((Chat)nPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("net.TheDgtl.iChat.iChat")) {
            Chat_iChat iChat2 = new Chat_iChat((Plugin)this, this.perms);
            this.sm.register(Chat.class, (Object)iChat2, (Plugin)this, ServicePriority.Low);
            log.info(String.format("[%s][Chat] iChat found: %s", this.getDescription().getName(), ((Chat)iChat2).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.palmergames.bukkit.towny.Towny")) {
            Chat_Towny townChat = new Chat_Towny(this, this.perms);
            this.sm.register(Chat.class, (Object)townChat, (Plugin)this, ServicePriority.Lowest);
            log.info(String.format("[%s][Chat] Towny found: %s", this.getDescription().getName(), ((Chat)townChat).isEnabled() ? "Loaded" : "Waiting"));
        }
    }

    private void loadEconomy() {
        Economy econ;
        if (Vault.packageExists("me.ashtheking.currency.Currency", "me.ashtheking.currency.CurrencyList")) {
            econ = new Economy_MultiCurrency((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] MultiCurrency found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("me.mjolnir.mineconomy.MineConomy")) {
            econ = new Economy_MineConomy((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] MineConomy found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("boardinggamer.mcmoney.McMoneyAPI")) {
            econ = new Economy_McMoney((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] McMoney found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("me.greatman.Craftconomy.Craftconomy")) {
            econ = new Economy_Craftconomy(this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] CraftConomy found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("me.ethan.eWallet.ECO")) {
            econ = new Economy_eWallet((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] eWallet found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("me.ic3d.eco.ECO")) {
            econ = new Economy_3co((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] 3co found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("cosine.boseconomy.BOSEconomy", "cosine.boseconomy.CommandManager")) {
            Economy_BOSE6 bose6 = new Economy_BOSE6((Plugin)this);
            this.sm.register(Economy.class, (Object)bose6, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] BOSEconomy6 found: %s", this.getDescription().getName(), bose6.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("cosine.boseconomy.BOSEconomy", "cosine.boseconomy.CommandHandler")) {
            Economy_BOSE7 bose7 = new Economy_BOSE7((Plugin)this);
            this.sm.register(Economy.class, (Object)bose7, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] BOSEconomy7 found: %s", this.getDescription().getName(), bose7.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("is.currency.Currency")) {
            Economy_CurrencyCore cCore = new Economy_CurrencyCore((Plugin)this);
            this.sm.register(Economy.class, (Object)cCore, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] CurrencyCore found: %s", this.getDescription().getName(), cCore.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.earth2me.essentials.api.Economy", "com.earth2me.essentials.api.NoLoanPermittedException", "com.earth2me.essentials.api.UserDoesNotExistException")) {
            Economy_Essentials essentials = new Economy_Essentials((Plugin)this);
            this.sm.register(Economy.class, (Object)essentials, (Plugin)this, ServicePriority.Low);
            log.info(String.format("[%s][Economy] Essentials Economy found: %s", this.getDescription().getName(), essentials.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.nijiko.coelho.iConomy.iConomy", "com.nijiko.coelho.iConomy.system.Account")) {
            Economy_iConomy4 icon4 = new Economy_iConomy4((Plugin)this);
            this.sm.register(Economy.class, (Object)icon4, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Economy] iConomy 4 found: ", this.getDescription().getName(), icon4.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.iConomy.iConomy", "com.iConomy.system.Account", "com.iConomy.system.Holdings")) {
            Economy_iConomy5 icon5 = new Economy_iConomy5(this);
            this.sm.register(Economy.class, (Object)icon5, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Economy] iConomy 5 found: %s", this.getDescription().getName(), icon5.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.iCo6.iConomy")) {
            Economy_iConomy6 icon6 = new Economy_iConomy6(this);
            this.sm.register(Economy.class, (Object)icon6, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Economy] iConomy 6 found: %s", this.getDescription().getName(), icon6.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("ca.agnate.EconXP.EconXP")) {
            econ = new Economy_EconXP((Plugin)this);
            this.sm.register(Economy.class, (Object)econ, (Plugin)this, ServicePriority.Normal);
            log.info(String.format("[%s][Economy] EconXP found: %s", this.getDescription().getName(), econ.isEnabled() ? "Loaded" : "Waiting"));
        }
    }

    private void loadPermission() {
        Permission bPerms;
        if (Vault.packageExists("com.dthielke.starburst.StarburstPlugin")) {
            Permission_Starburst sPerms = new Permission_Starburst(this);
            this.sm.register(Permission.class, (Object)sPerms, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Permission] Starburst found: %s", this.getDescription().getName(), ((Permission)sPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("ru.tehkode.permissions.bukkit.PermissionsEx")) {
            Permission_PermissionsEx ePerms = new Permission_PermissionsEx(this);
            this.sm.register(Permission.class, (Object)ePerms, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Permission] PermissionsEx found: %s", this.getDescription().getName(), ((Permission)ePerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.platymuus.bukkit.permissions.PermissionsPlugin")) {
            Permission_PermissionsBukkit pPerms = new Permission_PermissionsBukkit(this);
            this.sm.register(Permission.class, (Object)pPerms, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Permission] PermissionsBukkit found: %s", this.getDescription().getName(), ((Permission)pPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("de.bananaco.bpermissions.api.WorldManager")) {
            bPerms = new Permission_bPermissions2(this);
            this.sm.register(Permission.class, (Object)bPerms, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Chat] bPermissions found: %s", this.getDescription().getName(), bPerms.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("org.tyrannyofheaven.bukkit.zPermissions")) {
            Permission_zPermissions zPerms = new Permission_zPermissions(this);
            this.sm.register(Permission.class, (Object)zPerms, (Plugin)this, ServicePriority.Highest);
            log.info(String.format("[%s][Permission] GroupManager found: %s", this.getDescription().getName(), ((Permission)zPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("de.bananaco.permissions.SuperPermissionHandler")) {
            bPerms = new Permission_bPermissions(this);
            this.sm.register(Permission.class, (Object)bPerms, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Permission] bPermissions found: %s", this.getDescription().getName(), bPerms.isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("org.anjocaido.groupmanager.GroupManager")) {
            Permission_GroupManager gPerms = new Permission_GroupManager(this);
            this.sm.register(Permission.class, (Object)gPerms, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Permission] GroupManager found: %s", this.getDescription().getName(), ((Permission)gPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        if (Vault.packageExists("com.nijiko.permissions.ModularControl")) {
            Permission_Permissions3 nPerms = new Permission_Permissions3(this);
            this.sm.register(Permission.class, (Object)nPerms, (Plugin)this, ServicePriority.High);
            log.info(String.format("[%s][Permission] Permissions 3 (Yeti) found: %s", this.getDescription().getName(), ((Permission)nPerms).isEnabled() ? "Loaded" : "Waiting"));
        }
        Permission_SuperPerms perms = new Permission_SuperPerms(this);
        this.sm.register(Permission.class, (Object)perms, (Plugin)this, ServicePriority.Lowest);
        log.info(String.format("[%s][Permission] SuperPermissions loaded as backup permission system.", this.getDescription().getName()));
        this.perms = (Permission)this.sm.getRegistration(Permission.class).getProvider();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        Player p;
        if (sender instanceof Player && !(p = (Player)sender).isOp()) {
            return true;
        }
        if (command.getName().equalsIgnoreCase("vault-info")) {
            this.infoCommand(sender);
            return true;
        }
        if (command.getName().equalsIgnoreCase("vault-convert")) {
            this.convertCommand(sender, args);
            return true;
        }
        sender.sendMessage("Vault Commands:");
        sender.sendMessage("  /vault-info - Displays information about Vault");
        sender.sendMessage("  /vault-convert [economy1] [economy2] - Converts from one Economy to another");
        return true;
    }

    private void convertCommand(CommandSender sender, String[] args) {
        Collection econs = this.getServer().getServicesManager().getRegistrations(Economy.class);
        if (econs == null || econs.size() < 2) {
            sender.sendMessage("You must have at least 2 economies loaded to convert.");
            return;
        }
        if (args.length != 2) {
            sender.sendMessage("You must specify only the economy to convert from and the economy to convert to. (without spaces)");
            return;
        }
        Economy econ1 = null;
        Economy econ2 = null;
        for (RegisteredServiceProvider econ : econs) {
            String econName = ((Economy)econ.getProvider()).getName().replace(" ", "");
            if (econName.equalsIgnoreCase(args[0])) {
                econ1 = (Economy)econ.getProvider();
                continue;
            }
            if (!econName.equalsIgnoreCase(args[1])) continue;
            econ2 = (Economy)econ.getProvider();
        }
        if (econ1 == null) {
            sender.sendMessage("Could not find " + args[0] + " loaded on the server, check your spelling");
            return;
        }
        if (econ2 == null) {
            sender.sendMessage("Could not find " + args[1] + " loaded on the server, check your spelling");
            return;
        }
        sender.sendMessage("This may take some time to convert, expect server lag.");
        for (OfflinePlayer op : Bukkit.getServer().getOfflinePlayers()) {
            String pName = op.getName();
            if (!econ1.hasAccount(pName) || econ2.hasAccount(pName)) continue;
            econ2.createPlayerAccount(pName);
            econ2.depositPlayer(pName, econ1.getBalance(pName));
        }
    }

    private void infoCommand(CommandSender sender) {
        Object perm2;
        String registeredEcons = null;
        Collection econs = this.getServer().getServicesManager().getRegistrations(Economy.class);
        for (RegisteredServiceProvider econ : econs) {
            Economy e = (Economy)econ.getProvider();
            if (registeredEcons == null) {
                registeredEcons = e.getName();
                continue;
            }
            registeredEcons = registeredEcons + ", " + e.getName();
        }
        String registeredPerms = null;
        Collection perms = this.getServer().getServicesManager().getRegistrations(Permission.class);
        for (Object perm2 : perms) {
            Permission p = (Permission)perm2.getProvider();
            if (registeredPerms == null) {
                registeredPerms = p.getName();
                continue;
            }
            registeredPerms = registeredPerms + ", " + p.getName();
        }
        Economy econ = (Economy)this.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
        perm2 = (Permission)this.getServer().getServicesManager().getRegistration(Permission.class).getProvider();
        sender.sendMessage(String.format("[%s] Vault v%s Information", this.getDescription().getName(), this.getDescription().getVersion()));
        sender.sendMessage(String.format("[%s] Economy: %s [%s]", this.getDescription().getName(), econ.getName(), registeredEcons));
        sender.sendMessage(String.format("[%s] Permission: %s [%s]", this.getDescription().getName(), ((Permission)perm2).getName(), registeredPerms));
    }

    private static boolean packageExists(String ... packages) {
        try {
            for (String pkg : packages) {
                Class.forName(pkg);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public double updateCheck(double currentVersion) throws Exception {
        String pluginUrlString = "http://dev.bukkit.org/server-mods/vault/files.rss";
        try {
            URL url = new URL(pluginUrlString);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url.openConnection().getInputStream());
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName("item");
            Node firstNode = nodes.item(0);
            if (firstNode.getNodeType() == 1) {
                Element firstElement = (Element)firstNode;
                NodeList firstElementTagName = firstElement.getElementsByTagName("title");
                Element firstNameElement = (Element)firstElementTagName.item(0);
                NodeList firstNodes = firstNameElement.getChildNodes();
                return Double.valueOf(firstNodes.item(0).getNodeValue().replace("Vault", "").replaceFirst(".", "").trim());
            }
        }
        catch (Exception localException) {
            // empty catch block
        }
        return currentVersion;
    }

    public class VaultListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (Vault.this.perms.has(player, "vault.admin")) {
                try {
                    if (Vault.this.newVersion > Vault.this.currentVersion) {
                        player.sendMessage(Vault.this.newVersion + " is out! You are running " + Vault.this.currentVersion);
                        player.sendMessage("Update Vault at: http://dev.bukkit.org/server-mods/vault");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            if (event.getPlugin().getDescription().getName().equals("Register") && Vault.packageExists(new String[]{"com.nijikokun.register.payment.Methods"}) && !Methods.hasMethod()) {
                try {
                    Method m = Methods.class.getMethod("addMethod", Methods.class);
                    m.setAccessible(true);
                    m.invoke(null, "Vault", new VaultEco());
                    if (!Methods.setPreferred((String)"Vault")) {
                        log.info("Unable to hook register");
                    } else {
                        log.info("[Vault] - Successfully injected Vault methods into Register.");
                    }
                }
                catch (SecurityException e) {
                    log.info("Unable to hook register");
                }
                catch (NoSuchMethodException e) {
                    log.info("Unable to hook register");
                }
                catch (IllegalArgumentException e) {
                    log.info("Unable to hook register");
                }
                catch (IllegalAccessException e) {
                    log.info("Unable to hook register");
                }
                catch (InvocationTargetException e) {
                    log.info("Unable to hook register");
                }
            }
        }
    }
}

