/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.mavenplugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

@Mojo(name="remap", defaultPhase=LifecyclePhase.PACKAGE)
public class RemapMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", required=true, readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private String finalName;
    @Parameter(defaultValue="${project.artifactId}")
    private String remappedArtifactId;
    @Parameter
    private boolean remappedArtifactAttached;
    @Parameter(defaultValue="remapped")
    private String remappedClassifierName;
    @Parameter(required=true)
    private String srgIn;
    @Parameter
    private File accessIn;
    @Parameter
    private File inputFile;
    @Parameter
    private File logFile;
    @Parameter
    private boolean reverse;
    @Parameter
    private boolean numeric;
    @Parameter
    private boolean generateAPI;
    @Parameter
    private String inShadeRelocation;
    @Parameter
    private String outShadeRelocation;
    @Parameter
    private String[] remappedDependencies = new String[0];
    @Parameter
    private String[] excludedPackages;
    @Parameter(defaultValue="true")
    private boolean useProjectDependencies;

    private File resolveArtifact(String artifactString) throws ArtifactResolutionException, ArtifactNotFoundException, MojoExecutionException {
        String[] array = artifactString.split(":");
        if (array.length != 4 && array.length != 5) {
            throw new MojoExecutionException("Invalid artifact dependency name, must be groupId:artifactId:version:type:classifier " + artifactString + " in " + array.length);
        }
        String groupId = array[0];
        String artifactId = array[1];
        String version = array[2];
        String type = array[3];
        String classifier = array.length > 4 ? array[4] : null;
        return this.resolveArtifact(groupId, artifactId, version, type, classifier);
    }

    private File resolveArtifact(String groupId, String artifactId, String version, String type, String classifier) throws ArtifactResolutionException, ArtifactNotFoundException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, type, version);
        ArtifactRequest remoteRequest = new ArtifactRequest((Artifact)artifact, this.remoteRepositories, null);
        ArtifactResult remoteResult = this.repoSystem.resolveArtifact(this.repoSession, remoteRequest);
        return remoteResult.getArtifact().getFile();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getArtifact().getFile() == null || !this.project.getArtifact().getFile().isFile()) {
            if (this.project.getGroupId().equals("net.md-5") && this.project.getName().equals("ForgeMod")) {
                System.out.println("Ignoring no main project artifact for ForgeMod parent project");
                return;
            }
            this.getLog().error((CharSequence)"The project main artifact does not exist. This could have the following");
            this.getLog().error((CharSequence)"reasons:");
            this.getLog().error((CharSequence)"- You have invoked the goal directly from the command line. This is not");
            this.getLog().error((CharSequence)"  supported. Please add the goal to the default lifecycle via an");
            this.getLog().error((CharSequence)"  <execution> element in your POM and use \"mvn package\" to have it run.");
            this.getLog().error((CharSequence)"- You have bound the goal to a lifecycle phase before \"package\". Please");
            this.getLog().error((CharSequence)"  remove this binding from your POM such that the goal will be run in");
            this.getLog().error((CharSequence)"  the proper phase.");
            this.getLog().error((CharSequence)"- You removed the configuration of the maven-jar-plugin that produces the main artifact.");
            throw new MojoExecutionException("Failed to create remapped artifact, project main artifact does not exist.");
        }
        if (this.inputFile == null) {
            this.inputFile = this.project.getArtifact().getFile();
        }
        File outputFile = this.remappedArtifactFileWithClassifier();
        try {
            JarMapping mapping = new JarMapping();
            if (this.excludedPackages != null) {
                for (String packageName : this.excludedPackages) {
                    mapping.addExcludedPackage(packageName);
                }
            }
            if (this.srgIn.contains(":") && this.srgIn.length() > 1 && this.srgIn.charAt(1) != ':') {
                this.srgIn = this.resolveArtifact(this.srgIn).getPath();
            }
            mapping.loadMappings(this.srgIn, this.reverse, this.numeric, this.inShadeRelocation, this.outShadeRelocation);
            Jar inputJar = Jar.init((File)this.inputFile);
            JointProvider inheritanceProviders = new JointProvider();
            for (String artifactString : this.remappedDependencies) {
                File dependencyFile = this.resolveArtifact(artifactString);
                System.out.println("Adding inheritance " + dependencyFile.getPath());
                inheritanceProviders.add((InheritanceProvider)new JarProvider(Jar.init((File)dependencyFile)));
            }
            if (this.useProjectDependencies) {
                for (Dependency dependency : this.project.getDependencies()) {
                    if (!dependency.getType().equals("jar")) continue;
                    File dependencyFile = this.resolveArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
                    System.out.println("Adding inheritance " + dependencyFile.getPath());
                    inheritanceProviders.add((InheritanceProvider)new JarProvider(Jar.init((File)dependencyFile)));
                }
            }
            inheritanceProviders.add((InheritanceProvider)new JarProvider(inputJar));
            mapping.setFallbackInheritanceProvider((InheritanceProvider)inheritanceProviders);
            RemapperProcessor accessMapper = null;
            if (this.accessIn != null) {
                AccessMap access = new AccessMap();
                access.loadAccessTransformer(this.accessIn);
                accessMapper = new RemapperProcessor(null, mapping, access);
            }
            JarRemapper remapper = new JarRemapper(null, mapping, accessMapper);
            remapper.setGenerateAPI(this.generateAPI);
            if (this.logFile != null) {
                remapper.setLogFile(this.logFile);
            }
            remapper.remapJar(inputJar, outputFile);
            boolean renamed = false;
            if (this.finalName != null && this.finalName.length() > 0 && !this.finalName.equals(this.project.getBuild().getFinalName())) {
                String finalFileName = this.finalName + "." + this.project.getArtifact().getArtifactHandler().getExtension();
                File finalFile = new File(this.outputDirectory, finalFileName);
                this.replaceFile(finalFile, outputFile);
                renamed = true;
            }
            if (this.remappedArtifactAttached) {
                this.getLog().info((CharSequence)"Attaching remapped artifact.");
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.remappedClassifierName, outputFile);
            } else if (!renamed) {
                this.getLog().info((CharSequence)"Replacing original artifact with remapped artifact.");
                File originalArtifact = this.project.getArtifact().getFile();
                this.replaceFile(originalArtifact, outputFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MojoExecutionException("Error creating remapped jar: " + ex.getMessage(), ex);
        }
    }

    private File remappedArtifactFileWithClassifier() {
        org.apache.maven.artifact.Artifact artifact = this.project.getArtifact();
        String shadedName = this.remappedArtifactId + "-" + artifact.getVersion() + "-" + this.remappedClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    Files.copy((File)oldFile, (File)origFile);
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    Files.copy((File)newFile, (File)oldFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with remapped artifact!", (Exception)ex);
                }
            }
        }
    }
}

