/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.scriptus;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="describe", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class DescribeMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="git-${project.name}-%s")
    private String format;
    @Parameter(defaultValue="describe")
    private String descriptionProperty;
    @Parameter(defaultValue="false")
    private boolean override;
    @Parameter(property="maven.changeSet.scmDirectory", defaultValue="${project.basedir}")
    private File scmDirectory;
    @Parameter(defaultValue="unknown")
    private String failHash;
    @Parameter(defaultValue="false")
    private boolean fail;
    @Parameter(defaultValue="7")
    private int hashLength;
    @Parameter(defaultValue="project.build.outputTimestamp")
    private String timeProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        int commitTime;
        String gitHash;
        block18: {
            gitHash = null;
            commitTime = -1;
            try (Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.scmDirectory)).build();){
                ObjectId head = repository.resolve("HEAD");
                if (head != null) {
                    try (ObjectReader reader = repository.newObjectReader();){
                        gitHash = reader.abbreviate((AnyObjectId)head, this.hashLength).name();
                        try (RevWalk walk = new RevWalk(reader);){
                            commitTime = walk.parseCommit((AnyObjectId)head).getCommitTime();
                            break block18;
                        }
                    }
                }
                this.getLog().warn((CharSequence)"Warning: Repository has no commits!");
            }
            catch (RepositoryNotFoundException ex) {
                if (this.fail) {
                    throw new MojoExecutionException("Could not find Git repository", (Exception)((Object)ex));
                }
                this.getLog().warn((CharSequence)("Could not find Git repository in " + this.scmDirectory));
            }
            catch (Exception ex) {
                if (this.fail) {
                    throw new MojoExecutionException("Exception reading Git repository", ex);
                }
                this.getLog().warn((CharSequence)("Failed to get HEAD commit hash: " + ex.getClass().getName() + ":" + ex.getMessage()));
            }
        }
        this.setProperty(this.descriptionProperty, String.format(this.format, gitHash == null ? this.failHash : gitHash), this.override);
        boolean overrideTime = true;
        if (this.project.getProperties().containsKey(this.timeProperty)) {
            try {
                commitTime = Math.max(commitTime, Integer.parseInt(this.project.getProperties().getProperty(this.timeProperty)));
            }
            catch (NumberFormatException ex) {
                overrideTime = this.override;
            }
        }
        this.setProperty(this.timeProperty, Integer.toString(commitTime == -1 ? (int)(System.currentTimeMillis() / 1000L) : commitTime), overrideTime);
    }

    private void setProperty(String property, String value, boolean override) {
        if (property == null || property.isEmpty()) {
            return;
        }
        if (!override && this.project.getProperties().containsKey(property)) {
            this.getLog().warn((CharSequence)String.format("Property \"%s\" already set to \"%s\"", property, this.project.getProperties().getProperty(property)));
            return;
        }
        this.project.getProperties().put(property, value);
        this.getLog().info((CharSequence)String.format("Set property \"%s\" to \"%s\"", property, value));
    }
}

