/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;

public class UpstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;

    public UpstreamBridge(ProxyServer bungee, UserConnection con) {
        this.bungee = bungee;
        this.con = con;
        BungeeCord.getInstance().addConnection(con);
        con.getTabListHandler().onConnect();
        con.unsafe().sendPacket((DefinedPacket)BungeeCord.getInstance().registerChannels());
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.con.disconnect(Util.exception((Throwable)t));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        PlayerDisconnectEvent event = new PlayerDisconnectEvent((ProxiedPlayer)this.con);
        this.bungee.getPluginManager().callEvent((Event)event);
        this.con.getTabListHandler().onDisconnect();
        BungeeCord.getInstance().removeConnection(this.con);
        if (this.con.getServer() != null) {
            PlayerListItem packet = new PlayerListItem();
            packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
            PlayerListItem.Item item = new PlayerListItem.Item();
            item.setUuid(this.con.getUniqueId());
            packet.setItems(new PlayerListItem.Item[]{item});
            for (ProxiedPlayer player : this.con.getServer().getInfo().getPlayers()) {
                if (player.getPendingConnection().getVersion() < 47) continue;
                player.unsafe().sendPacket((DefinedPacket)packet);
            }
            this.con.getServer().disconnect("Quitting");
        }
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        this.con.getEntityRewrite().rewriteServerbound(packet.buf, this.con.getClientEntityId(), this.con.getServerEntityId());
        if (this.con.getServer() != null) {
            this.con.getServer().getCh().write(packet);
        }
    }

    public void handle(KeepAlive alive) throws Exception {
        if (alive.getRandomId() == this.con.getSentPingId()) {
            int newPing = (int)(System.currentTimeMillis() - this.con.getSentPingTime());
            this.con.getTabListHandler().onPingChange(newPing);
            this.con.setPing(newPing);
        }
    }

    public void handle(Chat chat) throws Exception {
        Preconditions.checkArgument((chat.getMessage().length() <= 100 ? 1 : 0) != 0, (Object)"Chat message too long");
        ChatEvent chatEvent = new ChatEvent((Connection)this.con, (Connection)this.con.getServer(), chat.getMessage());
        if (!((ChatEvent)this.bungee.getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
            chat.setMessage(chatEvent.getMessage());
            if (!chatEvent.isCommand() || !this.bungee.getPluginManager().dispatchCommand((CommandSender)this.con, chat.getMessage().substring(1))) {
                this.con.getServer().unsafe().sendPacket((DefinedPacket)chat);
            }
        }
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(TabCompleteRequest tabComplete) throws Exception {
        ArrayList suggestions = new ArrayList();
        if (tabComplete.getCursor().startsWith("/")) {
            this.bungee.getPluginManager().dispatchCommand((CommandSender)this.con, tabComplete.getCursor().substring(1), suggestions);
        }
        TabCompleteEvent tabCompleteEvent = new TabCompleteEvent((Connection)this.con, (Connection)this.con.getServer(), tabComplete.getCursor(), suggestions);
        this.bungee.getPluginManager().callEvent((Event)tabCompleteEvent);
        if (tabCompleteEvent.isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        List results = tabCompleteEvent.getSuggestions();
        if (!results.isEmpty()) {
            this.con.unsafe().sendPacket((DefinedPacket)new TabCompleteResponse(results));
            throw CancelSendSignal.INSTANCE;
        }
    }

    public void handle(ClientSettings settings) throws Exception {
        this.con.setSettings(settings);
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("BungeeCord")) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("FML") && pluginMessage.getStream().readUnsignedByte() == 1) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("FML|HS")) {
            this.con.getForgeClientHandler().handle(pluginMessage);
            throw CancelSendSignal.INSTANCE;
        }
        if (this.con.getServer() != null && !this.con.getServer().isForgeServer() && pluginMessage.getData().length > Short.MAX_VALUE) {
            throw CancelSendSignal.INSTANCE;
        }
        PluginMessageEvent event = new PluginMessageEvent((Connection)this.con, (Connection)this.con.getServer(), pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (((PluginMessageEvent)this.bungee.getPluginManager().callEvent((Event)event)).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.con.getPendingConnection().getRegisterMessages().add(pluginMessage);
        }
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] -> UpstreamBridge";
    }
}

