/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import io.netty.channel.ChannelHandler;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerHandshakeEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.http.HttpClient;
import net.md_5.bungee.jni.cipher.BungeeCipher;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.cipher.CipherDecoder;
import net.md_5.bungee.netty.cipher.CipherEncoder;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.util.BoundedArrayList;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Handshake handshake;
    private LoginRequest loginRequest;
    private EncryptionRequest request;
    private final List<PluginMessage> registerMessages = new BoundedArrayList<PluginMessage>(128);
    private State thisState = State.HANDSHAKE;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private boolean onlineMode;
    private InetSocketAddress virtualHost;
    private UUID uniqueId;
    private UUID offlineId;
    private LoginResult loginProfile;
    private boolean legacy;
    private String extraDataInHandshake;

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.disconnect(ChatColor.RED + Util.exception((Throwable)t));
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.registerMessages.add(pluginMessage);
        }
    }

    public void handle(LegacyHandshake legacyHandshake) throws Exception {
        this.legacy = true;
        this.ch.getHandle().writeAndFlush((Object)this.bungee.getTranslation("outdated_client", new Object[0]));
        this.ch.close();
    }

    public void handle(LegacyPing ping) throws Exception {
        this.legacy = true;
        final boolean v1_5 = ping.isV1_5();
        ServerPing legacy = new ServerPing(new ServerPing.Protocol(this.bungee.getName() + " " + this.bungee.getGameVersion(), this.bungee.getProtocolVersion()), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount(), null), this.listener.getMotd(), (Favicon)null);
        Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

            public void done(ProxyPingEvent result, Throwable error) {
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                ServerPing legacy = result.getResponse();
                String kickMessage = v1_5 ? ChatColor.DARK_BLUE + "\u0000" + 127 + '\u0000' + legacy.getVersion().getName() + '\u0000' + InitialHandler.getFirstLine(legacy.getDescription()) + '\u0000' + legacy.getPlayers().getOnline() + '\u0000' + legacy.getPlayers().getMax() : ChatColor.stripColor((String)InitialHandler.getFirstLine(legacy.getDescription())) + '\u00a7' + legacy.getPlayers().getOnline() + '\u00a7' + legacy.getPlayers().getMax();
                InitialHandler.this.ch.getHandle().writeAndFlush((Object)kickMessage);
                InitialHandler.this.ch.close();
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new ProxyPingEvent((PendingConnection)this, legacy, (Callback)callback));
    }

    private static String getFirstLine(String str) {
        int pos = str.indexOf(10);
        return pos == -1 ? str : str.substring(0, pos);
    }

    public void handle(StatusRequest statusRequest) throws Exception {
        Preconditions.checkState((this.thisState == State.STATUS ? 1 : 0) != 0, (Object)"Not expecting STATUS");
        ServerInfo forced = AbstractReconnectHandler.getForcedHost((PendingConnection)this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = new ServerPing();
                    result.setDescription(InitialHandler.this.bungee.getTranslation("ping_cannot_connect", new Object[0]));
                    InitialHandler.this.bungee.getLogger().log(Level.WARNING, "Error pinging remote server", error);
                }
                Callback<ProxyPingEvent> callback = new Callback<ProxyPingEvent>(){

                    public void done(ProxyPingEvent pingResult, Throwable error) {
                        BungeeCord.getInstance().getConnectionThrottle().unthrottle(InitialHandler.this.getAddress().getAddress());
                        Gson gson = InitialHandler.this.handshake.getProtocolVersion() == 4 ? BungeeCord.getInstance().gsonLegacy : BungeeCord.getInstance().gson;
                        InitialHandler.this.unsafe.sendPacket((DefinedPacket)new StatusResponse(gson.toJson((Object)pingResult.getResponse())));
                    }
                };
                InitialHandler.this.bungee.getPluginManager().callEvent((Event)new ProxyPingEvent((PendingConnection)InitialHandler.this, result, (Callback)callback));
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            ((BungeeServerInfo)forced).ping(pingBack, this.handshake.getProtocolVersion());
        } else {
            int protocol = Protocol.supportedVersions.contains(this.handshake.getProtocolVersion()) ? this.handshake.getProtocolVersion() : this.bungee.getProtocolVersion();
            pingBack.done((Object)new ServerPing(new ServerPing.Protocol(this.bungee.getName() + " " + this.bungee.getGameVersion(), protocol), new ServerPing.Players(this.listener.getMaxPlayers(), this.bungee.getOnlineCount(), null), motd, BungeeCord.getInstance().config.getFaviconObject()), null);
        }
        this.thisState = State.PING;
    }

    public void handle(PingPacket ping) throws Exception {
        Preconditions.checkState((this.thisState == State.PING ? 1 : 0) != 0, (Object)"Not expecting PING");
        this.unsafe.sendPacket((DefinedPacket)ping);
        this.disconnect("");
    }

    public void handle(Handshake handshake) throws Exception {
        Preconditions.checkState((this.thisState == State.HANDSHAKE ? 1 : 0) != 0, (Object)"Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.ch.setVersion(handshake.getProtocolVersion());
        if (handshake.getHost().contains("\u0000")) {
            String[] split = handshake.getHost().split("\u0000", 2);
            handshake.setHost(split[0]);
            this.extraDataInHandshake = "\u0000" + split[1];
        }
        if (handshake.getHost().endsWith(".")) {
            handshake.setHost(handshake.getHost().substring(0, handshake.getHost().length() - 1));
        }
        this.virtualHost = InetSocketAddress.createUnresolved(handshake.getHost(), handshake.getPort());
        this.bungee.getLogger().log(Level.INFO, "{0} has connected", (Object)this);
        this.bungee.getPluginManager().callEvent((Event)new PlayerHandshakeEvent((PendingConnection)this, handshake));
        switch (handshake.getRequestedProtocol()) {
            case 1: {
                this.thisState = State.STATUS;
                this.ch.setProtocol(Protocol.STATUS);
                break;
            }
            case 2: {
                this.thisState = State.USERNAME;
                this.ch.setProtocol(Protocol.LOGIN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot request protocol " + handshake.getRequestedProtocol());
            }
        }
    }

    public void handle(LoginRequest loginRequest) throws Exception {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Not expecting USERNAME");
        this.loginRequest = loginRequest;
        if (!Protocol.supportedVersions.contains(this.handshake.getProtocolVersion())) {
            this.disconnect(this.bungee.getTranslation("outdated_server", new Object[0]));
            return;
        }
        if (this.getName().contains(".")) {
            this.disconnect(this.bungee.getTranslation("name_invalid", new Object[0]));
            return;
        }
        if (this.getName().length() > 16) {
            this.disconnect(this.bungee.getTranslation("name_too_long", new Object[0]));
            return;
        }
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        if (limit > 0 && this.bungee.getOnlineCount() > limit) {
            this.disconnect(this.bungee.getTranslation("proxy_full", new Object[0]));
            return;
        }
        if (!this.isOnlineMode() && this.bungee.getPlayer(this.getUniqueId()) != null) {
            this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            return;
        }
        Callback<PreLoginEvent> callback = new Callback<PreLoginEvent>(){

            public void done(PreLoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                    return;
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                if (InitialHandler.this.onlineMode) {
                    InitialHandler.this.unsafe().sendPacket((DefinedPacket)(InitialHandler.this.request = EncryptionUtil.encryptRequest()));
                } else {
                    InitialHandler.this.finish();
                }
                InitialHandler.this.thisState = State.ENCRYPT;
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new PreLoginEvent((PendingConnection)this, (Callback)callback));
    }

    public void handle(EncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState((this.thisState == State.ENCRYPT ? 1 : 0) != 0, (Object)"Not expecting ENCRYPT");
        SecretKey sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        BungeeCipher decrypt = EncryptionUtil.getCipher(false, sharedKey);
        this.ch.addBefore("frame-decoder", "decrypt", (ChannelHandler)new CipherDecoder(decrypt));
        BungeeCipher encrypt = EncryptionUtil.getCipher(true, sharedKey);
        this.ch.addBefore("frame-prepender", "encrypt", (ChannelHandler)new CipherEncoder(encrypt));
        String encName = URLEncoder.encode(this.getName(), "UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        for (byte[] bit : new byte[][]{this.request.getServerId().getBytes("ISO_8859_1"), sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
            sha.update(bit);
        }
        String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
        String authURL = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=" + encName + "&serverId=" + encodedHash;
        Callback<String> handler = new Callback<String>(){

            public void done(String result, Throwable error) {
                if (error == null) {
                    LoginResult obj = (LoginResult)BungeeCord.getInstance().gson.fromJson(result, LoginResult.class);
                    if (obj != null) {
                        InitialHandler.this.loginProfile = obj;
                        InitialHandler.this.uniqueId = Util.getUUID((String)obj.getId());
                        InitialHandler.this.finish();
                        return;
                    }
                    InitialHandler.this.disconnect("Not authenticated with Minecraft.net");
                } else {
                    InitialHandler.this.disconnect(InitialHandler.this.bungee.getTranslation("mojang_fail", new Object[0]));
                    InitialHandler.this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + InitialHandler.this.getName() + " with minecraft.net", error);
                }
            }
        };
        HttpClient.get(authURL, this.ch.getHandle().eventLoop(), handler);
    }

    private void finish() {
        ProxiedPlayer oldName;
        if (this.isOnlineMode()) {
            ProxiedPlayer oldID;
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                oldName.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
            if ((oldID = this.bungee.getPlayer(this.getUniqueId())) != null) {
                oldID.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
            }
        } else {
            oldName = this.bungee.getPlayer(this.getName());
            if (oldName != null) {
                this.disconnect(this.bungee.getTranslation("already_connected_proxy", new Object[0]));
                return;
            }
        }
        this.offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(Charsets.UTF_8));
        if (this.uniqueId == null) {
            this.uniqueId = this.offlineId;
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                    return;
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                InitialHandler.this.ch.getHandle().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (InitialHandler.this.ch.getHandle().isActive()) {
                            UserConnection userCon = new UserConnection(InitialHandler.this.bungee, InitialHandler.this.ch, InitialHandler.this.getName(), InitialHandler.this);
                            userCon.setCompressionThreshold(BungeeCord.getInstance().config.getCompressionThreshold());
                            userCon.init();
                            if (InitialHandler.this.getVersion() >= 5) {
                                InitialHandler.this.unsafe.sendPacket((DefinedPacket)new LoginSuccess(InitialHandler.this.getUniqueId().toString(), InitialHandler.this.getName()));
                            } else {
                                InitialHandler.this.unsafe.sendPacket((DefinedPacket)new LoginSuccess(InitialHandler.this.getUUID(), InitialHandler.this.getName()));
                            }
                            InitialHandler.this.ch.setProtocol(Protocol.GAME);
                            ((HandlerBoss)InitialHandler.this.ch.getHandle().pipeline().get(HandlerBoss.class)).setHandler(new UpstreamBridge(InitialHandler.this.bungee, userCon));
                            InitialHandler.this.bungee.getPluginManager().callEvent((Event)new PostLoginEvent((ProxiedPlayer)userCon));
                            ServerInfo server = InitialHandler.this.bungee.getReconnectHandler() != null ? InitialHandler.this.bungee.getReconnectHandler().getServer((ProxiedPlayer)userCon) : AbstractReconnectHandler.getForcedHost((PendingConnection)InitialHandler.this);
                            if (server == null) {
                                server = InitialHandler.this.bungee.getServerInfo(InitialHandler.this.listener.getDefaultServer());
                            }
                            userCon.connect(server, null, true);
                            InitialHandler.this.thisState = State.FINISHED;
                        }
                    }
                });
            }
        };
        this.bungee.getPluginManager().callEvent((Event)new LoginEvent((PendingConnection)this, (Callback)complete));
    }

    public void disconnect(String reason) {
        this.disconnect(TextComponent.fromLegacyText((String)reason));
    }

    public void disconnect(final BaseComponent ... reason) {
        if (!this.ch.isClosed()) {
            this.ch.getHandle().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (InitialHandler.this.thisState != State.STATUS && InitialHandler.this.thisState != State.PING) {
                        InitialHandler.this.unsafe().sendPacket((DefinedPacket)new Kick(ComponentSerializer.toString((BaseComponent[])reason)));
                    }
                    InitialHandler.this.ch.close();
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void disconnect(BaseComponent reason) {
        this.disconnect(new BaseComponent[]{reason});
    }

    public String getName() {
        return this.loginRequest == null ? null : this.loginRequest.getData();
    }

    public int getVersion() {
        return this.handshake == null ? -1 : this.handshake.getProtocolVersion();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    public void setOnlineMode(boolean onlineMode) {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Can only set online mode status whilst state is username");
        this.onlineMode = onlineMode;
    }

    public void setUniqueId(UUID uuid) {
        Preconditions.checkState((this.thisState == State.USERNAME ? 1 : 0) != 0, (Object)"Can only set uuid while state is username");
        Preconditions.checkState((!this.onlineMode ? 1 : 0) != 0, (Object)"Can only set uuid when online mode is false");
        this.uniqueId = uuid;
    }

    public String getUUID() {
        return this.uniqueId.toString().replaceAll("-", "");
    }

    @Override
    public String toString() {
        return "[" + (this.getName() != null ? this.getName() : this.getAddress()) + "] <-> InitialHandler";
    }

    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public InitialHandler(ProxyServer bungee, ListenerInfo listener) {
        this.onlineMode = BungeeCord.getInstance().config.isOnlineMode();
        this.extraDataInHandshake = "";
        this.bungee = bungee;
        this.listener = listener;
    }

    public ListenerInfo getListener() {
        return this.listener;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public LoginRequest getLoginRequest() {
        return this.loginRequest;
    }

    public List<PluginMessage> getRegisterMessages() {
        return this.registerMessages;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public UUID getOfflineId() {
        return this.offlineId;
    }

    public LoginResult getLoginProfile() {
        return this.loginProfile;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String getExtraDataInHandshake() {
        return this.extraDataInHandshake;
    }

    private static enum State {
        HANDSHAKE,
        STATUS,
        PING,
        USERNAME,
        ENCRYPT,
        FINISHED;

    }
}

