/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.conf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig
implements ConfigurationAdapter {
    private final Yaml yaml;
    private Map config;
    private final File file = new File("config.yml");

    public YamlConfig() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(options);
    }

    public void load() {
        Map groups;
        try {
            this.file.createNewFile();
            try (FileInputStream is = new FileInputStream(this.file);){
                this.config = (Map)this.yaml.load((InputStream)is);
            }
            this.config = this.config == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(this.config);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load configuration!", ex);
        }
        Map permissions = this.get("permissions", new HashMap());
        if (permissions.isEmpty()) {
            permissions.put("default", Arrays.asList("bungeecord.command.server", "bungeecord.command.list"));
            permissions.put("admin", Arrays.asList("bungeecord.command.alert", "bungeecord.command.end", "bungeecord.command.ip", "bungeecord.command.reload"));
        }
        if ((groups = (Map)this.get("groups", new HashMap())).isEmpty()) {
            groups.put("md_5", Collections.singletonList("admin"));
        }
    }

    private <T> T get(String path, T def) {
        return this.get(path, def, this.config);
    }

    private <T> T get(String path, T def, Map submap) {
        int index = path.indexOf(46);
        if (index == -1) {
            Object val = submap.get(path);
            if (val == null && def != null) {
                val = def;
                submap.put(path, def);
                this.save();
            }
            return (T)val;
        }
        String first = path.substring(0, index);
        String second = path.substring(index + 1, path.length());
        LinkedHashMap sub = (LinkedHashMap)submap.get(first);
        if (sub == null) {
            sub = new LinkedHashMap();
            submap.put(first, sub);
        }
        return this.get(second, def, sub);
    }

    private void save() {
        try (FileWriter wr = new FileWriter(this.file);){
            this.yaml.dump((Object)this.config, (Writer)wr);
        }
        catch (IOException ex) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not save config", ex);
        }
    }

    public int getInt(String path, int def) {
        return this.get(path, def);
    }

    public String getString(String path, String def) {
        return this.get(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.get(path, def);
    }

    public Map<String, ServerInfo> getServers() {
        Map base = this.get("servers", Collections.singletonMap("lobby", new HashMap()));
        HashMap<String, ServerInfo> ret = new HashMap<String, ServerInfo>();
        for (Map.Entry entry : base.entrySet()) {
            Map val = entry.getValue();
            String name = entry.getKey();
            String addr = this.get("address", "localhost:25565", val);
            String motd = ChatColor.translateAlternateColorCodes((char)'&', (String)this.get("motd", "&1Just another BungeeCord - Forced Host", val));
            boolean restricted = this.get("restricted", false, val);
            InetSocketAddress address = Util.getAddr((String)addr);
            ServerInfo info = ProxyServer.getInstance().constructServerInfo(name, address, motd, restricted);
            ret.put(name, info);
        }
        return ret;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Collection<ListenerInfo> getListeners() {
        Collection base = this.get("listeners", Arrays.asList(new HashMap()));
        HashMap<String, String> forcedDef = new HashMap<String, String>();
        forcedDef.put("pvp.md-5.net", "pvp");
        HashSet<ListenerInfo> ret = new HashSet<ListenerInfo>();
        for (Map val : base) {
            String motd = this.get("motd", "&1Another Bungee server", val);
            motd = ChatColor.translateAlternateColorCodes((char)'&', (String)motd);
            int maxPlayers = this.get("max_players", 1, val);
            String defaultServer = this.get("default_server", "lobby", val);
            String fallbackServer = this.get("fallback_server", defaultServer, val);
            boolean forceDefault = this.get("force_default_server", false, val);
            String host = this.get("host", "0.0.0.0:25577", val);
            int tabListSize = this.get("tab_size", 60, val);
            InetSocketAddress address = Util.getAddr((String)host);
            CaseInsensitiveMap forced = new CaseInsensitiveMap((Map)this.get("forced_hosts", forcedDef, val));
            String tabListName = this.get("tab_list", "GLOBAL_PING", val);
            DefaultTabList value = DefaultTabList.valueOf(tabListName.toUpperCase());
            if (value == null) {
                value = DefaultTabList.GLOBAL_PING;
            }
            boolean setLocalAddress = this.get("bind_local_address", true, val);
            boolean pingPassthrough = this.get("ping_passthrough", false, val);
            boolean query = this.get("query_enabled", false, val);
            int queryPort = this.get("query_port", 25577, val);
            ListenerInfo info = new ListenerInfo(address, motd, maxPlayers, tabListSize, defaultServer, fallbackServer, forceDefault, (Map)forced, value.toString(), setLocalAddress, pingPassthrough, queryPort, query);
            ret.add(info);
        }
        return ret;
    }

    public Collection<String> getGroups(String player) {
        Collection groups = this.get("groups." + player, null);
        HashSet<String> ret = groups == null ? new HashSet<String>() : new HashSet(groups);
        ret.add("default");
        return ret;
    }

    public Collection<?> getList(String path, Collection<?> def) {
        return this.get(path, def);
    }

    public Collection<String> getPermissions(String group) {
        Collection permissions = this.get("permissions." + group, null);
        return permissions == null ? Collections.EMPTY_SET : permissions;
    }

    private static enum DefaultTabList {
        GLOBAL,
        GLOBAL_PING,
        SERVER;

    }
}

