/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.PacketConstants;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.forge.ForgeClientHandler;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.tab.ServerUnique;
import net.md_5.bungee.tab.TabList;
import net.md_5.bungee.util.CaseInsensitiveSet;

public final class UserConnection
implements ProxiedPlayer {
    @NonNull
    private final ProxyServer bungee;
    @NonNull
    private final ChannelWrapper ch;
    @NonNull
    private final String name;
    private final InitialHandler pendingConnection;
    private ServerConnection server;
    private boolean dimensionChange = true;
    private final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();
    private int sentPingId;
    private long sentPingTime;
    private int ping = 100;
    private ServerInfo reconnectServer;
    private TabList tabListHandler;
    private int gamemode;
    private int compressionThreshold = -1;
    private final Collection<String> groups = new CaseInsensitiveSet();
    private final Collection<String> permissions = new CaseInsensitiveSet();
    private int clientEntityId;
    private int serverEntityId;
    private ClientSettings settings;
    private final Scoreboard serverSentScoreboard = new Scoreboard();
    private String displayName;
    private EntityMap entityRewrite;
    private Locale locale;
    private ForgeClientHandler forgeClientHandler;
    private ForgeServerHandler forgeServerHandler;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        public void sendPacket(DefinedPacket packet) {
            UserConnection.this.ch.write(packet);
        }
    };
    private static final String EMPTY_TEXT = ComponentSerializer.toString((BaseComponent)new TextComponent(""));

    public void init() {
        this.entityRewrite = EntityMap.getEntityMap(this.getPendingConnection().getVersion());
        this.displayName = this.name;
        this.tabListHandler = new ServerUnique(this);
        Collection g = this.bungee.getConfigurationAdapter().getGroups(this.name);
        g.addAll(this.bungee.getConfigurationAdapter().getGroups(this.getUniqueId().toString()));
        for (String s : g) {
            this.addGroups(s);
        }
        this.forgeClientHandler = new ForgeClientHandler(this);
        this.forgeClientHandler.setFmlTokenInHandshake(this.getPendingConnection().getExtraDataInHandshake().contains("\u0000FML\u0000"));
    }

    public void sendPacket(PacketWrapper packet) {
        this.ch.write(packet);
    }

    @Deprecated
    public boolean isActive() {
        return !this.ch.isClosed();
    }

    public void setDisplayName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"displayName");
        Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (Object)"Display name cannot be longer than 16 characters");
        this.displayName = name;
    }

    public void connect(ServerInfo target) {
        this.connect(target, null);
    }

    public void connect(ServerInfo target, Callback<Boolean> callback) {
        this.connect(target, callback, false);
    }

    void sendDimensionSwitch() {
        this.dimensionChange = true;
        this.unsafe().sendPacket((DefinedPacket)PacketConstants.DIM1_SWITCH);
        this.unsafe().sendPacket((DefinedPacket)PacketConstants.DIM2_SWITCH);
    }

    public void connectNow(ServerInfo target) {
        this.sendDimensionSwitch();
        this.connect(target);
    }

    public void connect(ServerInfo info, final Callback<Boolean> callback, final boolean retry) {
        Preconditions.checkNotNull((Object)info, (Object)"info");
        ServerConnectEvent event = new ServerConnectEvent((ProxiedPlayer)this, info);
        if (((ServerConnectEvent)this.bungee.getPluginManager().callEvent((Event)event)).isCancelled()) {
            return;
        }
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equal((Object)this.getServer().getInfo(), (Object)target)) {
            this.sendMessage(this.bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (this.pendingConnects.contains(target)) {
            this.sendMessage(this.bungee.getTranslation("already_connecting", new Object[0]));
            return;
        }
        this.pendingConnects.add(target);
        ChannelInitializer initializer = new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().addAfter("frame-decoder", "packet-decoder", (ChannelHandler)new MinecraftDecoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ch.pipeline().addAfter("frame-prepender", "packet-encoder", (ChannelHandler)new MinecraftEncoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ((HandlerBoss)ch.pipeline().get(HandlerBoss.class)).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (callback != null) {
                    callback.done((Object)future.isSuccess(), future.cause());
                }
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = (ServerInfo)ProxyServer.getInstance().getServers().get(UserConnection.this.getPendingConnection().getListener().getFallbackServer());
                    if (retry && target != def && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_lobby", new Object[0]));
                        UserConnection.this.connect(def, null, false);
                    } else if (UserConnection.this.dimensionChange) {
                        UserConnection.this.disconnect(UserConnection.this.bungee.getTranslation("fallback_kick", new Object[]{future.cause().getClass().getName()}));
                    } else {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_kick", new Object[]{future.cause().getClass().getName()}));
                    }
                }
            }
        };
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel())).group((EventLoopGroup)this.ch.getHandle().eventLoop())).handler((ChannelHandler)initializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).remoteAddress((SocketAddress)target.getAddress());
        if (this.getPendingConnection().getListener().isSetLocalAddress() && !PlatformDependent.isWindows()) {
            b.localAddress(this.getPendingConnection().getListener().getHost().getHostString(), 0);
        }
        b.connect().addListener((GenericFutureListener)listener);
    }

    public void disconnect(String reason) {
        this.disconnect0(TextComponent.fromLegacyText((String)reason));
    }

    public void disconnect(BaseComponent ... reason) {
        this.disconnect0(reason);
    }

    public void disconnect(BaseComponent reason) {
        this.disconnect0(reason);
    }

    public void disconnect0(final BaseComponent ... reason) {
        if (!this.ch.isClosed()) {
            this.bungee.getLogger().log(Level.INFO, "[{0}] disconnected with: {1}", new Object[]{this.getName(), BaseComponent.toLegacyText((BaseComponent[])reason)});
            this.ch.getHandle().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    UserConnection.this.unsafe().sendPacket((DefinedPacket)new Kick(ComponentSerializer.toString((BaseComponent[])reason)));
                    UserConnection.this.ch.close();
                }
            }, 500L, TimeUnit.MILLISECONDS);
            if (this.server != null) {
                this.server.disconnect("Quitting");
            }
        }
    }

    public void chat(String message) {
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"Not connected to server");
        this.server.getCh().write(new Chat(message));
    }

    public void sendMessage(String message) {
        this.sendMessage(TextComponent.fromLegacyText((String)message));
    }

    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(BaseComponent ... message) {
        this.sendMessage(ChatMessageType.CHAT, message);
    }

    public void sendMessage(BaseComponent message) {
        this.sendMessage(ChatMessageType.CHAT, message);
    }

    private void sendMessage(ChatMessageType position, String message) {
        this.unsafe().sendPacket((DefinedPacket)new Chat(message, (byte)position.ordinal()));
    }

    public void sendMessage(ChatMessageType position, BaseComponent ... message) {
        if (position == ChatMessageType.ACTION_BAR && this.pendingConnection.getVersion() >= 47) {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent)new TextComponent(TextComponent.toLegacyText((BaseComponent[])message))));
        } else {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent[])message));
        }
    }

    public void sendMessage(ChatMessageType position, BaseComponent message) {
        if (position == ChatMessageType.ACTION_BAR && this.pendingConnection.getVersion() >= 47) {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent)new TextComponent(TextComponent.toLegacyText((BaseComponent[])new BaseComponent[]{message}))));
        } else {
            this.sendMessage(position, ComponentSerializer.toString((BaseComponent)message));
        }
    }

    public void sendData(String channel, byte[] data) {
        this.unsafe().sendPacket((DefinedPacket)new PluginMessage(channel, data, this.forgeClientHandler.isForgeUser()));
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    public boolean hasPermission(String permission) {
        return ((PermissionCheckEvent)this.bungee.getPluginManager().callEvent((Event)new PermissionCheckEvent((CommandSender)this, permission, this.permissions.contains(permission)))).hasPermission();
    }

    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public Collection<String> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions);
    }

    public String toString() {
        return this.name;
    }

    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    public String getUUID() {
        return this.getPendingConnection().getUUID();
    }

    public UUID getUniqueId() {
        return this.getPendingConnection().getUniqueId();
    }

    public void setSettings(ClientSettings settings) {
        this.settings = settings;
        this.locale = null;
    }

    public Locale getLocale() {
        return this.locale == null && this.settings != null ? (this.locale = Locale.forLanguageTag(this.settings.getLocale().replaceAll("_", "-"))) : this.locale;
    }

    public boolean isForgeUser() {
        return this.forgeClientHandler.isForgeUser();
    }

    public Map<String, String> getModList() {
        if (this.forgeClientHandler.getClientModList() == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.forgeClientHandler.getClientModList());
    }

    public void setTabHeader(BaseComponent header, BaseComponent footer) {
        if (this.pendingConnection.getVersion() >= 47) {
            this.unsafe().sendPacket((DefinedPacket)new PlayerListHeaderFooter(header != null ? ComponentSerializer.toString((BaseComponent)header) : EMPTY_TEXT, footer != null ? ComponentSerializer.toString((BaseComponent)footer) : EMPTY_TEXT));
        }
    }

    public void setTabHeader(BaseComponent[] header, BaseComponent[] footer) {
        if (this.pendingConnection.getVersion() >= 47) {
            this.unsafe().sendPacket((DefinedPacket)new PlayerListHeaderFooter(header != null ? ComponentSerializer.toString((BaseComponent[])header) : EMPTY_TEXT, footer != null ? ComponentSerializer.toString((BaseComponent[])footer) : EMPTY_TEXT));
        }
    }

    public void resetTabHeader() {
        this.setTabHeader((BaseComponent)null, null);
    }

    public void sendTitle(Title title) {
        title.send((ProxiedPlayer)this);
    }

    public String getExtraDataInHandshake() {
        return this.getPendingConnection().getExtraDataInHandshake();
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (this.ch.getHandle().isActive() && this.compressionThreshold == -1 && this.getPendingConnection().getVersion() >= 47) {
            this.compressionThreshold = compressionThreshold;
            this.unsafe.sendPacket((DefinedPacket)new SetCompression(compressionThreshold));
            this.ch.setCompressionThreshold(compressionThreshold);
        }
    }

    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @ConstructorProperties(value={"bungee", "ch", "name", "pendingConnection"})
    public UserConnection(@NonNull ProxyServer bungee, @NonNull ChannelWrapper ch, @NonNull String name, InitialHandler pendingConnection) {
        if (bungee == null) {
            throw new NullPointerException("bungee");
        }
        if (ch == null) {
            throw new NullPointerException("ch");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public boolean isDimensionChange() {
        return this.dimensionChange;
    }

    public void setDimensionChange(boolean dimensionChange) {
        this.dimensionChange = dimensionChange;
    }

    public Collection<ServerInfo> getPendingConnects() {
        return this.pendingConnects;
    }

    public int getSentPingId() {
        return this.sentPingId;
    }

    public void setSentPingId(int sentPingId) {
        this.sentPingId = sentPingId;
    }

    public long getSentPingTime() {
        return this.sentPingTime;
    }

    public void setSentPingTime(long sentPingTime) {
        this.sentPingTime = sentPingTime;
    }

    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    public ServerInfo getReconnectServer() {
        return this.reconnectServer;
    }

    public void setReconnectServer(ServerInfo reconnectServer) {
        this.reconnectServer = reconnectServer;
    }

    public TabList getTabListHandler() {
        return this.tabListHandler;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public int getClientEntityId() {
        return this.clientEntityId;
    }

    public void setClientEntityId(int clientEntityId) {
        this.clientEntityId = clientEntityId;
    }

    public int getServerEntityId() {
        return this.serverEntityId;
    }

    public void setServerEntityId(int serverEntityId) {
        this.serverEntityId = serverEntityId;
    }

    public ClientSettings getSettings() {
        return this.settings;
    }

    public Scoreboard getServerSentScoreboard() {
        return this.serverSentScoreboard;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public EntityMap getEntityRewrite() {
        return this.entityRewrite;
    }

    public ForgeClientHandler getForgeClientHandler() {
        return this.forgeClientHandler;
    }

    public void setForgeClientHandler(ForgeClientHandler forgeClientHandler) {
        this.forgeClientHandler = forgeClientHandler;
    }

    public ForgeServerHandler getForgeServerHandler() {
        return this.forgeServerHandler;
    }

    public void setForgeServerHandler(ForgeServerHandler forgeServerHandler) {
        this.forgeServerHandler = forgeServerHandler;
    }
}

