/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class BungeeServerInfo
implements ServerInfo {
    private final String name;
    private final InetSocketAddress address;
    private final Collection<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
    private final String motd;
    private final boolean restricted;
    private final Queue<DefinedPacket> packetQueue = new LinkedList<DefinedPacket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.add(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(ProxiedPlayer player) {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            this.players.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProxiedPlayer> getPlayers() {
        Collection<ProxiedPlayer> collection = this.players;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new HashSet<ProxiedPlayer>(this.players));
        }
    }

    public boolean canAccess(CommandSender player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        return !this.restricted || player.hasPermission("bungeecord.server." + this.name);
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerInfo && Objects.equal((Object)this.getAddress(), (Object)((ServerInfo)obj).getAddress());
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public void sendData(String channel, byte[] data) {
        this.sendData(channel, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendData(String channel, byte[] data, boolean queue) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel");
        Preconditions.checkNotNull((Object)data, (Object)"data");
        Queue<DefinedPacket> queue2 = this.packetQueue;
        synchronized (queue2) {
            Server server;
            Server server2 = server = this.players.isEmpty() ? null : this.players.iterator().next().getServer();
            if (server != null) {
                server.sendData(channel, data);
                return true;
            }
            if (queue) {
                this.packetQueue.add((DefinedPacket)new PluginMessage(channel, data, false));
            }
            return false;
        }
    }

    public void ping(Callback<ServerPing> callback) {
        this.ping(callback, ProxyServer.getInstance().getProtocolVersion());
    }

    public void ping(final Callback<ServerPing> callback, final int protocolVersion) {
        Preconditions.checkNotNull(callback, (Object)"callback");
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ((HandlerBoss)future.channel().pipeline().get(HandlerBoss.class)).setHandler(new PingHandler(BungeeServerInfo.this, (Callback<ServerPing>)callback, protocolVersion));
                } else {
                    callback.done(null, future.cause());
                }
            }
        };
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel())).group(BungeeCord.getInstance().eventLoops)).handler((ChannelHandler)PipelineUtils.BASE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).remoteAddress((SocketAddress)this.getAddress()).connect().addListener((GenericFutureListener)listener);
    }

    @ConstructorProperties(value={"name", "address", "motd", "restricted"})
    public BungeeServerInfo(String name, InetSocketAddress address, String motd, boolean restricted) {
        this.name = name;
        this.address = address;
        this.motd = motd;
        this.restricted = restricted;
    }

    public String toString() {
        return "BungeeServerInfo(name=" + this.getName() + ", address=" + this.getAddress() + ", restricted=" + this.isRestricted() + ")";
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getMotd() {
        return this.motd;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public Queue<DefinedPacket> getPacketQueue() {
        return this.packetQueue;
    }
}

