/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class Respawn
extends DefinedPacket {
    private int dimension;
    private short difficulty;
    private short gameMode;
    private String levelType;

    @Override
    public void read(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.difficulty = buf.readUnsignedByte();
        this.gameMode = buf.readUnsignedByte();
        this.levelType = Respawn.readString(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeByte((int)this.difficulty);
        buf.writeByte((int)this.gameMode);
        Respawn.writeString(this.levelType, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    @Override
    public String toString() {
        return "Respawn(dimension=" + this.getDimension() + ", difficulty=" + this.getDifficulty() + ", gameMode=" + this.getGameMode() + ", levelType=" + this.getLevelType() + ")";
    }

    public Respawn() {
    }

    @ConstructorProperties(value={"dimension", "difficulty", "gameMode", "levelType"})
    public Respawn(int dimension, short difficulty, short gameMode, String levelType) {
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.levelType = levelType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Respawn)) {
            return false;
        }
        Respawn other = (Respawn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        return !(this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Respawn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getGameMode();
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        return result;
    }
}

