/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(Handshake.class, Protocol.map(47, 0));
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, Protocol.map(47, 0), Protocol.map(107, 31));
            this.TO_CLIENT.registerPacket(Login.class, Protocol.map(47, 1), Protocol.map(107, 35));
            this.TO_CLIENT.registerPacket(Chat.class, Protocol.map(47, 2), Protocol.map(107, 15));
            this.TO_CLIENT.registerPacket(Respawn.class, Protocol.map(47, 7), Protocol.map(107, 51));
            this.TO_CLIENT.registerPacket(BossBar.class, Protocol.map(107, 12));
            this.TO_CLIENT.registerPacket(PlayerListItem.class, Protocol.map(47, 56), Protocol.map(107, 45));
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, Protocol.map(47, 58), Protocol.map(107, 14));
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, Protocol.map(47, 59), Protocol.map(107, 63));
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, Protocol.map(47, 60), Protocol.map(107, 66));
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, Protocol.map(47, 61), Protocol.map(107, 56));
            this.TO_CLIENT.registerPacket(Team.class, Protocol.map(47, 62), Protocol.map(107, 65));
            this.TO_CLIENT.registerPacket(PluginMessage.class, Protocol.map(47, 63), Protocol.map(107, 24));
            this.TO_CLIENT.registerPacket(Kick.class, Protocol.map(47, 64), Protocol.map(107, 26));
            this.TO_CLIENT.registerPacket(Title.class, Protocol.map(47, 69));
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, Protocol.map(47, 71), Protocol.map(107, 72), Protocol.map(110, 71), Protocol.map(210, 71));
            this.TO_SERVER.registerPacket(KeepAlive.class, Protocol.map(47, 0), Protocol.map(107, 11));
            this.TO_SERVER.registerPacket(Chat.class, Protocol.map(47, 1), Protocol.map(107, 2));
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, Protocol.map(47, 20), Protocol.map(107, 1));
            this.TO_SERVER.registerPacket(ClientSettings.class, Protocol.map(47, 21), Protocol.map(107, 4));
            this.TO_SERVER.registerPacket(PluginMessage.class, Protocol.map(47, 23), Protocol.map(107, 9));
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(PingPacket.class, Protocol.map(47, 1));
            this.TO_SERVER.registerPacket(StatusRequest.class, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(PingPacket.class, Protocol.map(47, 1));
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(Kick.class, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, Protocol.map(47, 1));
            this.TO_CLIENT.registerPacket(LoginSuccess.class, Protocol.map(47, 2));
            this.TO_CLIENT.registerPacket(SetCompression.class, Protocol.map(47, 3));
            this.TO_SERVER.registerPacket(LoginRequest.class, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(EncryptionResponse.class, Protocol.map(47, 1));
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    public static class DirectionData {
        private final Protocol protocolPhase;
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap();
        private final TIntObjectMap<List<Integer>> linkedProtocols;
        private final ProtocolConstants.Direction direction;

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = (ProtocolData)this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = (ProtocolData)Iterables.getFirst((Iterable)this.protocols.valueCollection(), null);
            }
            return protocol;
        }

        public final DefinedPacket createPacket(int id, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            if (id > 255) {
                throw new BadPacketException("Packet with id " + id + " outside of range ");
            }
            Constructor constructor = (Constructor)protocolData.packetConstructors.get(id);
            try {
                return constructor == null ? null : (DefinedPacket)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new BadPacketException("Could not construct packet with id " + id, ex);
            }
        }

        protected final void registerPacket(Class<? extends DefinedPacket> packetClass, ProtocolMapping ... mappings) {
            try {
                Constructor<? extends DefinedPacket> constructor = packetClass.getDeclaredConstructor(new Class[0]);
                for (ProtocolMapping mapping : mappings) {
                    ProtocolData data = (ProtocolData)this.protocols.get(mapping.protocolVersion);
                    data.packetMap.put(packetClass, mapping.packetID);
                    data.packetConstructors.put(mapping.packetID, constructor);
                    List links = (List)this.linkedProtocols.get(mapping.protocolVersion);
                    if (links == null) continue;
                    Iterator iterator = links.iterator();
                    block3: while (iterator.hasNext()) {
                        int link = (Integer)iterator.next();
                        for (ProtocolMapping m : mappings) {
                            List innerLinks;
                            if (m != mapping && (m.protocolVersion == link || (innerLinks = (List)this.linkedProtocols.get(m.protocolVersion)) != null && innerLinks.contains(link))) continue block3;
                        }
                        this.registerPacket(packetClass, Protocol.map(link, mapping.packetID));
                    }
                }
            }
            catch (NoSuchMethodException ex) {
                throw new BadPacketException("No NoArgsConstructor for packet class " + packetClass);
            }
        }

        final int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            Preconditions.checkArgument((boolean)protocolData.packetMap.containsKey(packet), (Object)("Cannot get ID for packet " + packet));
            return protocolData.packetMap.get(packet);
        }

        @ConstructorProperties(value={"protocolPhase", "direction"})
        public DirectionData(Protocol protocolPhase, ProtocolConstants.Direction direction) {
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                this.protocols.put(protocol, (Object)new ProtocolData(protocol));
            }
            this.linkedProtocols = new TIntObjectHashMap();
            this.linkedProtocols.put(47, Arrays.asList(107));
            this.linkedProtocols.put(107, Arrays.asList(108, 109, 110, 210));
            this.protocolPhase = protocolPhase;
            this.direction = direction;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        @ConstructorProperties(value={"protocolVersion", "packetID"})
        public ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap(255);
        private final TIntObjectMap<Constructor<? extends DefinedPacket>> packetConstructors = new TIntObjectHashMap(255);

        @ConstructorProperties(value={"protocolVersion"})
        public ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }
    }
}

