/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.md_5.bungee.jni.cipher.BungeeCipher;

public final class NativeCode<T> {
    private final String name;
    private final Class<? extends T> javaImpl;
    private final Class<? extends T> nativeImpl;
    private boolean loaded;
    private boolean enable;

    public NativeCode(String name, Class<? extends T> javaImpl, Class<? extends T> nativeImpl) {
        this.name = name;
        this.javaImpl = javaImpl;
        this.nativeImpl = nativeImpl;
    }

    public T newInstance() {
        try {
            return this.enable ? this.nativeImpl.newInstance() : this.javaImpl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Error getting instance", ex);
        }
    }

    public boolean load() {
        if (!this.loaded && NativeCode.isSupported()) {
            String fullName = "bungeecord-" + this.name;
            try {
                System.loadLibrary(fullName);
                this.loaded = true;
                this.enable = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.loaded) {
                try (InputStream soFile2 = BungeeCipher.class.getClassLoader().getResourceAsStream(this.name + ".so");){
                    File temp = File.createTempFile(fullName, ".so");
                    temp.deleteOnExit();
                    try (FileOutputStream outputStream = new FileOutputStream(temp);){
                        ByteStreams.copy((InputStream)soFile2, (OutputStream)outputStream);
                    }
                    System.load(temp.getPath());
                    this.loaded = true;
                    this.enable = true;
                }
                catch (IOException soFile2) {
                }
                catch (UnsatisfiedLinkError ex) {
                    System.out.println("Could not load native library: " + ex.getMessage());
                }
            }
        }
        return this.loaded;
    }

    public boolean setEnable(boolean enable) {
        if (this.loaded) {
            boolean enable1 = this.enable;
            this.enable = enable;
            return enable1 ^ enable;
        }
        return false;
    }

    public static boolean isSupported() {
        return "Linux".equals(System.getProperty("os.name")) && "amd64".equals(System.getProperty("os.arch"));
    }
}

