/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginClassloader;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.md_5.bungee.event.EventBus;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class PluginManager {
    private final ProxyServer proxy;
    private final Yaml yaml;
    private final EventBus eventBus;
    private final Map<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private Map<String, PluginDescription> toLoad = new HashMap<String, PluginDescription>();
    private final Multimap<Plugin, Command> commandsByPlugin = ArrayListMultimap.create();
    private final Multimap<Plugin, Listener> listenersByPlugin = ArrayListMultimap.create();

    public PluginManager(ProxyServer proxy) {
        this.proxy = proxy;
        Constructor yamlConstructor = new Constructor();
        PropertyUtils propertyUtils = yamlConstructor.getPropertyUtils();
        propertyUtils.setSkipMissingProperties(true);
        yamlConstructor.setPropertyUtils(propertyUtils);
        this.yaml = new Yaml((BaseConstructor)yamlConstructor);
        this.eventBus = new EventBus(proxy.getLogger());
    }

    public void registerCommand(Plugin plugin, Command command) {
        this.commandMap.put(command.getName().toLowerCase(Locale.ROOT), command);
        for (String alias : command.getAliases()) {
            this.commandMap.put(alias.toLowerCase(Locale.ROOT), command);
        }
        this.commandsByPlugin.put((Object)plugin, (Object)command);
    }

    public void unregisterCommand(Command command) {
        while (this.commandMap.values().remove(command)) {
        }
        this.commandsByPlugin.values().remove(command);
    }

    public void unregisterCommands(Plugin plugin) {
        Iterator it = this.commandsByPlugin.get((Object)plugin).iterator();
        while (it.hasNext()) {
            Command command = (Command)it.next();
            while (this.commandMap.values().remove(command)) {
            }
            it.remove();
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        return this.dispatchCommand(sender, commandLine, null);
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine, List<String> tabResults) {
        String[] split = commandLine.split(" ", -1);
        if (split.length == 0 || split[0].isEmpty()) {
            return false;
        }
        String commandName = split[0].toLowerCase(Locale.ROOT);
        if (sender instanceof ProxiedPlayer && this.proxy.getDisabledCommands().contains(commandName)) {
            return false;
        }
        Command command = this.commandMap.get(commandName);
        if (command == null) {
            return false;
        }
        String permission = command.getPermission();
        if (permission != null && !permission.isEmpty() && !sender.hasPermission(permission)) {
            if (tabResults == null) {
                sender.sendMessage(this.proxy.getTranslation("no_permission", new Object[0]));
            }
            return true;
        }
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        try {
            if (tabResults == null) {
                if (this.proxy.getConfig().isLogCommands()) {
                    this.proxy.getLogger().log(Level.INFO, "{0} executed command: /{1}", new Object[]{sender.getName(), commandLine});
                }
                command.execute(sender, args);
            } else if (commandLine.contains(" ") && command instanceof TabExecutor) {
                for (String s : ((TabExecutor)((Object)command)).onTabComplete(sender, args)) {
                    tabResults.add(s);
                }
            }
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "An internal error occurred whilst executing this command, please check the console log for details.");
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Error in dispatching command", ex);
        }
        return true;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void loadPlugins() {
        HashMap<PluginDescription, Boolean> pluginStatuses = new HashMap<PluginDescription, Boolean>();
        for (Map.Entry<String, PluginDescription> entry : this.toLoad.entrySet()) {
            PluginDescription plugin = entry.getValue();
            if (this.enablePlugin(pluginStatuses, new Stack<PluginDescription>(), plugin)) continue;
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Failed to enable {0}", entry.getKey());
        }
        this.toLoad.clear();
        this.toLoad = null;
    }

    public void enablePlugins() {
        for (Plugin plugin : this.plugins.values()) {
            try {
                plugin.onEnable();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Enabled plugin {0} version {1} by {2}", new Object[]{plugin.getDescription().getName(), plugin.getDescription().getVersion(), plugin.getDescription().getAuthor()});
            }
            catch (Throwable t) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Exception encountered when loading plugin: " + plugin.getDescription().getName(), t);
            }
        }
    }

    private boolean enablePlugin(Map<PluginDescription, Boolean> pluginStatuses, Stack<PluginDescription> dependStack, PluginDescription plugin) {
        if (pluginStatuses.containsKey(plugin)) {
            return pluginStatuses.get(plugin);
        }
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.addAll(plugin.getDepends());
        dependencies.addAll(plugin.getSoftDepends());
        boolean status = true;
        for (String dependName : dependencies) {
            Boolean dependStatus;
            PluginDescription depend = this.toLoad.get(dependName);
            Boolean bl = dependStatus = depend != null ? pluginStatuses.get(depend) : Boolean.FALSE;
            if (dependStatus == null) {
                if (dependStack.contains(depend)) {
                    StringBuilder dependencyGraph = new StringBuilder();
                    for (PluginDescription element : dependStack) {
                        dependencyGraph.append(element.getName()).append(" -> ");
                    }
                    dependencyGraph.append(plugin.getName()).append(" -> ").append(dependName);
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "Circular dependency detected: {0}", dependencyGraph);
                    status = false;
                } else {
                    dependStack.push(plugin);
                    dependStatus = this.enablePlugin(pluginStatuses, dependStack, depend);
                    dependStack.pop();
                }
            }
            if (dependStatus == Boolean.FALSE && plugin.getDepends().contains(dependName)) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} (required by {1}) is unavailable", new Object[]{String.valueOf(dependName), plugin.getName()});
                status = false;
            }
            if (status) continue;
            break;
        }
        if (status) {
            try {
                PluginClassloader loader = new PluginClassloader(new URL[]{plugin.getFile().toURI().toURL()});
                Class<?> main = loader.loadClass(plugin.getMain());
                Plugin clazz = (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                clazz.init(this.proxy, plugin);
                this.plugins.put(plugin.getName(), clazz);
                clazz.onLoad();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Loaded plugin {0} version {1} by {2}", new Object[]{plugin.getName(), plugin.getVersion(), plugin.getAuthor()});
            }
            catch (Throwable t) {
                this.proxy.getLogger().log(Level.WARNING, "Error enabling plugin " + plugin.getName(), t);
            }
        }
        pluginStatuses.put(plugin, status);
        return status;
    }

    public void detectPlugins(File folder) {
        Preconditions.checkNotNull((Object)folder, (Object)"folder");
        Preconditions.checkArgument((boolean)folder.isDirectory(), (Object)"Must load from a directory");
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(file);){
                JarEntry pdf = jar.getJarEntry("bungee.yml");
                if (pdf == null) {
                    pdf = jar.getJarEntry("plugin.yml");
                }
                Preconditions.checkNotNull((Object)pdf, (Object)"Plugin must have a plugin.yml or bungee.yml");
                try (InputStream in = jar.getInputStream(pdf);){
                    PluginDescription desc = (PluginDescription)this.yaml.loadAs(in, PluginDescription.class);
                    Preconditions.checkNotNull((Object)desc.getName(), (String)"Plugin from %s has no name", (Object)file);
                    Preconditions.checkNotNull((Object)desc.getMain(), (String)"Plugin from %s has no main", (Object)file);
                    desc.setFile(file);
                    this.toLoad.put(desc.getName(), desc);
                }
            }
            catch (Exception ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load plugin from file " + file, ex);
            }
        }
    }

    public <T extends Event> T callEvent(T event) {
        Preconditions.checkNotNull(event, (Object)"event");
        long start = System.nanoTime();
        this.eventBus.post(event);
        event.postCall();
        long elapsed = System.nanoTime() - start;
        if (elapsed > 250000000L) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Event {0} took {1}ns to process!", new Object[]{event, elapsed});
        }
        return event;
    }

    public void registerListener(Plugin plugin, Listener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Preconditions.checkArgument((!method.isAnnotationPresent(Subscribe.class) ? 1 : 0) != 0, (String)"Listener %s has registered using deprecated subscribe annotation! Please update to @EventHandler.", (Object)listener);
        }
        this.eventBus.register((Object)listener);
        this.listenersByPlugin.put((Object)plugin, (Object)listener);
    }

    public void unregisterListener(Listener listener) {
        this.eventBus.unregister((Object)listener);
        this.listenersByPlugin.values().remove(listener);
    }

    public void unregisterListeners(Plugin plugin) {
        Iterator it = this.listenersByPlugin.get((Object)plugin).iterator();
        while (it.hasNext()) {
            this.eventBus.unregister(it.next());
            it.remove();
        }
    }

    @ConstructorProperties(value={"proxy", "yaml", "eventBus"})
    public PluginManager(ProxyServer proxy, Yaml yaml, EventBus eventBus) {
        this.proxy = proxy;
        this.yaml = yaml;
        this.eventBus = eventBus;
    }
}

