/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.ProgressMeter;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.RemappingClassAdapter;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.JarRepo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class JarRemapper
extends CustomRemapper {
    private static final int CLASS_LEN = ".class".length();
    private RemapperProcessor preProcessor;
    public final JarMapping jarMapping;
    private RemapperProcessor postProcessor;
    private int writerFlags = 1;
    private int readerFlags = 0;
    private boolean copyResources = true;

    public JarRemapper(RemapperProcessor preProcessor, JarMapping jarMapping, RemapperProcessor postProcessor) {
        this.preProcessor = preProcessor;
        this.jarMapping = jarMapping;
        this.postProcessor = postProcessor;
    }

    public JarRemapper(RemapperProcessor remapperPreprocessor, JarMapping jarMapping) {
        this(remapperPreprocessor, jarMapping, null);
    }

    public JarRemapper(JarMapping jarMapping) {
        this(null, jarMapping);
    }

    public void setGenerateAPI(boolean generateAPI) {
        if (generateAPI) {
            this.readerFlags |= 1;
            this.copyResources = false;
        } else {
            this.readerFlags &= 0xFFFFFFFE;
            this.copyResources = true;
        }
    }

    @Override
    public String map(String typeName) {
        return JarRemapper.mapTypeName(typeName, this.jarMapping.packages, this.jarMapping.classes, typeName);
    }

    public static String mapTypeName(String typeName, Map<String, String> packageMap, Map<String, String> classMap, String defaultIfUnmapped) {
        String mapped = JarRemapper.mapClassName(typeName, packageMap, classMap);
        return mapped != null ? mapped : defaultIfUnmapped;
    }

    private static String mapClassName(String className, Map<String, String> packageMap, Map<String, String> classMap) {
        if (classMap != null && classMap.containsKey(className)) {
            return classMap.get(className);
        }
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String outer = className.substring(0, index);
            String mapped = JarRemapper.mapClassName(outer, packageMap, classMap);
            if (mapped == null) {
                return null;
            }
            return mapped + className.substring(index);
        }
        if (packageMap != null) {
            for (String oldPackage : packageMap.keySet()) {
                if (!JarRemapper.matchClassPackage(oldPackage, className)) continue;
                String newPackage = packageMap.get(oldPackage);
                return JarRemapper.moveClassPackage(newPackage, JarRemapper.getSimpleName(oldPackage, className));
            }
        }
        return null;
    }

    private static boolean matchClassPackage(String packageName, String className) {
        if (packageName.equals(".")) {
            return JarRemapper.isDefaultPackage(className);
        }
        return className.startsWith(packageName);
    }

    private static String moveClassPackage(String packageName, String classSimpleName) {
        if (packageName.equals(".")) {
            return classSimpleName;
        }
        return packageName + classSimpleName;
    }

    private static boolean isDefaultPackage(String className) {
        return className.indexOf(47) == -1;
    }

    private static String getSimpleName(String oldPackage, String className) {
        if (oldPackage.equals(".")) {
            return className;
        }
        return className.substring(oldPackage.length());
    }

    @Override
    public String mapFieldName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.fields, NodeType.FIELD, owner, name, access);
        return mapped == null ? name : mapped;
    }

    @Override
    public String mapMethodName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.methods, NodeType.METHOD, owner, name + " " + desc, access);
        return mapped == null ? name : mapped;
    }

    public void remapJar(Jar jar, File target) throws IOException {
        this.remapJar(jar, target, Collections.EMPTY_SET);
    }

    public void remapJar(Jar jar, File target, Set<String> includes) throws IOException {
        if (jar == null) {
            return;
        }
        if (target.getParentFile() != null && !target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        JarRepo repo = new JarRepo(jar);
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(target));){
            Set<String> jarEntries = jar.getEntryNames();
            ProgressMeter meter = new ProgressMeter(jarEntries.size(), "Remapping jar... %2.0f%%");
            for (String name : jarEntries) {
                InputStream is = jar.getResource(name);
                Throwable throwable = null;
                try {
                    JarEntry entry;
                    byte[] data;
                    if (name.endsWith(".class") && JarRemapper.shouldHandle(name, includes)) {
                        name = name.substring(0, name.length() - CLASS_LEN);
                        data = this.remapClassFile(is, (ClassRepo)repo);
                        String newName = this.map(name);
                        entry = new JarEntry(newName == null ? name : newName + ".class");
                    } else {
                        int n;
                        if (name.endsWith(".DSA") || name.endsWith(".SF") || !this.copyResources) continue;
                        entry = new JarEntry(name);
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] b = new byte[32768];
                        while ((n = is.read(b, 0, b.length)) != -1) {
                            buffer.write(b, 0, n);
                        }
                        buffer.flush();
                        data = buffer.toByteArray();
                    }
                    if (SpecialSource.stable) {
                        entry.setTime(0L);
                    }
                    out.putNextEntry(entry);
                    out.write(data);
                    meter.makeProgress();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable newName) {
                            throwable.addSuppressed(newName);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private static boolean shouldHandle(String name, Set<String> includes) {
        if (includes.isEmpty()) {
            return true;
        }
        for (String match : includes) {
            if (match.equals(".") && !name.contains("/")) {
                return true;
            }
            if (!name.startsWith(match)) continue;
            return true;
        }
        return false;
    }

    public byte[] remapClassFile(InputStream is, ClassRepo repo) throws IOException {
        return this.remapClassFile(new ClassReader(is), repo);
    }

    public byte[] remapClassFile(byte[] in, ClassRepo repo) {
        return this.remapClassFile(new ClassReader(in), repo);
    }

    private byte[] remapClassFile(ClassReader reader, ClassRepo repo) {
        byte[] pre;
        if (this.preProcessor != null && (pre = this.preProcessor.process(reader)) != null) {
            reader = new ClassReader(pre);
        }
        ClassNode node = new ClassNode();
        RemappingClassAdapter mapper = new RemappingClassAdapter(node, this, repo);
        reader.accept(mapper, this.readerFlags);
        ClassWriter wr = new ClassWriter(this.writerFlags);
        node.accept(wr);
        if (SpecialSource.identifier != null) {
            wr.newUTF8(SpecialSource.identifier);
        }
        return this.postProcessor != null ? this.postProcessor.process(wr.toByteArray()) : wr.toByteArray();
    }
}

