/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class Jar
implements Closeable {
    private final List<JarFile> jarFiles;
    private final String main;
    private final String filename;
    private final LinkedHashMap<String, JarFile> jarForResource;
    private final Set<String> contains = new HashSet<String>();

    public boolean containsClass(String clazz) {
        if (this.contains.contains(clazz)) {
            return true;
        }
        if (this.containsResource(clazz + ".class")) {
            this.contains.add(clazz);
            return true;
        }
        return false;
    }

    public boolean containsResource(String name) {
        JarFile jarFile = this.jarForResource.get(name);
        return jarFile != null && jarFile.getEntry(name) != null;
    }

    public InputStream getResource(String name) throws IOException {
        JarFile jarFile = this.jarForResource.get(name);
        if (jarFile == null) {
            return null;
        }
        ZipEntry e = jarFile.getEntry(name);
        return e == null ? null : jarFile.getInputStream(e);
    }

    public InputStream getClass(String clazz) throws IOException {
        InputStream inputStream = this.getResource(clazz + ".class");
        if (inputStream != null) {
            this.contains.add(clazz);
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassNode getNode(String clazz) {
        try (InputStream is = this.getClass(clazz);){
            if (is == null) return null;
            ClassReader cr = new ClassReader(is);
            ClassNode node = new ClassNode();
            cr.accept(node, 0);
            ClassNode classNode = node;
            return classNode;
        }
        catch (IOException ex) {
            throw new RuntimeException(clazz, ex);
        }
    }

    public Set<String> getEntryNames() {
        return this.jarForResource.keySet();
    }

    private static LinkedHashMap<String, JarFile> collectJarFiles(List<JarFile> jarFiles) {
        LinkedHashMap<String, JarFile> jarForResource = new LinkedHashMap<String, JarFile>();
        for (JarFile jarFile : jarFiles) {
            Enumeration<JarEntry> entr = jarFile.entries();
            while (entr.hasMoreElements()) {
                jarForResource.put(entr.nextElement().getName(), jarFile);
            }
        }
        return jarForResource;
    }

    private static String getMainClassName(Manifest manifest) {
        String mainClassName;
        Attributes attributes;
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (mainClassName = attributes.getValue("Main-Class")) != null) {
            return mainClassName.replace('.', '/');
        }
        return null;
    }

    public static Jar init(File file) throws IOException {
        return Jar.init(Collections.singletonList(file));
    }

    public static Jar init(List<File> files) throws IOException {
        Preconditions.checkArgument(files.size() > 0, "Jar init requires at least one file!");
        ArrayList<JarFile> jarFiles = new ArrayList<JarFile>(files.size());
        ArrayList<String> filenames = new ArrayList<String>(files.size());
        for (File file : files) {
            filenames.add(file.getName());
            jarFiles.add(new JarFile(file, false));
        }
        LinkedHashMap<String, JarFile> jarForResource = Jar.collectJarFiles(jarFiles);
        String fileName = Joiner.on(" + ").join(filenames);
        String main = null;
        for (JarFile jar : jarFiles) {
            String newMain = Jar.getMainClassName(jar.getManifest());
            if (newMain == null) continue;
            if (main == null) {
                main = newMain;
                continue;
            }
            System.err.println("[Warning] Duplicate Main classes for " + fileName);
        }
        return new Jar(jarFiles, main, fileName, jarForResource);
    }

    @Override
    public void close() throws IOException {
        for (JarFile jarFile : this.jarFiles) {
            jarFile.close();
        }
        this.jarFiles.clear();
        this.jarForResource.clear();
        this.contains.clear();
    }

    public String toString() {
        return "Jar(jarFiles=" + this.jarFiles + ", main=" + this.getMain() + ", filename=" + this.getFilename() + ", jarForResource=" + this.jarForResource + ", contains=" + this.contains + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jar)) {
            return false;
        }
        Jar other = (Jar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JarFile> this$jarFiles = this.jarFiles;
        List<JarFile> other$jarFiles = other.jarFiles;
        if (this$jarFiles == null ? other$jarFiles != null : !((Object)this$jarFiles).equals(other$jarFiles)) {
            return false;
        }
        String this$main = this.getMain();
        String other$main = other.getMain();
        if (this$main == null ? other$main != null : !this$main.equals(other$main)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        LinkedHashMap<String, JarFile> this$jarForResource = this.jarForResource;
        LinkedHashMap<String, JarFile> other$jarForResource = other.jarForResource;
        if (this$jarForResource == null ? other$jarForResource != null : !((Object)this$jarForResource).equals(other$jarForResource)) {
            return false;
        }
        Set<String> this$contains = this.contains;
        Set<String> other$contains = other.contains;
        return !(this$contains == null ? other$contains != null : !((Object)this$contains).equals(other$contains));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JarFile> $jarFiles = this.jarFiles;
        result = result * 59 + ($jarFiles == null ? 43 : ((Object)$jarFiles).hashCode());
        String $main = this.getMain();
        result = result * 59 + ($main == null ? 43 : $main.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        LinkedHashMap<String, JarFile> $jarForResource = this.jarForResource;
        result = result * 59 + ($jarForResource == null ? 43 : ((Object)$jarForResource).hashCode());
        Set<String> $contains = this.contains;
        result = result * 59 + ($contains == null ? 43 : ((Object)$contains).hashCode());
        return result;
    }

    @ConstructorProperties(value={"jarFiles", "main", "filename", "jarForResource"})
    private Jar(List<JarFile> jarFiles, String main, String filename, LinkedHashMap<String, JarFile> jarForResource) {
        this.jarFiles = jarFiles;
        this.main = main;
        this.filename = filename;
        this.jarForResource = jarForResource;
    }

    public String getMain() {
        return this.main;
    }

    public String getFilename() {
        return this.filename;
    }
}

