/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.RepoRemapper;
import net.md_5.specialsource.repo.ClassRepo;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;

public class UnsortedRemappingMethodAdapter
extends MethodRemapper {
    private static final Collection<Handle> META_FACTORIES = Arrays.asList(new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false));
    protected final RepoRemapper remapper;

    public UnsortedRemappingMethodAdapter(MethodVisitor mv, CustomRemapper remapper, ClassRepo classRepo) {
        super(mv, remapper);
        Preconditions.checkArgument(mv != null, "mv");
        this.remapper = new RepoRemapper(remapper, classRepo);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name, desc), this.remapper.mapDesc(desc));
    }

    @Deprecated
    public int findAccess(NodeType type, String owner, String name, String desc) {
        return this.remapper.findAccess(type, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.mv.visitMethodInsn(opcode, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name, desc), this.remapper.mapMethodDesc(desc), itf);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (META_FACTORIES.contains(bsm)) {
            String owner = Type.getReturnType(desc).getInternalName();
            String odesc = ((Type)bsmArgs[0]).getDescriptor();
            name = this.remapper.mapMethodName(owner, name, odesc);
        } else {
            name = this.remapper.mapInvokeDynamicMethodName(name, desc);
        }
        for (int i = 0; i < bsmArgs.length; ++i) {
            bsmArgs[i] = this.remapper.mapValue(bsmArgs[i]);
        }
        this.mv.visitInvokeDynamicInsn(name, this.remapper.mapMethodDesc(desc), (Handle)this.remapper.mapValue(bsm), bsmArgs);
    }
}

