/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.text.BlockNbtComponent;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.Style;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import net.kyori.text.serializer.ComponentSerializer;
import net.kyori.text.serializer.gson.BlockNbtComponentPosSerializer;
import net.kyori.text.serializer.gson.ComponentSerializerImpl;
import net.kyori.text.serializer.gson.NameMapSerializer;
import net.kyori.text.serializer.gson.StyleSerializer;
import net.kyori.text.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, (Object)ComponentSerializerImpl.INSTANCE).registerTypeAdapter(Style.class, (Object)StyleSerializer.INSTANCE).registerTypeAdapter(ClickEvent.Action.class, new NameMapSerializer("click action", ClickEvent.Action.NAMES)).registerTypeAdapter(HoverEvent.Action.class, new NameMapSerializer("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter(TextColorWrapper.class, (Object)new TextColorWrapper.Serializer()).registerTypeAdapter(TextColor.class, new NameMapSerializer("text color", TextColor.NAMES)).registerTypeAdapter(TextDecoration.class, new NameMapSerializer("text decoration", TextDecoration.NAMES)).registerTypeHierarchyAdapter(BlockNbtComponent.Pos.class, (Object)BlockNbtComponentPosSerializer.INSTANCE);
        return builder;
    }

    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)GSON.fromJson(string, Component.class);
    }

    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson((Object)component);
    }

    @Deprecated
    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return ComponentSerializerImpl.INSTANCE.deserialize(json, typeOfT, context);
    }

    @Deprecated
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        return ComponentSerializerImpl.INSTANCE.serialize(src, typeOfSrc, context);
    }
}

