/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.text.util.NameMap;

public class NameMapSerializer<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private final String name;
    private final NameMap<T> map;

    public NameMapSerializer(String name, NameMap<T> map) {
        this.name = name;
        this.map = map;
    }

    public T deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        return this.map.get(json.getAsString()).orElseThrow(() -> new IllegalArgumentException("invalid " + this.name));
    }

    public JsonElement serialize(T src, Type typeOfT, JsonSerializationContext context) {
        return new JsonPrimitive(this.map.name(src));
    }
}

