/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.feature.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.feature.pagination.Pagination;
import net.kyori.text.feature.pagination.Paginator;
import net.kyori.text.format.Style;
import net.kyori.text.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

final class PaginationImpl<T>
implements Pagination<T> {
    private static final int LINE_CHARACTER_LENGTH = 1;
    private final int width;
    private final int resultsPerPage;
    private final Pagination.Renderer renderer;
    private final char lineCharacter;
    private final Style lineStyle;
    private final char previousPageButtonCharacter;
    private final Style previousPageButtonStyle;
    private final char nextPageButtonCharacter;
    private final Style nextPageButtonStyle;
    private final Component title;
    private final Pagination.Renderer.RowRenderer<T> rowRenderer;
    private final Pagination.PageCommandFunction pageCommand;

    PaginationImpl(int width, int resultsPerPage, @NonNull Pagination.Renderer renderer, char lineCharacter, @NonNull Style lineStyle, char previousPageButtonCharacter, @NonNull Style previousPageButtonStyle, char nextPageButtonCharacter, @NonNull Style nextPageButtonStyle, @NonNull Component title, @NonNull Pagination.Renderer.RowRenderer<T> rowRenderer, @NonNull Pagination.PageCommandFunction pageCommand) {
        this.width = width;
        this.resultsPerPage = resultsPerPage;
        this.renderer = renderer;
        this.lineCharacter = lineCharacter;
        this.lineStyle = lineStyle;
        this.previousPageButtonCharacter = previousPageButtonCharacter;
        this.previousPageButtonStyle = previousPageButtonStyle;
        this.nextPageButtonCharacter = nextPageButtonCharacter;
        this.nextPageButtonStyle = nextPageButtonStyle;
        this.title = title;
        this.rowRenderer = rowRenderer;
        this.pageCommand = pageCommand;
    }

    @Override
    public @NonNull List<Component> render(@NonNull Collection<? extends T> content, int page) {
        if (content.isEmpty()) {
            return Collections.singletonList(this.renderer.renderEmpty());
        }
        int pages = PaginationImpl.pages(this.resultsPerPage, content.size());
        if (!PaginationImpl.pageInRange(page, pages)) {
            return Collections.singletonList(this.renderer.renderUnknownPage(page, pages));
        }
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.renderHeader(page, pages));
        Paginator.forEachPageEntry(content, this.resultsPerPage, page, (value, index) -> components.addAll(this.rowRenderer.renderRow(value, index)));
        components.add(this.renderFooter(page, pages));
        return Collections.unmodifiableList(components);
    }

    private Component renderHeader(int page, int pages) {
        Component header = this.renderer.renderHeader(this.title, page, pages);
        Component dashes = this.line(header);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(dashes)).append(header)).append(dashes)).build();
    }

    private Component renderFooter(int page, int pages) {
        if (page == 1 && page == pages) {
            return this.line(this.width);
        }
        Component buttons = this.renderFooterButtons(page, pages);
        Component dashes = this.line(buttons);
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(dashes)).append(buttons)).append(dashes)).build();
    }

    private Component renderFooterButtons(int page, int pages) {
        boolean hasPreviousPage = page > 1 && pages > 1;
        boolean hasNextPage = page < pages && page == 1 || hasPreviousPage && page > 1 && page != pages;
        TextComponent.Builder buttons = TextComponent.builder();
        if (hasPreviousPage) {
            buttons.append(this.renderer.renderPreviousPageButton(this.previousPageButtonCharacter, this.previousPageButtonStyle, ClickEvent.runCommand((String)this.pageCommand.pageCommand(page - 1))));
            if (hasNextPage) {
                buttons.append(this.line(8));
            }
        }
        if (hasNextPage) {
            buttons.append(this.renderer.renderNextPageButton(this.nextPageButtonCharacter, this.nextPageButtonStyle, ClickEvent.runCommand((String)this.pageCommand.pageCommand(page + 1))));
        }
        return buttons.build();
    }

    private @NonNull Component line(@NonNull Component component) {
        return this.line((this.width - PaginationImpl.length(component)) / 2);
    }

    private @NonNull Component line(int characters) {
        return TextComponent.of((String)PaginationImpl.repeat(String.valueOf(this.lineCharacter), characters), (Style)this.lineStyle);
    }

    static int length(@NonNull Component component) {
        int length = 0;
        if (component instanceof TextComponent) {
            length += ((TextComponent)component).content().length();
        }
        for (Component child : component.children()) {
            length += PaginationImpl.length(child);
        }
        return length;
    }

    static @NonNull String repeat(@NonNull String character, int count) {
        return String.join((CharSequence)"", Collections.nCopies(count, character));
    }

    static int pages(int pageSize, int count) {
        int pages = count / pageSize + 1;
        if (count % pageSize == 0) {
            return pages - 1;
        }
        return pages;
    }

    static boolean pageInRange(int page, int pages) {
        return page > 0 && page <= pages;
    }

    public String toString() {
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        builder.put("width", this.width);
        builder.put("resultsPerPage", this.resultsPerPage);
        builder.put("renderer", this.renderer);
        builder.put("lineCharacter", Character.valueOf(this.lineCharacter));
        builder.put("lineStyle", this.lineStyle);
        builder.put("previousPageButtonCharacter", Character.valueOf(this.previousPageButtonCharacter));
        builder.put("previousPageButtonStyle", this.previousPageButtonStyle);
        builder.put("nextPageButtonCharacter", Character.valueOf(this.nextPageButtonCharacter));
        builder.put("nextPageButtonStyle", this.nextPageButtonStyle);
        builder.put("title", this.title);
        builder.put("rowRenderer", this.rowRenderer);
        builder.put("pageCommand", this.pageCommand);
        return ToStringer.toString((Object)this, builder);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PaginationImpl that = (PaginationImpl)other;
        if (this.width != that.width) {
            return false;
        }
        if (this.resultsPerPage != that.resultsPerPage) {
            return false;
        }
        if (this.lineCharacter != that.lineCharacter) {
            return false;
        }
        if (this.previousPageButtonCharacter != that.previousPageButtonCharacter) {
            return false;
        }
        if (this.nextPageButtonCharacter != that.nextPageButtonCharacter) {
            return false;
        }
        if (!this.renderer.equals(that.renderer)) {
            return false;
        }
        if (!this.lineStyle.equals((Object)that.lineStyle)) {
            return false;
        }
        if (!this.previousPageButtonStyle.equals((Object)that.previousPageButtonStyle)) {
            return false;
        }
        if (!this.nextPageButtonStyle.equals((Object)that.nextPageButtonStyle)) {
            return false;
        }
        if (!this.title.equals(that.title)) {
            return false;
        }
        if (!this.rowRenderer.equals(that.rowRenderer)) {
            return false;
        }
        return this.pageCommand.equals(that.pageCommand);
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.resultsPerPage;
        result = 31 * result + this.renderer.hashCode();
        result = 31 * result + this.lineCharacter;
        result = 31 * result + this.lineStyle.hashCode();
        result = 31 * result + this.previousPageButtonCharacter;
        result = 31 * result + this.previousPageButtonStyle.hashCode();
        result = 31 * result + this.nextPageButtonCharacter;
        result = 31 * result + this.nextPageButtonStyle.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.rowRenderer.hashCode();
        result = 31 * result + this.pageCommand.hashCode();
        return result;
    }
}

