/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.format;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.kyori.text.format.TextFormat;
import net.kyori.text.util.NameMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum TextDecoration implements TextFormat
{
    OBFUSCATED("obfuscated"),
    BOLD("bold"),
    STRIKETHROUGH("strikethrough"),
    UNDERLINED("underlined"),
    ITALIC("italic");

    public static final NameMap<TextDecoration> NAMES;
    private final String name;

    private TextDecoration(String name) {
        this.name = name;
    }

    public @NonNull String toString() {
        return this.name;
    }

    public static @NonNull Set<TextDecoration> setOf(TextDecoration ... decorations) {
        HashSet<TextDecoration> set = new HashSet<TextDecoration>(decorations.length);
        Collections.addAll(set, decorations);
        return set;
    }

    static {
        NAMES = NameMap.create((Enum[])TextDecoration.values(), constant -> constant.name);
    }

    public static enum State {
        NOT_SET{

            @Override
            public String toString() {
                return "null";
            }
        }
        ,
        FALSE,
        TRUE;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static @NonNull State byBoolean(boolean flag) {
            return flag ? TRUE : FALSE;
        }

        public static @NonNull State byBoolean(@Nullable Boolean flag) {
            return flag == null ? NOT_SET : State.byBoolean((boolean)flag);
        }
    }
}

