/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.text.AbstractComponent;
import net.kyori.text.AbstractComponentBuilder;
import net.kyori.text.Component;
import net.kyori.text.ComponentBuilder;
import net.kyori.text.TranslatableComponent;
import net.kyori.text.format.Style;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class TranslatableComponentImpl
extends AbstractComponent
implements TranslatableComponent {
    private final String key;
    private final List<Component> args;

    protected TranslatableComponentImpl(@NonNull List<Component> children, @NonNull Style style, @NonNull String key, @NonNull List<? extends Component> args) {
        super(children, style);
        this.key = key;
        this.args = Collections.unmodifiableList(new ArrayList<Component>(args));
    }

    @Override
    public @NonNull String key() {
        return this.key;
    }

    @Override
    public @NonNull TranslatableComponent key(@NonNull String key) {
        return new TranslatableComponentImpl(this.children, this.style, Objects.requireNonNull(key, "key"), this.args);
    }

    @Override
    public @NonNull List<Component> args() {
        return Collections.unmodifiableList(this.args);
    }

    @Override
    public @NonNull TranslatableComponent args(@NonNull List<? extends Component> args) {
        return new TranslatableComponentImpl(this.children, this.style, this.key, args);
    }

    @Override
    public @NonNull TranslatableComponent children(@NonNull List<Component> children) {
        return new TranslatableComponentImpl(children, this.style, this.key, this.args);
    }

    @Override
    public @NonNull TranslatableComponent style(@NonNull Style style) {
        return new TranslatableComponentImpl(this.children, style, this.key, this.args);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TranslatableComponent that = (TranslatableComponent)other;
        return Objects.equals(this.key, that.key()) && Objects.equals(this.args, that.args());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.args);
    }

    @Override
    protected void populateToString(@NonNull Map<String, Object> builder) {
        builder.put("key", this.key);
        builder.put("args", this.args);
    }

    @Override
    public @NonNull TranslatableComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends AbstractComponentBuilder<TranslatableComponent, TranslatableComponent.Builder>
    implements TranslatableComponent.Builder {
        private @Nullable String key;
        private List<? extends Component> args = AbstractComponent.EMPTY_COMPONENT_LIST;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.args();
        }

        @Override
        public @NonNull TranslatableComponent.Builder key(@NonNull String key) {
            this.key = key;
            return this;
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(ComponentBuilder<?, ?> ... args) {
            return this.args(Stream.of(args).map(ComponentBuilder::build).collect(Collectors.toList()));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(Component ... args) {
            return this.args(Arrays.asList(args));
        }

        @Override
        public @NonNull TranslatableComponent.Builder args(@NonNull List<? extends Component> args) {
            this.args = args;
            return this;
        }

        @Override
        public @NonNull TranslatableComponentImpl build() {
            if (this.key == null) {
                throw new IllegalStateException("key must be set");
            }
            return new TranslatableComponentImpl(this.children, this.buildStyle(), this.key, this.args);
        }
    }
}

