/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.text.AbstractBuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextComponent
extends AbstractBuildableComponent<TextComponent, Builder> {
    private final @NonNull String content;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String content) {
        return new Builder().content(content);
    }

    public static TextComponent of(@NonNull String content) {
        return TextComponent.builder(content).build();
    }

    public static TextComponent of(@NonNull String content, @Nullable TextColor color) {
        return TextComponent.of(content, color, Collections.emptySet());
    }

    public static TextComponent of(@NonNull String content, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return ((Builder)((Builder)TextComponent.builder(content).color(color)).decorations(decorations, true)).build();
    }

    public static TextComponent make(@NonNull Consumer<Builder> consumer) {
        Builder builder = TextComponent.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static TextComponent make(@NonNull String content, @NonNull Consumer<Builder> consumer) {
        Builder builder = TextComponent.builder(content);
        consumer.accept(builder);
        return builder.build();
    }

    protected TextComponent(@NonNull Builder builder) {
        super(builder);
        this.content = builder.content;
    }

    protected TextComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String content) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.content = content;
    }

    public @NonNull String content() {
        return this.content;
    }

    public @NonNull TextComponent content(@NonNull String content) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, Objects.requireNonNull(content, "content"));
    }

    @Override
    public @NonNull TextComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new TextComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent color(@Nullable TextColor color) {
        return new TextComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (TextComponent)super.decoration(decoration, flag);
    }

    @Override
    public @NonNull TextComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new TextComponent(this.children, this.color, this.obfuscated, Objects.requireNonNull(state, "flag"), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case ITALIC: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, Objects.requireNonNull(state, "flag"), this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case UNDERLINED: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, Objects.requireNonNull(state, "flag"), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case STRIKETHROUGH: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, Objects.requireNonNull(state, "flag"), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case OBFUSCATED: {
                return new TextComponent(this.children, this.color, Objects.requireNonNull(state, "flag"), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull TextComponent clickEvent(@Nullable ClickEvent event) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent insertion(@Nullable String insertion) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeStyle(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINED), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.content);
    }

    @Override
    public @NonNull TextComponent mergeColor(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINED) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new TextComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent mergeEvents(@NonNull Component that) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.content);
    }

    @Override
    public @NonNull TextComponent resetStyle() {
        return new TextComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.content);
    }

    @Override
    public @NonNull TextComponent copy() {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TextComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponent component = (TextComponent)other;
        return Objects.equals(this.content, component.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.content);
    }

    @Override
    protected void populateToString(@NonNull Map<String, Object> builder) {
        builder.put("content", this.content);
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<TextComponent, Builder> {
        private @Nullable String content;

        Builder() {
        }

        Builder(@NonNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        public @NonNull Builder content(@NonNull String content) {
            this.content = content;
            return this;
        }

        @Override
        public @NonNull TextComponent build() {
            if (this.content == null) {
                throw new IllegalStateException("content must be set");
            }
            return new TextComponent(this);
        }
    }
}

