/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractComponent
implements Component {
    protected static final List<Component> EMPTY_COMPONENT_LIST = Collections.emptyList();
    protected final List<Component> children;
    protected final @Nullable TextColor color;
    protected final TextDecoration.State obfuscated;
    protected final TextDecoration.State bold;
    protected final TextDecoration.State strikethrough;
    protected final TextDecoration.State underlined;
    protected final TextDecoration.State italic;
    protected final @Nullable ClickEvent clickEvent;
    protected final @Nullable HoverEvent hoverEvent;
    protected final @Nullable String insertion;

    protected AbstractComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion) {
        this.children = Collections.unmodifiableList(new ArrayList<Component>(children));
        this.color = color;
        this.obfuscated = obfuscated;
        this.bold = bold;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.italic = italic;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = insertion;
    }

    @Override
    public @NonNull List<Component> children() {
        return this.children;
    }

    @Override
    public @Nullable TextColor color() {
        return this.color;
    }

    @Override
    public @NonNull TextDecoration.State decoration(@NonNull TextDecoration decoration) {
        switch (decoration) {
            case BOLD: {
                return this.bold;
            }
            case ITALIC: {
                return this.italic;
            }
            case UNDERLINED: {
                return this.underlined;
            }
            case STRIKETHROUGH: {
                return this.strikethrough;
            }
            case OBFUSCATED: {
                return this.obfuscated;
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @Nullable ClickEvent clickEvent() {
        return this.clickEvent;
    }

    @Override
    public @Nullable HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    @Override
    public @Nullable String insertion() {
        return this.insertion;
    }

    @Override
    public boolean hasStyling() {
        return this.color != null || this.obfuscated != TextDecoration.State.NOT_SET || this.bold != TextDecoration.State.NOT_SET || this.strikethrough != TextDecoration.State.NOT_SET || this.underlined != TextDecoration.State.NOT_SET || this.italic != TextDecoration.State.NOT_SET || this.clickEvent != null || this.hoverEvent != null || this.insertion != null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractComponent)) {
            return false;
        }
        return this.equals((AbstractComponent)other);
    }

    protected boolean equals(@NonNull AbstractComponent that) {
        return Objects.equals(this.children, that.children) && this.color == that.color && Objects.equals((Object)this.obfuscated, (Object)that.obfuscated) && Objects.equals((Object)this.bold, (Object)that.bold) && Objects.equals((Object)this.strikethrough, (Object)that.strikethrough) && Objects.equals((Object)this.underlined, (Object)that.underlined) && Objects.equals((Object)this.italic, (Object)that.italic) && Objects.equals(this.clickEvent, that.clickEvent) && Objects.equals(this.hoverEvent, that.hoverEvent) && Objects.equals(this.insertion, that.insertion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion});
    }

    public @NonNull String toString() {
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        this.populateToString(builder);
        builder.put("children", this.children);
        builder.put("color", this.color);
        builder.put("obfuscated", (Object)this.obfuscated);
        builder.put("bold", (Object)this.bold);
        builder.put("strikethrough", (Object)this.strikethrough);
        builder.put("underlined", (Object)this.underlined);
        builder.put("italic", (Object)this.italic);
        builder.put("clickEvent", this.clickEvent);
        builder.put("hoverEvent", this.hoverEvent);
        builder.put("insertion", this.insertion);
        StringJoiner joiner = new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}");
        builder.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    protected void populateToString(@NonNull Map<String, Object> builder) {
    }
}

