/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.text.AbstractComponent;
import net.kyori.text.BuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBuildableComponent<C extends BuildableComponent<C, B>, B extends AbstractBuilder<C, B>>
extends AbstractComponent
implements BuildableComponent<C, B> {
    protected AbstractBuildableComponent(@NonNull B builder) {
        super(((AbstractBuilder)builder).children, ((AbstractBuilder)builder).color, ((AbstractBuilder)builder).obfuscated, ((AbstractBuilder)builder).bold, ((AbstractBuilder)builder).strikethrough, ((AbstractBuilder)builder).underlined, ((AbstractBuilder)builder).italic, ((AbstractBuilder)builder).clickEvent, ((AbstractBuilder)builder).hoverEvent, ((AbstractBuilder)builder).insertion);
    }

    protected AbstractBuildableComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
    }

    protected static abstract class AbstractBuilder<C extends BuildableComponent<C, B>, B extends AbstractBuilder<C, B>>
    implements BuildableComponent.Builder<C, B> {
        protected List<Component> children = AbstractComponent.EMPTY_COMPONENT_LIST;
        protected @Nullable TextColor color;
        protected TextDecoration.State obfuscated = TextDecoration.State.NOT_SET;
        protected TextDecoration.State bold = TextDecoration.State.NOT_SET;
        protected TextDecoration.State strikethrough = TextDecoration.State.NOT_SET;
        protected TextDecoration.State underlined = TextDecoration.State.NOT_SET;
        protected TextDecoration.State italic = TextDecoration.State.NOT_SET;
        protected @Nullable ClickEvent clickEvent;
        protected @Nullable HoverEvent hoverEvent;
        protected @Nullable String insertion;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@NonNull C component) {
            this.children = new ArrayList<Component>(component.children());
            this.color = component.color();
            this.obfuscated = component.decoration(TextDecoration.OBFUSCATED);
            this.bold = component.decoration(TextDecoration.BOLD);
            this.strikethrough = component.decoration(TextDecoration.STRIKETHROUGH);
            this.underlined = component.decoration(TextDecoration.UNDERLINED);
            this.italic = component.decoration(TextDecoration.ITALIC);
            this.clickEvent = Optional.ofNullable(component.clickEvent()).map(ClickEvent::copy).orElse(null);
            this.hoverEvent = Optional.ofNullable(component.hoverEvent()).map(HoverEvent::copy).orElse(null);
            this.insertion = component.insertion();
        }

        @Override
        public @NonNull B append(@NonNull Component component) {
            if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
                this.children = new ArrayList<Component>();
            }
            this.children.add(component);
            return (B)this;
        }

        @Override
        public @NonNull B append(@NonNull Iterable<? extends Component> components) {
            if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
                this.children = new ArrayList<Component>();
            }
            components.forEach(this.children::add);
            return (B)this;
        }

        @Override
        public @NonNull B applyDeep(@NonNull Consumer<BuildableComponent.Builder<?, ?>> consumer) {
            this.apply(consumer);
            if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
                return (B)this;
            }
            ListIterator<Component> it = this.children.listIterator();
            while (it.hasNext()) {
                Component child = it.next();
                if (!(child instanceof BuildableComponent)) continue;
                Object childBuilder = ((BuildableComponent)child).toBuilder();
                childBuilder.applyDeep(consumer);
                it.set((Component)childBuilder.build());
            }
            return (B)this;
        }

        @Override
        public @NonNull B mapChildren(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> function) {
            if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
                return (B)this;
            }
            ListIterator<Component> it = this.children.listIterator();
            while (it.hasNext()) {
                BuildableComponent<?, ?> mappedChild;
                Component child = it.next();
                if (!(child instanceof BuildableComponent) || child == (mappedChild = function.apply((BuildableComponent)child))) continue;
                it.set(mappedChild);
            }
            return (B)this;
        }

        @Override
        public @NonNull B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, BuildableComponent<?, ?>> function) {
            if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
                return (B)this;
            }
            ListIterator<Component> it = this.children.listIterator();
            while (it.hasNext()) {
                Component child = it.next();
                if (!(child instanceof BuildableComponent)) continue;
                BuildableComponent<?, ?> mappedChild = function.apply((BuildableComponent)child);
                if (mappedChild.children().isEmpty()) {
                    if (child == mappedChild) continue;
                    it.set(mappedChild);
                    continue;
                }
                Object builder = mappedChild.toBuilder();
                builder.mapChildrenDeep(function);
                it.set((Component)builder.build());
            }
            return (B)this;
        }

        @Override
        public @NonNull B color(@Nullable TextColor color) {
            this.color = color;
            return (B)this;
        }

        @Override
        public @NonNull B colorIfAbsent(@Nullable TextColor color) {
            if (this.color == null) {
                this.color = color;
            }
            return (B)this;
        }

        @Override
        public @NonNull B decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
            switch (decoration) {
                case BOLD: {
                    this.bold = Objects.requireNonNull(state, "flag");
                    return (B)this;
                }
                case ITALIC: {
                    this.italic = Objects.requireNonNull(state, "flag");
                    return (B)this;
                }
                case UNDERLINED: {
                    this.underlined = Objects.requireNonNull(state, "flag");
                    return (B)this;
                }
                case STRIKETHROUGH: {
                    this.strikethrough = Objects.requireNonNull(state, "flag");
                    return (B)this;
                }
                case OBFUSCATED: {
                    this.obfuscated = Objects.requireNonNull(state, "flag");
                    return (B)this;
                }
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
        }

        @Override
        public @NonNull B clickEvent(@Nullable ClickEvent event) {
            this.clickEvent = event;
            return (B)this;
        }

        @Override
        public @NonNull B hoverEvent(@Nullable HoverEvent event) {
            this.hoverEvent = event;
            return (B)this;
        }

        @Override
        public @NonNull B insertion(@Nullable String insertion) {
            this.insertion = insertion;
            return (B)this;
        }
    }
}

