/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.adapter.spongeapi;

import net.kyori.text.Component;
import net.kyori.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.serializer.TextSerializers;

public interface TextAdapter {
    public static void sendMessage(@NonNull MessageReceiver viewer, @NonNull Component component) {
        viewer.sendMessage(TextAdapter.toSponge(component));
    }

    public static void sendMessage(@NonNull Iterable<? extends MessageReceiver> viewers, @NonNull Component component) {
        Text text = TextAdapter.toSponge(component);
        for (MessageReceiver messageReceiver : viewers) {
            messageReceiver.sendMessage(text);
        }
    }

    public static void sendMessage(@NonNull ChatTypeMessageReceiver viewer, @NonNull Component component, @NonNull ChatType type) {
        viewer.sendMessage(type, TextAdapter.toSponge(component));
    }

    public static void sendMessage(@NonNull Iterable<? extends ChatTypeMessageReceiver> viewers, @NonNull Component component, @NonNull ChatType type) {
        Text text = TextAdapter.toSponge(component);
        for (ChatTypeMessageReceiver chatTypeMessageReceiver : viewers) {
            chatTypeMessageReceiver.sendMessage(type, text);
        }
    }

    @Deprecated
    public static void sendComponent(@NonNull MessageReceiver viewer, @NonNull Component component) {
        TextAdapter.sendMessage(viewer, component);
    }

    @Deprecated
    public static void sendComponent(@NonNull Iterable<? extends MessageReceiver> viewers, @NonNull Component component) {
        TextAdapter.sendMessage(viewers, component);
    }

    @Deprecated
    public static void sendComponent(@NonNull ChatTypeMessageReceiver viewer, @NonNull Component component, @NonNull ChatType type) {
        TextAdapter.sendMessage(viewer, component, type);
    }

    @Deprecated
    public static void sendComponent(@NonNull Iterable<? extends ChatTypeMessageReceiver> viewers, @NonNull Component component, @NonNull ChatType type) {
        TextAdapter.sendMessage(viewers, component, type);
    }

    public static @NonNull Text toSponge(@NonNull Component component) {
        return TextSerializers.JSON.deserialize(GsonComponentSerializer.INSTANCE.serialize(component));
    }
}

