/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.adapter.bukkit;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.kyori.text.Component;
import net.kyori.text.adapter.bukkit.Adapter;
import net.kyori.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class SpigotAdapter
implements Adapter {
    private static final boolean BOUND = SpigotAdapter.bind();

    SpigotAdapter() {
    }

    private static boolean bind() {
        try {
            Class<?> treeTypeAdapterClass;
            Field gsonField = ComponentSerializer.class.getDeclaredField("gson");
            gsonField.setAccessible(true);
            Field factoriesField = Gson.class.getDeclaredField("factories");
            factoriesField.setAccessible(true);
            Gson componentSerializerGson = (Gson)gsonField.get(null);
            Gson textGson = GsonComponentSerializer.populate((GsonBuilder)new GsonBuilder()).create();
            List existingFactories = (List)factoriesField.get(componentSerializerGson);
            List newFactories = (List)factoriesField.get(textGson);
            LinkedList<TypeAdapterFactory> modifiedFactories = new LinkedList<TypeAdapterFactory>(existingFactories);
            for (TypeAdapterFactory newFactory : Lists.reverse((List)newFactories)) {
                modifiedFactories.add(0, newFactory);
            }
            try {
                treeTypeAdapterClass = Class.forName("com.google.gson.internal.bind.TreeTypeAdapter");
            }
            catch (ClassNotFoundException e) {
                treeTypeAdapterClass = Class.forName("com.google.gson.TreeTypeAdapter");
            }
            Method newFactoryWithMatchRawTypeMethod = treeTypeAdapterClass.getMethod("newFactoryWithMatchRawType", TypeToken.class, Object.class);
            TypeAdapterFactory adapterComponentFactory = (TypeAdapterFactory)newFactoryWithMatchRawTypeMethod.invoke(null, TypeToken.get(AdapterComponent.class), new Serializer());
            modifiedFactories.add(0, adapterComponentFactory);
            factoriesField.set(componentSerializerGson, modifiedFactories);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void sendComponent(List<? extends CommandSender> viewers, Component component, boolean actionBar) {
        if (!BOUND) {
            return;
        }
        BaseComponent[] components = new BaseComponent[]{new AdapterComponent(component)};
        Iterator<? extends CommandSender> it = viewers.iterator();
        while (it.hasNext()) {
            CommandSender viewer = it.next();
            if (!(viewer instanceof Player)) continue;
            try {
                Player player = (Player)viewer;
                if (actionBar) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
                } else {
                    player.spigot().sendMessage(components);
                }
                it.remove();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static class Serializer
    implements JsonSerializer<AdapterComponent> {
        public JsonElement serialize(AdapterComponent src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.component);
        }
    }

    public static final class AdapterComponent
    extends BaseComponent {
        private final Component component;

        AdapterComponent(Component component) {
            this.component = component;
        }

        public BaseComponent duplicate() {
            return this;
        }
    }
}

