/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.examination.string;

import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Strings {
    private Strings() {
    }

    static @NonNull String withSuffix(String string, char suffix) {
        return string + suffix;
    }

    static @NonNull String wrapIn(String string, char wrap) {
        return wrap + string + wrap;
    }

    static int maxLength(Stream<String> strings) {
        return strings.mapToInt(String::length).max().orElse(0);
    }

    static @NonNull String repeat(@NonNull String string, int count) {
        if (count == 0) {
            return "";
        }
        if (count == 1) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    static @NonNull String padEnd(@NonNull String string, int minLength, char padding) {
        return string.length() >= minLength ? string : String.format("%-" + minLength + "s", Character.valueOf(padding));
    }
}

