/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

public final class PlainAudience
implements Audience {
    private final FabricAudiencesInternal controller;
    private final Pointered source;
    private final Consumer<String> plainOutput;

    public PlainAudience(FabricAudiencesInternal controller, Pointered source, Consumer<String> plainOutput) {
        this.controller = controller;
        this.source = source;
        this.plainOutput = plainOutput;
    }

    public void sendMessage(@NotNull Component message) {
        this.plainOutput.accept(PlainTextComponentSerializer.plainText().serialize(message));
    }

    public void sendMessage(@NotNull Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        this.plainOutput.accept(AdventureCommon.chatTypeToNative(boundChatType, this.controller).method_44837(this.controller.toNative(message)).getString());
    }

    @Deprecated
    public void sendMessage(Identity source, Component text, MessageType type) {
        this.sendMessage(text);
    }

    public void sendActionBar(@NotNull Component message) {
        this.sendMessage(message);
    }

    @NotNull
    public Pointers pointers() {
        return this.source.pointers();
    }
}

