/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.time.Duration;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.GameEnums;
import net.kyori.adventure.platform.fabric.impl.PointerProviderBridge;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.world.level.LevelAccess;
import net.kyori.adventure.platform.fabric.impl.client.AdventureBookAccess;
import net.kyori.adventure.platform.fabric.impl.client.BossHealthOverlayBridge;
import net.kyori.adventure.platform.fabric.impl.client.FabricClientAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.client.mixin.minecraft.resources.sounds.AbstractSoundInstanceAccess;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minecraft.class_1106;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1659;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientAudience
implements Audience {
    private final class_310 client;
    private final FabricClientAudiencesImpl controller;

    public ClientAudience(class_310 client, FabricClientAudiencesImpl renderer) {
        this.client = client;
        this.controller = renderer;
    }

    public void sendMessage(@NotNull Component message) {
        this.client.field_1705.method_1743().method_1812(this.controller.toNative(message));
    }

    private class_2556.class_7602 toMc(ChatType.Bound bound) {
        return AdventureCommon.chatTypeToNative(bound, this.controller);
    }

    public void sendMessage(@NotNull Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        class_2556.class_7602 bound = this.toMc(boundChatType);
        this.client.field_1705.method_1743().method_44811(bound.method_44837(this.controller.toNative(message)), null, class_7591.method_44709());
    }

    public void sendMessage(@NotNull SignedMessage signedMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        class_2556.class_7602 bound = this.toMc(boundChatType);
        Component message = (Component)Objects.requireNonNullElse(signedMessage.unsignedContent(), Component.text((String)signedMessage.message()));
        this.client.field_1705.method_1743().method_44811(bound.method_44837(this.controller.toNative(message)), (class_7469)signedMessage.signature(), this.tag(signedMessage));
    }

    private class_7591 tag(SignedMessage message) {
        if (message == null) {
            return null;
        }
        if (message.method_46293()) {
            return class_7591.method_44751();
        }
        if (message.unsignedContent() != null && !message.unsignedContent().equals(Component.text((String)message.message()))) {
            return class_7591.method_44710((String)message.message());
        }
        if (message.signature() == null) {
            return class_7591.method_44709();
        }
        return null;
    }

    public void deleteMessage(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SignedMessage.Signature signature) {
        this.client.field_1705.method_1743().method_44812((class_7469)signature);
    }

    @Deprecated
    public void sendMessage(Identity source, @NotNull Component message, @NotNull MessageType type) {
        if (this.client.method_29042(source.uuid())) {
            return;
        }
        class_1659 visibility = (class_1659)this.client.field_1690.method_42539().method_41753();
        if (type == MessageType.CHAT) {
            if (visibility == class_1659.field_7538) {
                this.client.field_1705.method_1743().method_44811(this.controller.toNative(message), null, null);
            }
        } else if (visibility == class_1659.field_7538 || visibility == class_1659.field_7539) {
            this.client.field_1705.method_1743().method_1812(this.controller.toNative(message));
        }
    }

    public void sendActionBar(@NotNull Component message) {
        this.client.field_1705.method_1758(this.controller.toNative(message), false);
    }

    public void showTitle(@NotNull Title title) {
        @Nullable class_2561 titleText = title.title() == Component.empty() ? null : this.controller.toNative(title.title());
        @Nullable class_2561 subtitleText = title.subtitle() == Component.empty() ? null : this.controller.toNative(title.subtitle());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Title.Times times = title.times();
        this.client.field_1705.method_34004(titleText);
        this.client.field_1705.method_34002(subtitleText);
        this.client.field_1705.method_34001(this.adventure$ticks(times == null ? null : times.fadeIn()), this.adventure$ticks(times == null ? null : times.stay()), this.adventure$ticks(times == null ? null : times.fadeOut()));
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            this.client.field_1705.method_34004(this.controller.toNative((Component)value));
        } else if (part == TitlePart.SUBTITLE) {
            this.client.field_1705.method_34002(this.controller.toNative((Component)value));
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.client.field_1705.method_34001(this.adventure$ticks(times.fadeIn()), this.adventure$ticks(times.stay()), this.adventure$ticks(times.fadeOut()));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + part + "'");
        }
    }

    private int adventure$ticks(@Nullable Duration duration) {
        return duration == null || duration.getSeconds() == -1L ? -1 : (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.client.field_1705.method_34004(null);
        this.client.field_1705.method_34002(null);
    }

    public void resetTitle() {
        this.client.field_1705.method_1742();
        this.clearTitle();
    }

    public void showBossBar(@NotNull BossBar bar) {
        BossHealthOverlayBridge.listener(this.client.field_1705.method_1740(), this.controller).add(bar);
    }

    public void hideBossBar(@NotNull BossBar bar) {
        BossHealthOverlayBridge.listener(this.client.field_1705.method_1740(), this.controller).remove(bar);
    }

    private long seed(@NotNull Sound sound) {
        if (sound.seed().isPresent()) {
            return sound.seed().getAsLong();
        }
        @Nullable class_746 player = this.client.field_1724;
        if (player != null) {
            return ((LevelAccess)player).accessor$threadSafeRandom().method_43055();
        }
        return 0L;
    }

    public void playSound(@NotNull Sound sound) {
        @Nullable class_746 player = this.client.field_1724;
        if (player != null) {
            this.playSound(sound, player.method_23317(), player.method_23318(), player.method_23321());
        } else {
            this.client.method_1483().method_4873((class_1113)new class_1109(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), sound.volume(), sound.pitch(), class_5819.method_43049((long)this.seed(sound)), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
        }
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        class_746 targetEntity;
        if (emitter == Sound.Emitter.self()) {
            targetEntity = this.client.field_1724;
        } else if (emitter instanceof class_1297) {
            class_1297 entity = (class_1297)emitter;
            targetEntity = entity;
        } else {
            throw new IllegalArgumentException("Provided emitter '" + emitter + "' was not Sound.Emitter.self() or an Entity");
        }
        class_1106 mcSound = new class_1106(class_3417.field_15197, GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), sound.volume(), sound.pitch(), (class_1297)targetEntity, this.seed(sound));
        ((AbstractSoundInstanceAccess)mcSound).setLocation(FabricAudiences.toNative(sound.name()));
        this.client.method_1483().method_4873((class_1113)mcSound);
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.client.method_1483().method_4873((class_1113)new class_1109(FabricAudiences.toNative(sound.name()), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), sound.volume(), sound.pitch(), class_5819.method_43049((long)this.seed(sound)), false, 0, class_1113.class_1114.field_5476, x, y, z, false));
    }

    public void stopSound(@NotNull SoundStop stop) {
        @Nullable Key sound = stop.sound();
        @Nullable class_2960 soundIdent = sound == null ? null : FabricAudiences.toNative(sound);
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Sound.Source source = stop.source();
        @Nullable class_3419 category = source == null ? null : GameEnums.SOUND_SOURCE.toMinecraft(source);
        this.client.method_1483().method_4875(soundIdent, category);
    }

    public void openBook(@NotNull Book book) {
        this.client.method_1507((class_437)new class_3872((class_3872.class_3931)new AdventureBookAccess(book, this.controller.partition(), this.controller.renderer())));
    }

    public void sendPlayerListHeader(@NotNull Component header) {
        this.client.field_1705.method_1750().method_1925(header == Component.empty() ? null : this.controller.toNative(header));
    }

    public void sendPlayerListFooter(@NotNull Component footer) {
        this.client.field_1705.method_1750().method_1925(footer == Component.empty() ? null : this.controller.toNative(footer));
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        this.sendPlayerListHeader(header);
        this.sendPlayerListFooter(footer);
    }

    @NotNull
    public Pointers pointers() {
        @Nullable class_746 clientPlayer = this.client.field_1724;
        if (clientPlayer != null) {
            return ((PointerProviderBridge)clientPlayer).adventure$pointers();
        }
        return super.pointers();
    }
}

