/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric;

import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.network.chat.Component_SerializerAccess;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.util.Index;
import net.minecraft.class_2178;
import org.jetbrains.annotations.NotNull;

public final class ComponentArgumentType
implements ArgumentType<Component> {
    private static final ComponentArgumentType JSON_INSTANCE = new ComponentArgumentType(Format.JSON);
    private static final ComponentArgumentType MINIMESSAGE_INSTANCE = new ComponentArgumentType(Format.MINIMESSAGE);
    private final Format format;

    @Deprecated(forRemoval=true, since="5.1.0")
    @NotNull
    public static ComponentArgumentType component() {
        return JSON_INSTANCE;
    }

    @NotNull
    public static Component component(@NotNull CommandContext<?> ctx, @NotNull String key) {
        return (Component)ctx.getArgument(key, Component.class);
    }

    @NotNull
    public static ComponentArgumentType json() {
        return JSON_INSTANCE;
    }

    @NotNull
    public static ComponentArgumentType miniMessage() {
        return MINIMESSAGE_INSTANCE;
    }

    @NotNull
    public static ComponentArgumentType component(@NotNull Format format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case Format.JSON -> JSON_INSTANCE;
            case Format.MINIMESSAGE -> MINIMESSAGE_INSTANCE;
        };
    }

    private ComponentArgumentType(Format format) {
        this.format = Objects.requireNonNull(format, "format");
    }

    @NotNull
    public Component parse(@NotNull com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
        String remaining = reader.getRemaining();
        try {
            ReadResult result = this.format.parse(remaining);
            reader.setCursor(reader.getCursor() + result.charsConsumed());
            return result.parsed();
        }
        catch (Exception ex) {
            String message = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
            throw class_2178.field_9842.createWithContext((ImmutableStringReader)reader, (Object)message);
        }
    }

    @NotNull
    public Collection<String> getExamples() {
        return this.format.examples();
    }

    @NotNull
    public Format format() {
        return this.format;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Format {
        JSON(Key.key((String)"adventure", (String)"json"), new String[]{"\"Hello world!\"", "[\"Message\", {\"text\": \"example\", \"color\": \"#aabbcc\"}]"}){

            @Override
            ReadResult parse(String allInput) throws Exception {
                try (JsonReader json = new JsonReader((Reader)new StringReader(allInput));){
                    Component ret = (Component)Component_SerializerAccess.getGSON().fromJson(json, Component.class);
                    ReadResult readResult = new ReadResult(ret, Component_SerializerAccess.getPos(json));
                    return readResult;
                }
            }
        }
        ,
        MINIMESSAGE(Key.key((String)"adventure", (String)"minimessage/v1"), new String[]{"<rainbow>hello world!", "hello <bold>everyone</bold> here!", "hello <hover:show_text:'sneak sneak'>everyone</hover> who likes <blue>cats"}){

            @Override
            ReadResult parse(String allInput) throws Exception {
                Component parsed = MiniMessage.miniMessage().deserialize((Object)allInput);
                return new ReadResult(parsed, allInput.length());
            }
        };

        public static final Index<Key, Format> INDEX;
        private final Key id;
        private final List<String> examples;

        private Format(Key id, String ... examples) {
            this.id = id;
            this.examples = List.of(examples);
        }

        abstract ReadResult parse(String var1) throws Exception;

        public Key id() {
            return this.id;
        }

        public List<String> examples() {
            return this.examples;
        }

        static {
            INDEX = Index.create(Format.class, Format::id);
        }
    }

    record ReadResult(Component parsed, int charsConsumed) {
    }
}

