/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.fabric.impl.client.ClientAudience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecraft.class_9039;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class ListeningPackFeedbackWrapper
implements class_9039 {
    private static final ComponentLogger LOGGER = ComponentLogger.logger();
    private static final Map<UUID, PackCallback> CALLBACKS = new ConcurrentHashMap<UUID, PackCallback>();
    private final class_9039 delegate;

    public static void registerCallback(UUID pack, ResourcePackCallback cb, ClientAudience audience) {
        if (CALLBACKS.put(pack, new PackCallback(cb, audience)) != null) {
            LOGGER.warn("Duplicate client resource pack callbacks registered for pack {}", (Object)pack);
        }
    }

    public ListeningPackFeedbackWrapper(class_9039 delegate) {
        this.delegate = delegate;
    }

    public void method_55620(UUID packId, class_9039.class_9060 status) {
        PackCallback cb = CALLBACKS.get(packId);
        if (cb != null) {
            ResourcePackStatus advStatus = switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case class_9039.class_9060.field_47699 -> ResourcePackStatus.ACCEPTED;
                case class_9039.class_9060.field_47700 -> ResourcePackStatus.DOWNLOADED;
            };
            cb.cb().packEventReceived(packId, advStatus, (Audience)cb.listener());
            return;
        }
        this.delegate.method_55620(packId, status);
    }

    public void method_55619(UUID packId, class_9039.class_9040 status) {
        PackCallback cb = CALLBACKS.remove(packId);
        if (cb != null) {
            ResourcePackStatus advStatus = switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case class_9039.class_9040.field_47623 -> ResourcePackStatus.DECLINED;
                case class_9039.class_9040.field_47624 -> ResourcePackStatus.SUCCESSFULLY_LOADED;
                case class_9039.class_9040.field_47625 -> ResourcePackStatus.DISCARDED;
                case class_9039.class_9040.field_47626 -> ResourcePackStatus.FAILED_DOWNLOAD;
                case class_9039.class_9040.field_47627 -> ResourcePackStatus.FAILED_RELOAD;
            };
            cb.cb().packEventReceived(packId, advStatus, (Audience)cb.listener());
            return;
        }
        this.delegate.method_55619(packId, status);
    }

    @Environment(value=EnvType.CLIENT)
    record PackCallback(@NotNull ResourcePackCallback cb, @NotNull ClientAudience listener) {
    }
}

