/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.client;

import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.fabric.FabricClientAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.platform.fabric.impl.client.ClientAudience;
import net.kyori.adventure.platform.fabric.impl.client.ClientWrappedComponent;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7659;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FabricClientAudiencesImpl
implements FabricClientAudiences,
FabricAudiencesInternal {
    public static final FabricClientAudiences INSTANCE = new Builder().build();
    private final Function<Pointered, ?> partition;
    private final ComponentRenderer<Pointered> renderer;
    private final ClientAudience audience;

    public FabricClientAudiencesImpl(Function<Pointered, ?> partition, ComponentRenderer<Pointered> renderer) {
        this.partition = partition;
        this.renderer = renderer;
        this.audience = new ClientAudience(class_310.method_1551(), this);
    }

    @Override
    @NotNull
    public Audience audience() {
        return this.audience;
    }

    @Override
    @NotNull
    public ComponentFlattener flattener() {
        return AdventureCommon.FLATTENER;
    }

    @Override
    @NotNull
    public ComponentRenderer<Pointered> renderer() {
        return this.renderer;
    }

    @Override
    @NotNull
    public class_2561 toNative(@NotNull Component adventure) {
        return new ClientWrappedComponent(Objects.requireNonNull(adventure, "adventure"), this.partition, this.renderer);
    }

    public Function<Pointered, ?> partition() {
        return this.partition;
    }

    @Override
    @NotNull
    public class_5455 registryAccess() {
        @Nullable class_638 level = class_310.method_1551().field_1687;
        return level == null ? class_7659.method_45139().method_45926() : level.method_30349();
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Builder
    implements FabricClientAudiences.Builder {
        private Function<Pointered, ?> partition;
        private ComponentRenderer<Pointered> renderer;

        public Builder() {
            this.componentRenderer(AdventureCommon.localePartition(), GlobalTranslator.renderer());
        }

        @Override
        public @NotNull FabricClientAudiences.Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.renderer = Objects.requireNonNull(componentRenderer, "componentRenderer");
            return this;
        }

        @Override
        public @NotNull FabricClientAudiences.Builder partition(@NotNull Function<Pointered, ?> partitionFunction) {
            this.partition = Objects.requireNonNull(partitionFunction, "partitionFunction");
            return this;
        }

        @Override
        @NotNull
        public FabricClientAudiences build() {
            return new FabricClientAudiencesImpl(this.partition, this.renderer);
        }
    }
}

