/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.util.Index;
import org.jetbrains.annotations.Nullable;

public class MappedRegistry<Mc, Adv> {
    private final Map<Mc, Adv> mcToAdventure;
    private final Map<Adv, Mc> adventureToMc;

    static <Mc extends Enum<Mc>, Adv extends Enum<Adv>> MappedRegistry<Mc, Adv> named(Class<Mc> mcType, Function<String, @Nullable Mc> mcByName, Class<Adv> advType, Index<String, Adv> names) {
        return new OfEnum<Mc, Enum>(mcType, mcByName, advType, arg_0 -> names.key(arg_0));
    }

    static <Mc, Adv> MappedRegistry<Mc, Adv> named(Function<String, @Nullable Mc> mcByName, Supplier<Iterable<Mc>> mcValues, Index<String, Adv> names, Supplier<Iterable<Adv>> adventureValues) {
        return new MappedRegistry(new HashMap(), new HashMap(), mcByName, mcValues, arg_0 -> names.key(arg_0), adventureValues);
    }

    MappedRegistry(Map<Mc, Adv> mcMap, Map<Adv, Mc> adventureMap, Function<String, @Nullable Mc> mcByName, Supplier<Iterable<Mc>> mcValues, Function<Adv, @Nullable String> advToName, Supplier<Iterable<Adv>> adventureValues) {
        this.mcToAdventure = mcMap;
        this.adventureToMc = adventureMap;
        for (Adv advElement : adventureValues.get()) {
            @Nullable String mcName = advToName.apply(advElement);
            if (mcName == null) {
                throw new ExceptionInInitializerError("Unable to get name for enum-like element " + advElement);
            }
            @Nullable Mc mcElement = mcByName.apply(mcName);
            if (mcElement == null) {
                throw new ExceptionInInitializerError("Unknown MC element for Adventure " + mcName);
            }
            this.mcToAdventure.put(mcElement, advElement);
            this.adventureToMc.put(advElement, mcElement);
        }
        MappedRegistry.checkCoverage(this.mcToAdventure, mcValues.get());
    }

    private static <T> void checkCoverage(Map<T, ?> toCheck, Iterable<T> values) throws IllegalStateException {
        for (T value : values) {
            if (toCheck.containsKey(value)) continue;
            throw new IllegalStateException("Unmapped " + value.getClass().getSimpleName() + " element '" + value + "!");
        }
    }

    public Adv toAdventure(Mc mcItem) {
        return Objects.requireNonNull(this.mcToAdventure.get(mcItem), "Invalid enum value presented: " + mcItem);
    }

    public Mc toMinecraft(Adv advItem) {
        return this.adventureToMc.get(advItem);
    }

    static class OfEnum<Mc extends Enum<Mc>, Adv extends Enum<Adv>>
    extends MappedRegistry<Mc, Adv> {
        OfEnum(Class<Mc> mcType, Function<String, @Nullable Mc> mcByName, Class<Adv> advType, Function<Adv, @Nullable String> advToName) {
            super(new EnumMap(mcType), new EnumMap(advType), mcByName, () -> Arrays.asList((Enum[])mcType.getEnumConstants()), advToName, () -> Arrays.asList((Enum[])advType.getEnumConstants()));
        }
    }
}

