/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.fabric.impl.HiddenRequirement;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5242;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ClickCallbackRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ClickCallbackRegistry INSTANCE = new ClickCallbackRegistry();
    public static final int CLEAN_UP_RATE = 30;
    private static final String UUID_ARG = "uuid";
    private static final String COMMAND_NAME = "adventure_callback";
    private static final Component FAILURE_MESSAGE = Component.text((String)"No callback with that ID could be found! You may have used it too many times, or it may have expired.", (TextColor)NamedTextColor.RED);
    private final Cache<UUID, CallbackRegistration> registrations = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).maximumSize(1024L).removalListener(notification -> LOGGER.debug("Removing callback {} from cache for reason {}", notification.getKey(), (Object)notification.getCause())).build();

    private ClickCallbackRegistry() {
    }

    public String register(ClickCallback<Audience> callback, ClickCallback.Options options) {
        UUID id = UUID.randomUUID();
        CallbackRegistration reg = new CallbackRegistration(options, callback, Instant.now().plus(options.lifetime()), new AtomicInteger());
        this.registrations.put((Object)id, (Object)reg);
        return "/adventure_callback " + id;
    }

    public void registerToDispatcher(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).requires(HiddenRequirement.alwaysAllowed())).then(class_2170.method_9244((String)UUID_ARG, (ArgumentType)class_5242.method_27643()).executes(ctx -> {
            Instant now;
            int useCount;
            UUID callbackId = class_5242.method_27645((CommandContext)ctx, (String)UUID_ARG);
            @Nullable CallbackRegistration reg = (CallbackRegistration)this.registrations.getIfPresent((Object)callbackId);
            if (reg == null) {
                ((class_2168)ctx.getSource()).sendFailure(FAILURE_MESSAGE);
                return 0;
            }
            boolean expire = false;
            boolean allowUse = true;
            int allowedUses = reg.options.uses();
            if (allowedUses != -1 && (useCount = reg.useCount().incrementAndGet()) >= allowedUses) {
                expire = true;
                boolean bl = allowUse = useCount <= allowedUses;
            }
            if ((now = Instant.now()).isAfter(reg.expiryTime())) {
                expire = true;
                allowUse = false;
            }
            if (expire) {
                this.registrations.invalidate((Object)callbackId);
            }
            if (allowUse) {
                reg.callback().accept((Audience)ctx.getSource());
            } else {
                ((class_2168)ctx.getSource()).sendFailure(FAILURE_MESSAGE);
            }
            return 1;
        })));
    }

    public void cleanUp() {
        Instant now = Instant.now();
        HashSet<UUID> uuidsToClean = new HashSet<UUID>();
        for (Map.Entry entry : this.registrations.asMap().entrySet()) {
            CallbackRegistration reg = (CallbackRegistration)entry.getValue();
            int allowedUses = reg.options().uses();
            if (allowedUses != -1 && reg.useCount().get() >= allowedUses) {
                uuidsToClean.add((UUID)entry.getKey());
                continue;
            }
            if (!now.isAfter(reg.expiryTime())) continue;
            uuidsToClean.add((UUID)entry.getKey());
        }
        for (UUID id : uuidsToClean) {
            this.registrations.invalidate((Object)id);
        }
    }

    private record CallbackRegistration(ClickCallback.Options options, ClickCallback<Audience> callback, Instant expiryTime, AtomicInteger useCount) {
    }
}

