/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.log4j2;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.dsn.InvalidDsnException;
import net.kencochrane.raven.environment.RavenEnvironment;
import net.kencochrane.raven.event.Event;
import net.kencochrane.raven.event.EventBuilder;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.event.interfaces.SentryInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Raven", category="Core", elementType="appender", printObject=true)
public class SentryAppender
extends AbstractAppender {
    public static final String APPENDER_NAME = "raven";
    public static final String LOG4J_NDC = "log4j2-NDC";
    public static final String LOG4J_MARKER = "log4j2-Marker";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected Map<String, String> tags = Collections.emptyMap();
    private Set<String> extraTags = Collections.emptySet();

    public SentryAppender() {
        this(APPENDER_NAME, null);
    }

    public SentryAppender(Raven raven) {
        this(APPENDER_NAME, null);
        this.raven = raven;
    }

    private SentryAppender(String name, Filter filter) {
        super(name, filter, null, true);
    }

    @PluginFactory
    public static SentryAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="dsn") String dsn, @PluginAttribute(value="ravenFactory") String ravenFactory, @PluginAttribute(value="tags") String tags, @PluginAttribute(value="extraTags") String extraTags, @PluginElement(value="filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        SentryAppender sentryAppender = new SentryAppender(name, filter);
        sentryAppender.setDsn(dsn);
        if (tags != null) {
            sentryAppender.setTags(tags);
        }
        if (extraTags != null) {
            sentryAppender.setExtraTags(extraTags);
        }
        sentryAppender.setRavenFactory(ravenFactory);
        return sentryAppender;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return Event.Level.INFO;
        }
        return Event.Level.DEBUG;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> stringParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            stringParameters.add(parameter != null ? parameter.toString() : null);
        }
        return stringParameters;
    }

    public void append(LogEvent logEvent) {
        if (RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(logEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.error("An exception occurred while creating a new event in Raven", logEvent, e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.error("An exception occurred during the retrieval of the DSN for Raven", e);
        }
        catch (Exception e) {
            this.error("An exception occurred during the creation of a Raven instance", e);
        }
    }

    protected Event buildEvent(LogEvent event) {
        Throwable throwable;
        Message eventMessage = event.getMessage();
        EventBuilder eventBuilder = new EventBuilder().withTimestamp(new Date(event.getTimeMillis())).withMessage(eventMessage.getFormattedMessage()).withLogger(event.getLoggerName()).withLevel(SentryAppender.formatLevel(event.getLevel())).withExtra(THREAD_NAME, (Object)event.getThreadName());
        if (!eventMessage.getFormattedMessage().equals(eventMessage.getFormat())) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(eventMessage.getFormat(), SentryAppender.formatMessageParameters(eventMessage.getParameters())));
        }
        if ((throwable = event.getThrown()) != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (event.getSource() != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{event.getSource()};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (event.getSource() != null) {
            eventBuilder.withCulprit(event.getSource());
        } else {
            eventBuilder.withCulprit(event.getLoggerName());
        }
        if (event.getContextStack() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)event.getContextStack().asList());
        }
        if (event.getContextMap() != null) {
            for (Map.Entry<Object, Object> entry : event.getContextMap().entrySet()) {
                if (this.extraTags.contains(entry.getKey())) {
                    eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
            }
        }
        if (event.getMarker() != null) {
            eventBuilder.withTag(LOG4J_MARKER, event.getMarker().getName());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setTags(String tags) {
        this.tags = Splitter.on((String)",").withKeyValueSeparator(":").split((CharSequence)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = new HashSet<String>(Arrays.asList(extraTags.split(",")));
    }

    public void stop() {
        RavenEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.error("An exception occurred while closing the Raven connection", e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }
}

