/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Map;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.services.Container;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsScheme;

@Immutable
public abstract class FsAbstractCompositeDriver
implements FsCompositeDriver,
Container<Map<FsScheme, FsDriver>> {
    @Override
    public final FsModel newModel(FsManager context, FsMountPoint mountPoint, FsModel parent) {
        assert (null != parent ? parent.getMountPoint().equals(mountPoint.getParent()) : null == mountPoint.getParent());
        return this.driver(mountPoint).newModel(context, mountPoint, parent);
    }

    @Override
    public final FsController newController(FsManager context, FsModel model, @CheckForNull FsController parent) throws ServiceConfigurationError {
        assert (null != parent ? parent.getModel().equals(model.getParent()) : null == model.getParent());
        return this.driver(model.getMountPoint()).newController(context, model, parent);
    }

    private FsDriver driver(FsMountPoint mountPoint) {
        FsScheme scheme = mountPoint.getScheme();
        FsDriver driver = (FsDriver)((Map)this.get()).get(scheme);
        if (null == driver) {
            throw new ServiceConfigurationError(scheme + " (Unknown file system scheme! May be the class path doesn't contain the respective driver module or it isn't set up correctly?)");
        }
        return driver;
    }
}

