/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes.crypto;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.MutableBuffer;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.util.SuspensionPenalty;
import net.java.truevfs.comp.zip.crypto.CipherReadOnlyChannel;
import net.java.truevfs.comp.zip.crypto.CtrBlockCipher;
import net.java.truevfs.comp.zip.crypto.SeekableBlockCipher;
import net.java.truevfs.driver.zip.raes.crypto.RaesAuthenticationException;
import net.java.truevfs.driver.zip.raes.crypto.RaesException;
import net.java.truevfs.driver.zip.raes.crypto.RaesOutputStream;
import net.java.truevfs.driver.zip.raes.crypto.RaesReadOnlyChannel;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class Type0RaesReadOnlyChannel
extends RaesReadOnlyChannel {
    private final AesKeyStrength keyStrength;
    private final ByteBuffer authenticationCode;
    private final KeyParameter sha256MacParam;

    Type0RaesReadOnlyChannel(Type0RaesParameters param, @WillCloseWhenClosed SeekableByteChannel channel) throws IOException {
        KeyParameter sha256MacParam;
        ParametersWithIV aesCtrParam;
        byte[] buf;
        AesKeyStrength keyStrength;
        assert (null != param);
        assert (null != channel);
        MutableBuffer header = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)8).littleEndian()).load((ReadableByteChannel)channel.position(0L));
        int type = ((MutableBuffer)header.position(4)).getUByte();
        assert (0 == type);
        int keyStrengthOrdinal = header.getUByte();
        try {
            keyStrength = AesKeyStrength.values()[keyStrengthOrdinal];
            assert (keyStrength.ordinal() == keyStrengthOrdinal);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RaesException("Unknown index for cipher key strength: " + keyStrengthOrdinal);
        }
        int keyStrengthBytes = keyStrength.getBytes();
        int keyStrengthBits = keyStrength.getBits();
        this.keyStrength = keyStrength;
        int iCount = header.getUShort();
        if (1024 > iCount) {
            throw new RaesException("Iteration count must be 1024 or greater, but is " + iCount + "!");
        }
        MutableBuffer salt = (MutableBuffer)MutableBuffer.allocate((int)keyStrengthBytes).load((ReadableByteChannel)channel);
        HMac klac = new HMac((Digest)new SHA256Digest());
        MutableBuffer footer = MutableBuffer.allocate((int)klac.getMacSize());
        long start = channel.position();
        long end = channel.size() - (long)footer.limit();
        long length = end - start;
        if (0L > length) {
            throw new RaesException("False positive Type 0 RAES file is too short!", new EOFException());
        }
        ((MutableBuffer)footer.load((ReadableByteChannel)channel.position(end))).position(footer.limit() / 2);
        if (channel.position() != channel.size()) {
            throw new RaesException("Expected end of file after data envelope trailer!");
        }
        this.authenticationCode = footer.slice().buffer();
        ByteBuffer passwdVerifier = ((MutableBuffer)footer.flip()).buffer();
        PKCS12ParametersGenerator gen = new PKCS12ParametersGenerator((Digest)new SHA256Digest());
        long lastTry = 0L;
        do {
            char[] pwc = param.getPasswordForReading(0L != lastTry);
            assert (null != pwc);
            byte[] pwb = PBEParametersGenerator.PKCS12PasswordToBytes((char[])pwc);
            Arrays.fill(pwc, '\u0000');
            gen.init(pwb, salt.array(), iCount);
            aesCtrParam = (ParametersWithIV)gen.generateDerivedParameters(keyStrengthBits, 128);
            sha256MacParam = (KeyParameter)gen.generateDerivedMacParameters(keyStrengthBits);
            Arrays.fill(pwb, (byte)0);
            lastTry = SuspensionPenalty.enforce((long)lastTry);
            klac.init((CipherParameters)sha256MacParam);
            byte[] cipherKey = ((KeyParameter)aesCtrParam.getParameters()).getKey();
            klac.update(cipherKey, 0, cipherKey.length);
            buf = new byte[klac.getMacSize()];
            RaesOutputStream.klac((Mac)klac, length, buf);
        } while (!passwdVerifier.equals(ByteBuffer.wrap(buf, 0, buf.length / 2)));
        this.sha256MacParam = sha256MacParam;
        CtrBlockCipher cipher = new CtrBlockCipher((BlockCipher)new AESEngine());
        cipher.init(false, (CipherParameters)aesCtrParam);
        this.channel = new CipherReadOnlyChannel((SeekableBlockCipher)cipher, (SeekableByteChannel)new IntervalReadOnlyChannel(channel.position(start), length));
        param.setKeyStrength(keyStrength);
    }

    @Override
    public AesKeyStrength getKeyStrength() {
        return this.keyStrength;
    }

    @Override
    public void authenticate() throws IOException {
        HMac mac = new HMac((Digest)new SHA256Digest());
        mac.init((CipherParameters)this.sha256MacParam);
        byte[] buf = ((CipherReadOnlyChannel)this.channel).mac((Mac)mac);
        assert (buf.length == mac.getMacSize());
        if (!this.authenticationCode.equals(ByteBuffer.wrap(buf, 0, buf.length / 2))) {
            throw new RaesAuthenticationException();
        }
    }
}

