/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.http;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.http.HttpDriver;
import net.java.truevfs.driver.http.HttpNode;
import net.java.truevfs.kernel.spec.FsAbstractController;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsReadOnlyFileSystemException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import org.apache.http.HttpResponse;

@Immutable
public class HttpController
extends FsAbstractController {
    private static final BitField<Entry.Access> READ_ONLY = BitField.of((Enum)Entry.Access.READ);
    private final HttpDriver driver;

    HttpController(HttpDriver driver, FsModel model) {
        super(model);
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        assert (null != driver);
        this.driver = driver;
    }

    final IoBufferPool getPool() {
        return this.driver.getPool();
    }

    final HttpResponse executeHead(HttpNode entry) throws IOException {
        return this.driver.executeHead(entry);
    }

    final HttpResponse executeGet(HttpNode entry) throws IOException {
        return this.driver.executeGet(entry);
    }

    protected HttpNode newEntry(FsNodeName name) {
        return new HttpNode(this, name);
    }

    final FsNodePath resolve(FsNodeName name) {
        return this.getMountPoint().resolve(name);
    }

    public FsController getParent() {
        return null;
    }

    public HttpNode node(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        HttpNode entry = this.newEntry(name);
        return entry.isType(Entry.Type.FILE) ? entry : null;
    }

    public void checkAccess(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types) throws IOException {
        if (!types.isEmpty() && !READ_ONLY.equals(types)) {
            throw new FsReadOnlyFileSystemException(this.getMountPoint());
        }
        this.executeHead(this.newEntry(name));
    }

    public void setReadOnly(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
    }

    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types, long value) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public InputSocket<?> input(BitField<FsAccessOption> options, FsNodeName name) {
        return this.newEntry(name).input(options);
    }

    public OutputSocket<?> output(BitField<FsAccessOption> options, FsNodeName name, @CheckForNull Entry template) {
        return this.newEntry(name).output(options, template);
    }

    public void make(BitField<FsAccessOption> options, FsNodeName name, Entry.Type type, @CheckForNull Entry template) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public void unlink(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public void sync(BitField<FsSyncOption> options) {
    }
}

