/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.OsxKeyProvider;
import net.java.truecommons.key.macosx.keychain.DuplicateItemException;
import net.java.truecommons.key.macosx.keychain.Keychain;
import net.java.truecommons.key.macosx.keychain.KeychainException;
import net.java.truecommons.key.spec.AbstractKeyManager;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.prompting.AbstractPromptingPbeParameters;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.shed.Buffers;
import net.java.truecommons.shed.Option;

@ThreadSafe
public final class OsxKeyManager<P extends AbstractPromptingPbeParameters<P, ?>>
extends AbstractKeyManager<P> {
    private static final String KEYCHAIN = "TrueCommons KeyManager";
    private static final String ACCOUNT = "TrueCommons KeyManager";
    private final KeyManager<P> manager;
    private final Class<P> keyClass;
    private volatile boolean skip;

    public OsxKeyManager(KeyManager<P> manager, Class<P> keyClass) {
        this.manager = Objects.requireNonNull(manager);
        this.keyClass = Objects.requireNonNull(keyClass);
    }

    public KeyProvider<P> provider(URI uri) {
        return new OsxKeyProvider(this, uri, this.manager.provider(uri));
    }

    public void release(URI uri) {
        this.skip = false;
        this.manager.release(uri);
    }

    public void link(URI originUri, URI targetUri) {
        Option<P> param = this.getKey(originUri);
        this.manager.link(originUri, targetUri);
        this.setKey(targetUri, param);
    }

    public void unlink(URI uri) {
        this.manager.unlink(uri);
        this.setKey(uri, Option.none());
    }

    Option<P> getKey(URI uri) {
        GetKeyAction action = new GetKeyAction();
        this.runAction(uri, action);
        return action.param;
    }

    void setKey(URI uri, Option<P> optionalParam) {
        this.runAction(uri, new SetKeyAction(optionalParam));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Option<ByteBuffer> serialize(Option<?> optionalObject) {
        Iterator i$ = optionalObject.iterator();
        if (!i$.hasNext()) return Option.none();
        Object object = i$.next();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(512);){
            try (XMLEncoder encoder = new XMLEncoder(bos);){
                encoder.writeObject(object);
            }
            bos.flush();
            Option option = Option.some((Object)Buffers.copy((ByteBuffer)ByteBuffer.wrap(bos.toByteArray())));
            return option;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Option<?> deserialize(Option<ByteBuffer> optionalXml) {
        Iterator i$ = optionalXml.iterator();
        if (i$.hasNext()) {
            ByteBuffer xml = (ByteBuffer)i$.next();
            byte[] array = new byte[xml.remaining()];
            xml.duplicate().get(array);
            try (XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(array));){
                Option option = Option.apply((Object)decoder.readObject());
                return option;
            }
        }
        return Option.none();
    }

    private void runAction(final URI uri, Action action) {
        if (!this.skip) {
            try (final Keychain keychain = Keychain.open("TrueCommons KeyManager", null);){
                action.run(new Controller(){
                    final Map<Keychain.AttributeClass, ByteBuffer> attributes = new EnumMap<Keychain.AttributeClass, ByteBuffer>(Keychain.AttributeClass.class);
                    {
                        this.attributes.put(Keychain.AttributeClass.ACCOUNT, Buffers.byteBuffer((String)"TrueCommons KeyManager"));
                        this.attributes.put(Keychain.AttributeClass.SERVICE, Buffers.byteBuffer((String)uri.toString()));
                    }

                    @Override
                    public void setAttribute(Keychain.AttributeClass key, Option<ByteBuffer> optionalValue) {
                        Iterator i$ = optionalValue.iterator();
                        if (i$.hasNext()) {
                            ByteBuffer value = (ByteBuffer)i$.next();
                            this.attributes.put(key, value);
                            return;
                        }
                        this.attributes.remove((Object)key);
                    }

                    @Override
                    public void createItem(ByteBuffer secret) throws KeychainException {
                        keychain.createItem(Keychain.ItemClass.GENERIC_PASSWORD, this.attributes, secret);
                    }

                    @Override
                    public void visitItems(Keychain.Visitor visitor) throws KeychainException {
                        keychain.visitItems(Keychain.ItemClass.GENERIC_PASSWORD, this.attributes, visitor);
                    }
                });
            }
            catch (Exception e) {
                this.skip = true;
                new LocalizedLogger(OsxKeyManager.class).debug("access.exception", (Throwable)e);
            }
        }
    }

    private final class SetKeyAction
    implements Action {
        private final Option<P> optionalParam;

        public SetKeyAction(Option<P> optionalParam) {
            this.optionalParam = optionalParam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Controller controller) throws KeychainException {
            Iterator i$ = this.optionalParam.iterator();
            if (i$.hasNext()) {
                AbstractPromptingPbeParameters param = (AbstractPromptingPbeParameters)i$.next();
                Iterator i$2 = Option.apply((Object)param.getSecret()).iterator();
                if (i$2.hasNext()) {
                    final ByteBuffer newSecret = (ByteBuffer)i$2.next();
                    try {
                        final Option<ByteBuffer> newXml = OsxKeyManager.serialize(this.optionalParam);
                        final Option<?> newParam = OsxKeyManager.deserialize(newXml);
                        try {
                            controller.setAttribute(Keychain.AttributeClass.GENERIC, newXml);
                            controller.createItem(newSecret);
                        }
                        catch (DuplicateItemException ex) {
                            controller.setAttribute(Keychain.AttributeClass.GENERIC, (Option<ByteBuffer>)Option.none());
                            class UpdateVisitor
                            implements Keychain.Visitor {
                                UpdateVisitor() {
                                }

                                @Override
                                public void visit(Keychain.Item item) throws KeychainException {
                                    Option oldXml;
                                    Option<?> oldParam;
                                    ByteBuffer oldSecret = item.getSecret();
                                    if (!newSecret.equals(oldSecret)) {
                                        item.setSecret(newSecret);
                                    }
                                    if (!newParam.equals(oldParam = OsxKeyManager.deserialize((Option<ByteBuffer>)(oldXml = Option.apply((Object)item.getAttribute(Keychain.AttributeClass.GENERIC)))))) {
                                        item.setAttribute(Keychain.AttributeClass.GENERIC, (ByteBuffer)newXml.get());
                                    }
                                }
                            }
                            controller.visitItems(new UpdateVisitor());
                        }
                    }
                    finally {
                        Buffers.fill((ByteBuffer)newSecret, (byte)0);
                    }
                    return;
                }
                throw new IllegalStateException();
            }
            class DeleteVisitor
            implements Keychain.Visitor {
                DeleteVisitor() {
                }

                @Override
                public void visit(Keychain.Item item) throws KeychainException {
                    item.delete();
                }
            }
            controller.visitItems(new DeleteVisitor());
        }
    }

    private final class GetKeyAction
    implements Action,
    Keychain.Visitor {
        Option<P> param = Option.none();

        private GetKeyAction() {
        }

        @Override
        public void run(Controller controller) throws KeychainException {
            controller.visitItems(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(Keychain.Item item) throws KeychainException {
            this.param = OsxKeyManager.deserialize((Option<ByteBuffer>)Option.apply((Object)item.getAttribute(Keychain.AttributeClass.GENERIC)));
            if (this.param.isEmpty()) {
                this.param = Option.some(this.newKey());
            }
            for (AbstractPromptingPbeParameters p : this.param) {
                assert (null == p.getSecret());
                ByteBuffer secret = item.getSecret();
                try {
                    p.setSecret(secret);
                }
                finally {
                    Buffers.fill((ByteBuffer)secret, (byte)0);
                }
            }
        }

        private P newKey() {
            try {
                return (AbstractPromptingPbeParameters)OsxKeyManager.this.keyClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static interface Controller {
        public void setAttribute(Keychain.AttributeClass var1, Option<ByteBuffer> var2);

        public void createItem(ByteBuffer var1) throws KeychainException;

        public void visitItems(Keychain.Visitor var1) throws KeychainException;
    }

    private static interface Action {
        public void run(Controller var1) throws KeychainException;
    }
}

