package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiZodiac {

    /**
     * ♈
     */
    Emoji ARIES = new Emoji("♈", "\u2648", Collections.singletonList(":aries:"), Collections.singletonList(":aries:"), Collections.singletonList(":aries:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Aries", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♉
     */
    Emoji TAURUS = new Emoji("♉", "\u2649", Collections.singletonList(":taurus:"), Collections.singletonList(":taurus:"), Collections.singletonList(":taurus:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Taurus", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♊
     */
    Emoji GEMINI = new Emoji("♊", "\u264A", Collections.singletonList(":gemini:"), Collections.singletonList(":gemini:"), Collections.singletonList(":gemini:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Gemini", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♋
     */
    Emoji CANCER = new Emoji("♋", "\u264B", Collections.singletonList(":cancer:"), Collections.singletonList(":cancer:"), Collections.singletonList(":cancer:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Cancer", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♌
     */
    Emoji LEO = new Emoji("♌", "\u264C", Collections.singletonList(":leo:"), Collections.singletonList(":leo:"), Collections.singletonList(":leo:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Leo", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♍
     */
    Emoji VIRGO = new Emoji("♍", "\u264D", Collections.singletonList(":virgo:"), Collections.singletonList(":virgo:"), Collections.singletonList(":virgo:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Virgo", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♎
     */
    Emoji LIBRA = new Emoji("♎", "\u264E", Collections.singletonList(":libra:"), Collections.singletonList(":libra:"), Collections.singletonList(":libra:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Libra", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♏
     */
    Emoji SCORPIO = new Emoji("♏", "\u264F", Collections.unmodifiableList(Arrays.asList(":scorpius:", ":scorpio:")), Collections.singletonList(":scorpius:"), Collections.singletonList(":scorpius:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Scorpio", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♐
     */
    Emoji SAGITTARIUS = new Emoji("♐", "\u2650", Collections.singletonList(":sagittarius:"), Collections.singletonList(":sagittarius:"), Collections.singletonList(":sagittarius:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Sagittarius", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♑
     */
    Emoji CAPRICORN = new Emoji("♑", "\u2651", Collections.singletonList(":capricorn:"), Collections.singletonList(":capricorn:"), Collections.singletonList(":capricorn:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Capricorn", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♒
     */
    Emoji AQUARIUS = new Emoji("♒", "\u2652", Collections.singletonList(":aquarius:"), Collections.singletonList(":aquarius:"), Collections.singletonList(":aquarius:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Aquarius", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ♓
     */
    Emoji PISCES = new Emoji("♓", "\u2653", Collections.singletonList(":pisces:"), Collections.singletonList(":pisces:"), Collections.singletonList(":pisces:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Pisces", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);

    /**
     * ⛎
     */
    Emoji OPHIUCHUS = new Emoji("⛎", "\u26CE", Collections.singletonList(":ophiuchus:"), Collections.singletonList(":ophiuchus:"), Collections.singletonList(":ophiuchus:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "Ophiuchus", EmojiGroup.SYMBOLS, EmojiSubGroup.ZODIAC, true);
}
