package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiWriting {

    /**
     * ✏️
     */
    Emoji PENCIL = new Emoji("✏️", "\u270F\uFE0F", Collections.singletonList(":pencil2:"), Collections.singletonList(":pencil2:"), Collections.singletonList(":pencil2:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "pencil", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * ✏
     */
    Emoji PENCIL_UNQUALIFIED = new Emoji("✏", "\u270F", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":pencil2:"), false, false, 0.6, Qualification.fromString("unqualified"), "pencil", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * ✒️
     */
    Emoji BLACK_NIB = new Emoji("✒️", "\u2712\uFE0F", Collections.singletonList(":black_nib:"), Collections.singletonList(":black_nib:"), Collections.singletonList(":black_nib:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black nib", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * ✒
     */
    Emoji BLACK_NIB_UNQUALIFIED = new Emoji("✒", "\u2712", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":black_nib:"), false, false, 0.6, Qualification.fromString("unqualified"), "black nib", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * 🖋️
     */
    Emoji FOUNTAIN_PEN = new Emoji("🖋️", "\uD83D\uDD8B\uFE0F", Collections.unmodifiableList(Arrays.asList(":pen_fountain:", ":lower_left_fountain_pen:", ":fountain_pen:")), Collections.singletonList(":lower_left_fountain_pen:"), Collections.singletonList(":fountain_pen:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "fountain pen", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * 🖋
     */
    Emoji FOUNTAIN_PEN_UNQUALIFIED = new Emoji("🖋", "\uD83D\uDD8B", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":fountain_pen:"), false, false, 0.7, Qualification.fromString("unqualified"), "fountain pen", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * 🖊️
     */
    Emoji PEN = new Emoji("🖊️", "\uD83D\uDD8A\uFE0F", Collections.unmodifiableList(Arrays.asList(":pen_ballpoint:", ":lower_left_ballpoint_pen:", ":pen:")), Collections.singletonList(":lower_left_ballpoint_pen:"), Collections.singletonList(":pen:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "pen", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * 🖊
     */
    Emoji PEN_UNQUALIFIED = new Emoji("🖊", "\uD83D\uDD8A", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":pen:"), false, false, 0.7, Qualification.fromString("unqualified"), "pen", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * 🖌️
     */
    Emoji PAINTBRUSH = new Emoji("🖌️", "\uD83D\uDD8C\uFE0F", Collections.unmodifiableList(Arrays.asList(":paintbrush:", ":lower_left_paintbrush:")), Collections.singletonList(":lower_left_paintbrush:"), Collections.singletonList(":paintbrush:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "paintbrush", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * 🖌
     */
    Emoji PAINTBRUSH_UNQUALIFIED = new Emoji("🖌", "\uD83D\uDD8C", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":paintbrush:"), false, false, 0.7, Qualification.fromString("unqualified"), "paintbrush", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * 🖍️
     */
    Emoji CRAYON = new Emoji("🖍️", "\uD83D\uDD8D\uFE0F", Collections.unmodifiableList(Arrays.asList(":crayon:", ":lower_left_crayon:")), Collections.singletonList(":lower_left_crayon:"), Collections.singletonList(":crayon:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "crayon", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);

    /**
     * 🖍
     */
    Emoji CRAYON_UNQUALIFIED = new Emoji("🖍", "\uD83D\uDD8D", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":crayon:"), false, false, 0.7, Qualification.fromString("unqualified"), "crayon", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, true);

    /**
     * 📝
     */
    Emoji MEMO = new Emoji("📝", "\uD83D\uDCDD", Collections.unmodifiableList(Arrays.asList(":pencil:", ":memo:")), Collections.singletonList(":memo:"), Collections.unmodifiableList(Arrays.asList(":memo:", ":pencil:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "memo", EmojiGroup.OBJECTS, EmojiSubGroup.WRITING, false);
}
