package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiWarning {

    /**
     * ⚠️
     */
    Emoji WARNING = new Emoji("⚠️", "\u26A0\uFE0F", Collections.singletonList(":warning:"), Collections.singletonList(":warning:"), Collections.singletonList(":warning:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "warning", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * ⚠
     */
    Emoji WARNING_UNQUALIFIED = new Emoji("⚠", "\u26A0", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":warning:"), false, false, 0.6, Qualification.fromString("unqualified"), "warning", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, true);

    /**
     * 🚸
     */
    Emoji CHILDREN_CROSSING = new Emoji("🚸", "\uD83D\uDEB8", Collections.singletonList(":children_crossing:"), Collections.singletonList(":children_crossing:"), Collections.singletonList(":children_crossing:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "children crossing", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * ⛔
     */
    Emoji NO_ENTRY = new Emoji("⛔", "\u26D4", Collections.singletonList(":no_entry:"), Collections.singletonList(":no_entry:"), Collections.singletonList(":no_entry:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "no entry", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, true);

    /**
     * 🚫
     */
    Emoji PROHIBITED = new Emoji("🚫", "\uD83D\uDEAB", Collections.unmodifiableList(Arrays.asList(":no_entry_sign:", ":prohibited:")), Collections.singletonList(":no_entry_sign:"), Collections.singletonList(":no_entry_sign:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "prohibited", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 🚳
     */
    Emoji NO_BICYCLES = new Emoji("🚳", "\uD83D\uDEB3", Collections.singletonList(":no_bicycles:"), Collections.singletonList(":no_bicycles:"), Collections.singletonList(":no_bicycles:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "no bicycles", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 🚭
     */
    Emoji NO_SMOKING = new Emoji("🚭", "\uD83D\uDEAD", Collections.singletonList(":no_smoking:"), Collections.singletonList(":no_smoking:"), Collections.singletonList(":no_smoking:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "no smoking", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, true);

    /**
     * 🚯
     */
    Emoji NO_LITTERING = new Emoji("🚯", "\uD83D\uDEAF", Collections.unmodifiableList(Arrays.asList(":do_not_litter:", ":no_littering:")), Collections.singletonList(":do_not_litter:"), Collections.singletonList(":do_not_litter:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "no littering", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 🚱
     */
    Emoji NON_POTABLE_WATER = new Emoji("🚱", "\uD83D\uDEB1", Collections.singletonList(":non_potable_water:"), Collections.singletonList(":non-potable_water:"), Collections.singletonList(":non-potable_water:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "non-potable water", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 🚷
     */
    Emoji NO_PEDESTRIANS = new Emoji("🚷", "\uD83D\uDEB7", Collections.singletonList(":no_pedestrians:"), Collections.singletonList(":no_pedestrians:"), Collections.singletonList(":no_pedestrians:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "no pedestrians", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 📵
     */
    Emoji NO_MOBILE_PHONES = new Emoji("📵", "\uD83D\uDCF5", Collections.singletonList(":no_mobile_phones:"), Collections.singletonList(":no_mobile_phones:"), Collections.singletonList(":no_mobile_phones:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "no mobile phones", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * 🔞
     */
    Emoji NO_ONE_UNDER_EIGHTEEN = new Emoji("🔞", "\uD83D\uDD1E", Collections.singletonList(":underage:"), Collections.singletonList(":underage:"), Collections.singletonList(":underage:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "no one under eighteen", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * ☢️
     */
    Emoji RADIOACTIVE = new Emoji("☢️", "\u2622\uFE0F", Collections.unmodifiableList(Arrays.asList(":radioactive:", ":radioactive_sign:")), Collections.singletonList(":radioactive_sign:"), Collections.singletonList(":radioactive:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "radioactive", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * ☢
     */
    Emoji RADIOACTIVE_UNQUALIFIED = new Emoji("☢", "\u2622", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":radioactive:"), false, false, 1.0, Qualification.fromString("unqualified"), "radioactive", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, true);

    /**
     * ☣️
     */
    Emoji BIOHAZARD = new Emoji("☣️", "\u2623\uFE0F", Collections.unmodifiableList(Arrays.asList(":biohazard:", ":biohazard_sign:")), Collections.singletonList(":biohazard_sign:"), Collections.singletonList(":biohazard:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "biohazard", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, false);

    /**
     * ☣
     */
    Emoji BIOHAZARD_UNQUALIFIED = new Emoji("☣", "\u2623", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":biohazard:"), false, false, 1.0, Qualification.fromString("unqualified"), "biohazard", EmojiGroup.SYMBOLS, EmojiSubGroup.WARNING, true);
}
