package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTransportSign {

    /**
     * 🏧
     */
    Emoji ATM_SIGN = new Emoji("🏧", "\uD83C\uDFE7", Collections.singletonList(":atm:"), Collections.singletonList(":atm:"), Collections.singletonList(":atm:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ATM sign", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🚮
     */
    Emoji LITTER_IN_BIN_SIGN = new Emoji("🚮", "\uD83D\uDEAE", Collections.singletonList(":put_litter_in_its_place:"), Collections.singletonList(":put_litter_in_its_place:"), Collections.singletonList(":put_litter_in_its_place:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "litter in bin sign", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🚰
     */
    Emoji POTABLE_WATER = new Emoji("🚰", "\uD83D\uDEB0", Collections.singletonList(":potable_water:"), Collections.singletonList(":potable_water:"), Collections.singletonList(":potable_water:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "potable water", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * ♿
     */
    Emoji WHEELCHAIR_SYMBOL = new Emoji("♿", "\u267F", Collections.singletonList(":wheelchair:"), Collections.singletonList(":wheelchair:"), Collections.singletonList(":wheelchair:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wheelchair symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, true);

    /**
     * 🚹
     */
    Emoji MEN_S_ROOM = new Emoji("🚹", "\uD83D\uDEB9", Collections.unmodifiableList(Arrays.asList(":mens:", ":mens_room:")), Collections.singletonList(":mens:"), Collections.singletonList(":mens:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "men’s room", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, true);

    /**
     * 🚺
     */
    Emoji WOMEN_S_ROOM = new Emoji("🚺", "\uD83D\uDEBA", Collections.unmodifiableList(Arrays.asList(":womens:", ":womens_room:")), Collections.singletonList(":womens:"), Collections.singletonList(":womens:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "women’s room", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, true);

    /**
     * 🚻
     */
    Emoji RESTROOM = new Emoji("🚻", "\uD83D\uDEBB", Collections.singletonList(":restroom:"), Collections.singletonList(":restroom:"), Collections.singletonList(":restroom:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "restroom", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🚼
     */
    Emoji BABY_SYMBOL = new Emoji("🚼", "\uD83D\uDEBC", Collections.singletonList(":baby_symbol:"), Collections.singletonList(":baby_symbol:"), Collections.singletonList(":baby_symbol:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "baby symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, true);

    /**
     * 🚾
     */
    Emoji WATER_CLOSET = new Emoji("🚾", "\uD83D\uDEBE", Collections.unmodifiableList(Arrays.asList(":wc:", ":water_closet:")), Collections.singletonList(":wc:"), Collections.singletonList(":wc:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "water closet", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🛂
     */
    Emoji PASSPORT_CONTROL = new Emoji("🛂", "\uD83D\uDEC2", Collections.singletonList(":passport_control:"), Collections.singletonList(":passport_control:"), Collections.singletonList(":passport_control:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "passport control", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🛃
     */
    Emoji CUSTOMS = new Emoji("🛃", "\uD83D\uDEC3", Collections.singletonList(":customs:"), Collections.singletonList(":customs:"), Collections.singletonList(":customs:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "customs", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🛄
     */
    Emoji BAGGAGE_CLAIM = new Emoji("🛄", "\uD83D\uDEC4", Collections.singletonList(":baggage_claim:"), Collections.singletonList(":baggage_claim:"), Collections.singletonList(":baggage_claim:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "baggage claim", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);

    /**
     * 🛅
     */
    Emoji LEFT_LUGGAGE = new Emoji("🛅", "\uD83D\uDEC5", Collections.singletonList(":left_luggage:"), Collections.singletonList(":left_luggage:"), Collections.singletonList(":left_luggage:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "left luggage", EmojiGroup.SYMBOLS, EmojiSubGroup.TRANSPORT_SIGN, false);
}
