package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiTransportAir {

    /**
     * ✈️
     */
    Emoji AIRPLANE = new Emoji("✈️", "\u2708\uFE0F", Collections.singletonList(":airplane:"), Collections.singletonList(":airplane:"), Collections.singletonList(":airplane:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "airplane", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * ✈
     */
    Emoji AIRPLANE_UNQUALIFIED = new Emoji("✈", "\u2708", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":airplane:"), false, false, 0.6, Qualification.fromString("unqualified"), "airplane", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, true);

    /**
     * 🛩️
     */
    Emoji SMALL_AIRPLANE = new Emoji("🛩️", "\uD83D\uDEE9\uFE0F", Collections.unmodifiableList(Arrays.asList(":airplane_small:", ":small_airplane:")), Collections.singletonList(":small_airplane:"), Collections.singletonList(":small_airplane:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "small airplane", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🛩
     */
    Emoji SMALL_AIRPLANE_UNQUALIFIED = new Emoji("🛩", "\uD83D\uDEE9", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":small_airplane:"), false, false, 0.7, Qualification.fromString("unqualified"), "small airplane", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, true);

    /**
     * 🛫
     */
    Emoji AIRPLANE_DEPARTURE = new Emoji("🛫", "\uD83D\uDEEB", Collections.singletonList(":airplane_departure:"), Collections.singletonList(":airplane_departure:"), Collections.singletonList(":flight_departure:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "airplane departure", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🛬
     */
    Emoji AIRPLANE_ARRIVAL = new Emoji("🛬", "\uD83D\uDEEC", Collections.singletonList(":airplane_arriving:"), Collections.singletonList(":airplane_arriving:"), Collections.singletonList(":flight_arrival:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "airplane arrival", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🪂
     */
    Emoji PARACHUTE = new Emoji("🪂", "\uD83E\uDE82", Collections.singletonList(":parachute:"), Collections.singletonList(":parachute:"), Collections.singletonList(":parachute:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "parachute", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 💺
     */
    Emoji SEAT = new Emoji("💺", "\uD83D\uDCBA", Collections.singletonList(":seat:"), Collections.singletonList(":seat:"), Collections.singletonList(":seat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "seat", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🚁
     */
    Emoji HELICOPTER = new Emoji("🚁", "\uD83D\uDE81", Collections.singletonList(":helicopter:"), Collections.singletonList(":helicopter:"), Collections.singletonList(":helicopter:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "helicopter", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🚟
     */
    Emoji SUSPENSION_RAILWAY = new Emoji("🚟", "\uD83D\uDE9F", Collections.singletonList(":suspension_railway:"), Collections.singletonList(":suspension_railway:"), Collections.singletonList(":suspension_railway:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "suspension railway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🚠
     */
    Emoji MOUNTAIN_CABLEWAY = new Emoji("🚠", "\uD83D\uDEA0", Collections.singletonList(":mountain_cableway:"), Collections.singletonList(":mountain_cableway:"), Collections.singletonList(":mountain_cableway:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "mountain cableway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🚡
     */
    Emoji AERIAL_TRAMWAY = new Emoji("🚡", "\uD83D\uDEA1", Collections.singletonList(":aerial_tramway:"), Collections.singletonList(":aerial_tramway:"), Collections.singletonList(":aerial_tramway:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "aerial tramway", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🛰️
     */
    Emoji SATELLITE = new Emoji("🛰️", "\uD83D\uDEF0\uFE0F", Collections.singletonList(":satellite_orbital:"), Collections.singletonList(":satellite:"), Collections.singletonList(":artificial_satellite:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "satellite", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🛰
     */
    Emoji SATELLITE_UNQUALIFIED = new Emoji("🛰", "\uD83D\uDEF0", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":artificial_satellite:"), false, false, 0.7, Qualification.fromString("unqualified"), "satellite", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, true);

    /**
     * 🚀
     */
    Emoji ROCKET = new Emoji("🚀", "\uD83D\uDE80", Collections.singletonList(":rocket:"), Collections.singletonList(":rocket:"), Collections.singletonList(":rocket:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "rocket", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);

    /**
     * 🛸
     */
    Emoji FLYING_SAUCER = new Emoji("🛸", "\uD83D\uDEF8", Collections.singletonList(":flying_saucer:"), Collections.singletonList(":flying_saucer:"), Collections.singletonList(":flying_saucer:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "flying saucer", EmojiGroup.TRAVEL_AND_PLACES, EmojiSubGroup.TRANSPORT_AIR, false);
}
