package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiSport {

    /**
     * ⚽
     */
    Emoji SOCCER_BALL = new Emoji("⚽", "\u26BD", Collections.unmodifiableList(Arrays.asList(":soccer:", ":soccer_ball:")), Collections.singletonList(":soccer:"), Collections.singletonList(":soccer:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "soccer ball", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, true);

    /**
     * ⚾
     */
    Emoji BASEBALL = new Emoji("⚾", "\u26BE", Collections.singletonList(":baseball:"), Collections.singletonList(":baseball:"), Collections.singletonList(":baseball:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "baseball", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, true);

    /**
     * 🥎
     */
    Emoji SOFTBALL = new Emoji("🥎", "\uD83E\uDD4E", Collections.singletonList(":softball:"), Collections.singletonList(":softball:"), Collections.singletonList(":softball:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "softball", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏀
     */
    Emoji BASKETBALL = new Emoji("🏀", "\uD83C\uDFC0", Collections.singletonList(":basketball:"), Collections.singletonList(":basketball:"), Collections.singletonList(":basketball:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "basketball", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏐
     */
    Emoji VOLLEYBALL = new Emoji("🏐", "\uD83C\uDFD0", Collections.singletonList(":volleyball:"), Collections.singletonList(":volleyball:"), Collections.singletonList(":volleyball:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "volleyball", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏈
     */
    Emoji AMERICAN_FOOTBALL = new Emoji("🏈", "\uD83C\uDFC8", Collections.singletonList(":football:"), Collections.singletonList(":football:"), Collections.singletonList(":football:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "american football", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏉
     */
    Emoji RUGBY_FOOTBALL = new Emoji("🏉", "\uD83C\uDFC9", Collections.singletonList(":rugby_football:"), Collections.singletonList(":rugby_football:"), Collections.singletonList(":rugby_football:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "rugby football", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🎾
     */
    Emoji TENNIS = new Emoji("🎾", "\uD83C\uDFBE", Collections.singletonList(":tennis:"), Collections.singletonList(":tennis:"), Collections.singletonList(":tennis:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tennis", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥏
     */
    Emoji FLYING_DISC = new Emoji("🥏", "\uD83E\uDD4F", Collections.singletonList(":flying_disc:"), Collections.singletonList(":flying_disc:"), Collections.singletonList(":flying_disc:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "flying disc", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🎳
     */
    Emoji BOWLING = new Emoji("🎳", "\uD83C\uDFB3", Collections.singletonList(":bowling:"), Collections.singletonList(":bowling:"), Collections.singletonList(":bowling:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bowling", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏏
     */
    Emoji CRICKET_GAME = new Emoji("🏏", "\uD83C\uDFCF", Collections.unmodifiableList(Arrays.asList(":cricket_game:", ":cricket_bat_ball:")), Collections.singletonList(":cricket_bat_and_ball:"), Collections.singletonList(":cricket_game:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "cricket game", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏑
     */
    Emoji FIELD_HOCKEY = new Emoji("🏑", "\uD83C\uDFD1", Collections.singletonList(":field_hockey:"), Collections.singletonList(":field_hockey_stick_and_ball:"), Collections.singletonList(":field_hockey:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "field hockey", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏒
     */
    Emoji ICE_HOCKEY = new Emoji("🏒", "\uD83C\uDFD2", Collections.unmodifiableList(Arrays.asList(":hockey:", ":ice_hockey:")), Collections.singletonList(":ice_hockey_stick_and_puck:"), Collections.singletonList(":ice_hockey:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "ice hockey", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥍
     */
    Emoji LACROSSE = new Emoji("🥍", "\uD83E\uDD4D", Collections.singletonList(":lacrosse:"), Collections.singletonList(":lacrosse:"), Collections.singletonList(":lacrosse:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "lacrosse", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏓
     */
    Emoji PING_PONG = new Emoji("🏓", "\uD83C\uDFD3", Collections.unmodifiableList(Arrays.asList(":ping_pong:", ":table_tennis:")), Collections.singletonList(":table_tennis_paddle_and_ball:"), Collections.singletonList(":ping_pong:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "ping pong", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🏸
     */
    Emoji BADMINTON = new Emoji("🏸", "\uD83C\uDFF8", Collections.singletonList(":badminton:"), Collections.singletonList(":badminton_racquet_and_shuttlecock:"), Collections.singletonList(":badminton:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "badminton", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥊
     */
    Emoji BOXING_GLOVE = new Emoji("🥊", "\uD83E\uDD4A", Collections.unmodifiableList(Arrays.asList(":boxing_glove:", ":boxing_gloves:")), Collections.singletonList(":boxing_glove:"), Collections.singletonList(":boxing_glove:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "boxing glove", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥋
     */
    Emoji MARTIAL_ARTS_UNIFORM = new Emoji("🥋", "\uD83E\uDD4B", Collections.unmodifiableList(Arrays.asList(":martial_arts_uniform:", ":karate_uniform:")), Collections.singletonList(":martial_arts_uniform:"), Collections.singletonList(":martial_arts_uniform:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "martial arts uniform", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥅
     */
    Emoji GOAL_NET = new Emoji("🥅", "\uD83E\uDD45", Collections.unmodifiableList(Arrays.asList(":goal:", ":goal_net:")), Collections.singletonList(":goal_net:"), Collections.singletonList(":goal_net:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "goal net", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * ⛳
     */
    Emoji FLAG_IN_HOLE = new Emoji("⛳", "\u26F3", Collections.unmodifiableList(Arrays.asList(":golf:", ":flag_in_hole:")), Collections.singletonList(":golf:"), Collections.singletonList(":golf:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flag in hole", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, true);

    /**
     * ⛸️
     */
    Emoji ICE_SKATE = new Emoji("⛸️", "\u26F8\uFE0F", Collections.singletonList(":ice_skate:"), Collections.singletonList(":ice_skate:"), Collections.singletonList(":ice_skate:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "ice skate", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * ⛸
     */
    Emoji ICE_SKATE_UNQUALIFIED = new Emoji("⛸", "\u26F8", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":ice_skate:"), false, false, 0.7, Qualification.fromString("unqualified"), "ice skate", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, true);

    /**
     * 🎣
     */
    Emoji FISHING_POLE = new Emoji("🎣", "\uD83C\uDFA3", Collections.unmodifiableList(Arrays.asList(":fishing_pole_and_fish:", ":fishing_pole:")), Collections.singletonList(":fishing_pole_and_fish:"), Collections.singletonList(":fishing_pole_and_fish:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fishing pole", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🤿
     */
    Emoji DIVING_MASK = new Emoji("🤿", "\uD83E\uDD3F", Collections.singletonList(":diving_mask:"), Collections.singletonList(":diving_mask:"), Collections.singletonList(":diving_mask:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "diving mask", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🎽
     */
    Emoji RUNNING_SHIRT = new Emoji("🎽", "\uD83C\uDFBD", Collections.unmodifiableList(Arrays.asList(":running_shirt_with_sash:", ":running_shirt:")), Collections.singletonList(":running_shirt_with_sash:"), Collections.singletonList(":running_shirt_with_sash:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "running shirt", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🎿
     */
    Emoji SKIS = new Emoji("🎿", "\uD83C\uDFBF", Collections.unmodifiableList(Arrays.asList(":ski:", ":skis:")), Collections.singletonList(":ski:"), Collections.singletonList(":ski:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "skis", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🛷
     */
    Emoji SLED = new Emoji("🛷", "\uD83D\uDEF7", Collections.singletonList(":sled:"), Collections.singletonList(":sled:"), Collections.singletonList(":sled:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "sled", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);

    /**
     * 🥌
     */
    Emoji CURLING_STONE = new Emoji("🥌", "\uD83E\uDD4C", Collections.singletonList(":curling_stone:"), Collections.singletonList(":curling_stone:"), Collections.singletonList(":curling_stone:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "curling stone", EmojiGroup.ACTIVITIES, EmojiSubGroup.SPORT, false);
}
