package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPunctuation {

    /**
     * ‼️
     */
    Emoji DOUBLE_EXCLAMATION_MARK = new Emoji("‼️", "\u203C\uFE0F", Collections.singletonList(":bangbang:"), Collections.singletonList(":bangbang:"), Collections.singletonList(":bangbang:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "double exclamation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, false);

    /**
     * ‼
     */
    Emoji DOUBLE_EXCLAMATION_MARK_UNQUALIFIED = new Emoji("‼", "\u203C", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":bangbang:"), false, false, 0.6, Qualification.fromString("unqualified"), "double exclamation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * ⁉️
     */
    Emoji EXCLAMATION_QUESTION_MARK = new Emoji("⁉️", "\u2049\uFE0F", Collections.singletonList(":interrobang:"), Collections.singletonList(":interrobang:"), Collections.singletonList(":interrobang:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "exclamation question mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, false);

    /**
     * ⁉
     */
    Emoji EXCLAMATION_QUESTION_MARK_UNQUALIFIED = new Emoji("⁉", "\u2049", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":interrobang:"), false, false, 0.6, Qualification.fromString("unqualified"), "exclamation question mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * ❓
     */
    Emoji RED_QUESTION_MARK = new Emoji("❓", "\u2753", Collections.unmodifiableList(Arrays.asList(":question:", ":question_mark:")), Collections.singletonList(":question:"), Collections.singletonList(":question:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "red question mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * ❔
     */
    Emoji WHITE_QUESTION_MARK = new Emoji("❔", "\u2754", Collections.singletonList(":grey_question:"), Collections.singletonList(":grey_question:"), Collections.singletonList(":grey_question:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white question mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * ❕
     */
    Emoji WHITE_EXCLAMATION_MARK = new Emoji("❕", "\u2755", Collections.singletonList(":grey_exclamation:"), Collections.singletonList(":grey_exclamation:"), Collections.singletonList(":grey_exclamation:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white exclamation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * ❗
     */
    Emoji RED_EXCLAMATION_MARK = new Emoji("❗", "\u2757", Collections.singletonList(":exclamation:"), Collections.singletonList(":exclamation:"), Collections.unmodifiableList(Arrays.asList(":exclamation:", ":heavy_exclamation_mark:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "red exclamation mark", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);

    /**
     * 〰️
     */
    Emoji WAVY_DASH = new Emoji("〰️", "\u3030\uFE0F", Collections.singletonList(":wavy_dash:"), Collections.singletonList(":wavy_dash:"), Collections.singletonList(":wavy_dash:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "wavy dash", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, false);

    /**
     * 〰
     */
    Emoji WAVY_DASH_UNQUALIFIED = new Emoji("〰", "\u3030", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":wavy_dash:"), false, false, 0.6, Qualification.fromString("unqualified"), "wavy dash", EmojiGroup.SYMBOLS, EmojiSubGroup.PUNCTUATION, true);
}
