package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPlantFlower {

    /**
     * 💐
     */
    Emoji BOUQUET = new Emoji("💐", "\uD83D\uDC90", Collections.singletonList(":bouquet:"), Collections.singletonList(":bouquet:"), Collections.singletonList(":bouquet:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bouquet", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🌸
     */
    Emoji CHERRY_BLOSSOM = new Emoji("🌸", "\uD83C\uDF38", Collections.singletonList(":cherry_blossom:"), Collections.singletonList(":cherry_blossom:"), Collections.singletonList(":cherry_blossom:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "cherry blossom", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 💮
     */
    Emoji WHITE_FLOWER = new Emoji("💮", "\uD83D\uDCAE", Collections.singletonList(":white_flower:"), Collections.singletonList(":white_flower:"), Collections.singletonList(":white_flower:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white flower", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🪷
     */
    Emoji LOTUS = new Emoji("🪷", "\uD83E\uDEB7", Collections.singletonList(":lotus:"), Collections.emptyList(), Collections.singletonList(":lotus:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "lotus", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🏵️
     */
    Emoji ROSETTE = new Emoji("🏵️", "\uD83C\uDFF5\uFE0F", Collections.singletonList(":rosette:"), Collections.singletonList(":rosette:"), Collections.singletonList(":rosette:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "rosette", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🏵
     */
    Emoji ROSETTE_UNQUALIFIED = new Emoji("🏵", "\uD83C\uDFF5", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":rosette:"), false, false, 0.7, Qualification.fromString("unqualified"), "rosette", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, true);

    /**
     * 🌹
     */
    Emoji ROSE = new Emoji("🌹", "\uD83C\uDF39", Collections.singletonList(":rose:"), Collections.singletonList(":rose:"), Collections.singletonList(":rose:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "rose", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🥀
     */
    Emoji WILTED_FLOWER = new Emoji("🥀", "\uD83E\uDD40", Collections.unmodifiableList(Arrays.asList(":wilted_rose:", ":wilted_flower:")), Collections.singletonList(":wilted_flower:"), Collections.singletonList(":wilted_flower:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "wilted flower", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🌺
     */
    Emoji HIBISCUS = new Emoji("🌺", "\uD83C\uDF3A", Collections.singletonList(":hibiscus:"), Collections.singletonList(":hibiscus:"), Collections.singletonList(":hibiscus:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hibiscus", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🌻
     */
    Emoji SUNFLOWER = new Emoji("🌻", "\uD83C\uDF3B", Collections.singletonList(":sunflower:"), Collections.singletonList(":sunflower:"), Collections.singletonList(":sunflower:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sunflower", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🌼
     */
    Emoji BLOSSOM = new Emoji("🌼", "\uD83C\uDF3C", Collections.singletonList(":blossom:"), Collections.singletonList(":blossom:"), Collections.singletonList(":blossom:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "blossom", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🌷
     */
    Emoji TULIP = new Emoji("🌷", "\uD83C\uDF37", Collections.singletonList(":tulip:"), Collections.singletonList(":tulip:"), Collections.singletonList(":tulip:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tulip", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);

    /**
     * 🪻
     */
    Emoji HYACINTH = new Emoji("🪻", "\uD83E\uDEBB", Collections.singletonList(":hyacinth:"), Collections.emptyList(), Collections.singletonList(":hyacinth:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "hyacinth", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.PLANT_FLOWER, false);
}
