package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPhone {

    /**
     * 📱
     */
    Emoji MOBILE_PHONE = new Emoji("📱", "\uD83D\uDCF1", Collections.unmodifiableList(Arrays.asList(":mobile_phone:", ":iphone:")), Collections.singletonList(":iphone:"), Collections.singletonList(":iphone:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "mobile phone", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, false);

    /**
     * 📲
     */
    Emoji MOBILE_PHONE_WITH_ARROW = new Emoji("📲", "\uD83D\uDCF2", Collections.singletonList(":calling:"), Collections.singletonList(":calling:"), Collections.singletonList(":calling:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "mobile phone with arrow", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, false);

    /**
     * ☎️
     */
    Emoji TELEPHONE = new Emoji("☎️", "\u260E\uFE0F", Collections.singletonList(":telephone:"), Collections.singletonList(":phone:"), Collections.singletonList(":phone:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "telephone", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, false);

    /**
     * ☎
     */
    Emoji TELEPHONE_UNQUALIFIED = new Emoji("☎", "\u260E", Collections.emptyList(), Collections.emptyList(), Collections.unmodifiableList(Arrays.asList(":phone:", ":telephone:")), false, false, 0.6, Qualification.fromString("unqualified"), "telephone", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, true);

    /**
     * 📞
     */
    Emoji TELEPHONE_RECEIVER = new Emoji("📞", "\uD83D\uDCDE", Collections.singletonList(":telephone_receiver:"), Collections.singletonList(":telephone_receiver:"), Collections.singletonList(":telephone_receiver:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "telephone receiver", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, false);

    /**
     * 📟
     */
    Emoji PAGER = new Emoji("📟", "\uD83D\uDCDF", Collections.singletonList(":pager:"), Collections.singletonList(":pager:"), Collections.singletonList(":pager:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "pager", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, true);

    /**
     * 📠
     */
    Emoji FAX_MACHINE = new Emoji("📠", "\uD83D\uDCE0", Collections.unmodifiableList(Arrays.asList(":fax:", ":fax_machine:")), Collections.singletonList(":fax:"), Collections.singletonList(":fax:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fax machine", EmojiGroup.OBJECTS, EmojiSubGroup.PHONE, false);
}
