package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPersonSymbol {

    /**
     * 🗣️
     */
    Emoji SPEAKING_HEAD = new Emoji("🗣️", "\uD83D\uDDE3\uFE0F", Collections.unmodifiableList(Arrays.asList(":speaking_head:", ":speaking_head_in_silhouette:")), Collections.singletonList(":speaking_head_in_silhouette:"), Collections.singletonList(":speaking_head:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "speaking head", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 🗣
     */
    Emoji SPEAKING_HEAD_UNQUALIFIED = new Emoji("🗣", "\uD83D\uDDE3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":speaking_head:"), false, false, 0.7, Qualification.fromString("unqualified"), "speaking head", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, true);

    /**
     * 👤
     */
    Emoji BUST_IN_SILHOUETTE = new Emoji("👤", "\uD83D\uDC64", Collections.singletonList(":bust_in_silhouette:"), Collections.singletonList(":bust_in_silhouette:"), Collections.singletonList(":bust_in_silhouette:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bust in silhouette", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 👥
     */
    Emoji BUSTS_IN_SILHOUETTE = new Emoji("👥", "\uD83D\uDC65", Collections.singletonList(":busts_in_silhouette:"), Collections.singletonList(":busts_in_silhouette:"), Collections.singletonList(":busts_in_silhouette:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "busts in silhouette", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 🫂
     */
    Emoji PEOPLE_HUGGING = new Emoji("🫂", "\uD83E\uDEC2", Collections.singletonList(":people_hugging:"), Collections.singletonList(":people_hugging:"), Collections.singletonList(":people_hugging:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "people hugging", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 👪
     */
    Emoji FAMILY = new Emoji("👪", "\uD83D\uDC6A", Collections.singletonList(":family:"), Collections.singletonList(":family:"), Collections.singletonList(":family:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "family", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, true);

    /**
     * 🧑‍🧑‍🧒
     */
    Emoji FAMILY_ADULT_ADULT_CHILD = new Emoji("🧑‍🧑‍🧒", "\uD83E\uDDD1\u200D\uD83E\uDDD1\u200D\uD83E\uDDD2", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "family: adult, adult, child", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 🧑‍🧑‍🧒‍🧒
     */
    Emoji FAMILY_ADULT_ADULT_CHILD_CHILD = new Emoji("🧑‍🧑‍🧒‍🧒", "\uD83E\uDDD1\u200D\uD83E\uDDD1\u200D\uD83E\uDDD2\u200D\uD83E\uDDD2", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "family: adult, adult, child, child", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 🧑‍🧒
     */
    Emoji FAMILY_ADULT_CHILD = new Emoji("🧑‍🧒", "\uD83E\uDDD1\u200D\uD83E\uDDD2", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "family: adult, child", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 🧑‍🧒‍🧒
     */
    Emoji FAMILY_ADULT_CHILD_CHILD = new Emoji("🧑‍🧒‍🧒", "\uD83E\uDDD1\u200D\uD83E\uDDD2\u200D\uD83E\uDDD2", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "family: adult, child, child", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);

    /**
     * 👣
     */
    Emoji FOOTPRINTS = new Emoji("👣", "\uD83D\uDC63", Collections.singletonList(":footprints:"), Collections.singletonList(":footprints:"), Collections.singletonList(":footprints:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "footprints", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON_SYMBOL, false);
}
