package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiPerson {

    /**
     * 👶
     */
    Emoji BABY = new Emoji("👶", "\uD83D\uDC76", Collections.singletonList(":baby:"), Collections.singletonList(":baby:"), Collections.singletonList(":baby:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "baby", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👶🏻
     */
    Emoji BABY_LIGHT_SKIN_TONE = new Emoji("👶🏻", "\uD83D\uDC76\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":baby_tone1:", ":baby::skin-tone-1:")), Collections.singletonList(":baby::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👶🏼
     */
    Emoji BABY_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👶🏼", "\uD83D\uDC76\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":baby_tone2:", ":baby::skin-tone-2:")), Collections.singletonList(":baby::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👶🏽
     */
    Emoji BABY_MEDIUM_SKIN_TONE = new Emoji("👶🏽", "\uD83D\uDC76\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":baby_tone3:", ":baby::skin-tone-3:")), Collections.singletonList(":baby::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👶🏾
     */
    Emoji BABY_MEDIUM_DARK_SKIN_TONE = new Emoji("👶🏾", "\uD83D\uDC76\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":baby_tone4:", ":baby::skin-tone-4:")), Collections.singletonList(":baby::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👶🏿
     */
    Emoji BABY_DARK_SKIN_TONE = new Emoji("👶🏿", "\uD83D\uDC76\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":baby_tone5:", ":baby::skin-tone-5:")), Collections.singletonList(":baby::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "baby: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒
     */
    Emoji CHILD = new Emoji("🧒", "\uD83E\uDDD2", Collections.singletonList(":child:"), Collections.singletonList(":child:"), Collections.singletonList(":child:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "child", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒🏻
     */
    Emoji CHILD_LIGHT_SKIN_TONE = new Emoji("🧒🏻", "\uD83E\uDDD2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":child_tone1:", ":child_light_skin_tone:", ":child::skin-tone-1:")), Collections.singletonList(":child::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "child: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒🏼
     */
    Emoji CHILD_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧒🏼", "\uD83E\uDDD2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":child_tone2:", ":child_medium_light_skin_tone:", ":child::skin-tone-2:")), Collections.singletonList(":child::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "child: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒🏽
     */
    Emoji CHILD_MEDIUM_SKIN_TONE = new Emoji("🧒🏽", "\uD83E\uDDD2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":child_tone3:", ":child_medium_skin_tone:", ":child::skin-tone-3:")), Collections.singletonList(":child::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "child: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒🏾
     */
    Emoji CHILD_MEDIUM_DARK_SKIN_TONE = new Emoji("🧒🏾", "\uD83E\uDDD2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":child_tone4:", ":child_medium_dark_skin_tone:", ":child::skin-tone-4:")), Collections.singletonList(":child::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "child: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧒🏿
     */
    Emoji CHILD_DARK_SKIN_TONE = new Emoji("🧒🏿", "\uD83E\uDDD2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":child_tone5:", ":child_dark_skin_tone:", ":child::skin-tone-5:")), Collections.singletonList(":child::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "child: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦
     */
    Emoji BOY = new Emoji("👦", "\uD83D\uDC66", Collections.singletonList(":boy:"), Collections.singletonList(":boy:"), Collections.singletonList(":boy:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "boy", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦🏻
     */
    Emoji BOY_LIGHT_SKIN_TONE = new Emoji("👦🏻", "\uD83D\uDC66\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":boy_tone1:", ":boy::skin-tone-1:")), Collections.singletonList(":boy::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "boy: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦🏼
     */
    Emoji BOY_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👦🏼", "\uD83D\uDC66\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":boy_tone2:", ":boy::skin-tone-2:")), Collections.singletonList(":boy::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "boy: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦🏽
     */
    Emoji BOY_MEDIUM_SKIN_TONE = new Emoji("👦🏽", "\uD83D\uDC66\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":boy_tone3:", ":boy::skin-tone-3:")), Collections.singletonList(":boy::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "boy: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦🏾
     */
    Emoji BOY_MEDIUM_DARK_SKIN_TONE = new Emoji("👦🏾", "\uD83D\uDC66\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":boy_tone4:", ":boy::skin-tone-4:")), Collections.singletonList(":boy::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "boy: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👦🏿
     */
    Emoji BOY_DARK_SKIN_TONE = new Emoji("👦🏿", "\uD83D\uDC66\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":boy_tone5:", ":boy::skin-tone-5:")), Collections.singletonList(":boy::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "boy: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧
     */
    Emoji GIRL = new Emoji("👧", "\uD83D\uDC67", Collections.singletonList(":girl:"), Collections.singletonList(":girl:"), Collections.singletonList(":girl:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "girl", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧🏻
     */
    Emoji GIRL_LIGHT_SKIN_TONE = new Emoji("👧🏻", "\uD83D\uDC67\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":girl_tone1:", ":girl::skin-tone-1:")), Collections.singletonList(":girl::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "girl: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧🏼
     */
    Emoji GIRL_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👧🏼", "\uD83D\uDC67\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":girl_tone2:", ":girl::skin-tone-2:")), Collections.singletonList(":girl::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "girl: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧🏽
     */
    Emoji GIRL_MEDIUM_SKIN_TONE = new Emoji("👧🏽", "\uD83D\uDC67\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":girl_tone3:", ":girl::skin-tone-3:")), Collections.singletonList(":girl::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "girl: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧🏾
     */
    Emoji GIRL_MEDIUM_DARK_SKIN_TONE = new Emoji("👧🏾", "\uD83D\uDC67\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":girl_tone4:", ":girl::skin-tone-4:")), Collections.singletonList(":girl::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "girl: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👧🏿
     */
    Emoji GIRL_DARK_SKIN_TONE = new Emoji("👧🏿", "\uD83D\uDC67\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":girl_tone5:", ":girl::skin-tone-5:")), Collections.singletonList(":girl::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "girl: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑
     */
    Emoji PERSON = new Emoji("🧑", "\uD83E\uDDD1", Collections.unmodifiableList(Arrays.asList(":adult:", ":person:")), Collections.singletonList(":adult:"), Collections.singletonList(":adult:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "person", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏻
     */
    Emoji PERSON_LIGHT_SKIN_TONE = new Emoji("🧑🏻", "\uD83E\uDDD1\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":adult_tone1:", ":adult_light_skin_tone:", ":adult::skin-tone-1:", ":person::skin-tone-1:")), Collections.singletonList(":adult::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏼
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧑🏼", "\uD83E\uDDD1\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":adult_tone2:", ":adult_medium_light_skin_tone:", ":adult::skin-tone-2:", ":person::skin-tone-2:")), Collections.singletonList(":adult::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏽
     */
    Emoji PERSON_MEDIUM_SKIN_TONE = new Emoji("🧑🏽", "\uD83E\uDDD1\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":adult_tone3:", ":adult_medium_skin_tone:", ":adult::skin-tone-3:", ":person::skin-tone-3:")), Collections.singletonList(":adult::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏾
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE = new Emoji("🧑🏾", "\uD83E\uDDD1\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":adult_tone4:", ":adult_medium_dark_skin_tone:", ":adult::skin-tone-4:", ":person::skin-tone-4:")), Collections.singletonList(":adult::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏿
     */
    Emoji PERSON_DARK_SKIN_TONE = new Emoji("🧑🏿", "\uD83E\uDDD1\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":adult_tone5:", ":adult_dark_skin_tone:", ":adult::skin-tone-5:", ":person::skin-tone-5:")), Collections.singletonList(":adult::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱
     */
    Emoji PERSON_BLOND_HAIR = new Emoji("👱", "\uD83D\uDC71", Collections.unmodifiableList(Arrays.asList(":blond_haired_person:", ":person_with_blond_hair:")), Collections.singletonList(":person_with_blond_hair:"), Collections.singletonList(":blond_haired_person:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "person: blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏻
     */
    Emoji PERSON_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏻", "\uD83D\uDC71\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":blond_haired_person_tone1:", ":person_with_blond_hair_tone1:", ":blond_haired_person::skin-tone-1:", ":person_with_blond_hair::skin-tone-1:")), Collections.singletonList(":person_with_blond_hair::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "person: light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏼
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏼", "\uD83D\uDC71\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":blond_haired_person_tone2:", ":person_with_blond_hair_tone2:", ":blond_haired_person::skin-tone-2:", ":person_with_blond_hair::skin-tone-2:")), Collections.singletonList(":person_with_blond_hair::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏽
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏽", "\uD83D\uDC71\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":blond_haired_person_tone3:", ":person_with_blond_hair_tone3:", ":blond_haired_person::skin-tone-3:", ":person_with_blond_hair::skin-tone-3:")), Collections.singletonList(":person_with_blond_hair::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "person: medium skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏾
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏾", "\uD83D\uDC71\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":blond_haired_person_tone4:", ":person_with_blond_hair_tone4:", ":blond_haired_person::skin-tone-4:", ":person_with_blond_hair::skin-tone-4:")), Collections.singletonList(":person_with_blond_hair::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏿
     */
    Emoji PERSON_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏿", "\uD83D\uDC71\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":blond_haired_person_tone5:", ":person_with_blond_hair_tone5:", ":blond_haired_person::skin-tone-5:", ":person_with_blond_hair::skin-tone-5:")), Collections.singletonList(":person_with_blond_hair::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "person: dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨
     */
    Emoji MAN = new Emoji("👨", "\uD83D\uDC68", Collections.singletonList(":man:"), Collections.singletonList(":man:"), Collections.singletonList(":man:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "man", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏻
     */
    Emoji MAN_LIGHT_SKIN_TONE = new Emoji("👨🏻", "\uD83D\uDC68\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":man_tone1:", ":man::skin-tone-1:")), Collections.singletonList(":man::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "man: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏼
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👨🏼", "\uD83D\uDC68\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":man_tone2:", ":man::skin-tone-2:")), Collections.singletonList(":man::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏽
     */
    Emoji MAN_MEDIUM_SKIN_TONE = new Emoji("👨🏽", "\uD83D\uDC68\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":man_tone3:", ":man::skin-tone-3:")), Collections.singletonList(":man::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "man: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏾
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE = new Emoji("👨🏾", "\uD83D\uDC68\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":man_tone4:", ":man::skin-tone-4:")), Collections.singletonList(":man::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏿
     */
    Emoji MAN_DARK_SKIN_TONE = new Emoji("👨🏿", "\uD83D\uDC68\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":man_tone5:", ":man::skin-tone-5:")), Collections.singletonList(":man::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "man: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔
     */
    Emoji PERSON_BEARD = new Emoji("🧔", "\uD83E\uDDD4", Collections.unmodifiableList(Arrays.asList(":bearded_person:", ":person_beard:")), Collections.singletonList(":bearded_person:"), Collections.singletonList(":bearded_person:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "person: beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏻
     */
    Emoji PERSON_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏻", "\uD83E\uDDD4\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":bearded_person_tone1:", ":bearded_person_light_skin_tone:", ":bearded_person::skin-tone-1:", ":person_beard::skin-tone-1:")), Collections.singletonList(":bearded_person::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏼
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏼", "\uD83E\uDDD4\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":bearded_person_tone2:", ":bearded_person_medium_light_skin_tone:", ":bearded_person::skin-tone-2:", ":person_beard::skin-tone-2:")), Collections.singletonList(":bearded_person::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏽
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_BEARD = new Emoji("🧔🏽", "\uD83E\uDDD4\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":bearded_person_tone3:", ":bearded_person_medium_skin_tone:", ":bearded_person::skin-tone-3:", ":person_beard::skin-tone-3:")), Collections.singletonList(":bearded_person::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏾
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏾", "\uD83E\uDDD4\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":bearded_person_tone4:", ":bearded_person_medium_dark_skin_tone:", ":bearded_person::skin-tone-4:", ":person_beard::skin-tone-4:")), Collections.singletonList(":bearded_person::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏿
     */
    Emoji PERSON_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏿", "\uD83E\uDDD4\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":bearded_person_tone5:", ":bearded_person_dark_skin_tone:", ":bearded_person::skin-tone-5:", ":person_beard::skin-tone-5:")), Collections.singletonList(":bearded_person::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "person: dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔‍♂️
     */
    Emoji MAN_BEARD = new Emoji("🧔‍♂️", "\uD83E\uDDD4\u200D\u2642\uFE0F", Collections.singletonList(":man_beard:"), Collections.emptyList(), Collections.singletonList(":man_beard:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "man: beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔‍♂
     */
    Emoji MAN_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔‍♂", "\uD83E\uDDD4\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.1, Qualification.fromString("minimally-qualified"), "man: beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏻‍♂️
     */
    Emoji MAN_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏻‍♂️", "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_tone1_beard:", ":man_light_skin_tone_beard:", ":man_beard::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "man: light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏻‍♂
     */
    Emoji MAN_LIGHT_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏻‍♂", "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "man: light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏼‍♂️
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏼‍♂️", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_tone2_beard:", ":man_medium_light_skin_tone_beard:", ":man_beard::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏼‍♂
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏼‍♂", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "man: medium-light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏽‍♂️
     */
    Emoji MAN_MEDIUM_SKIN_TONE_BEARD = new Emoji("🧔🏽‍♂️", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_tone3_beard:", ":man_medium_skin_tone_beard:", ":man_beard::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "man: medium skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏽‍♂
     */
    Emoji MAN_MEDIUM_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏽‍♂", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "man: medium skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏾‍♂️
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏾‍♂️", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_tone4_beard:", ":man_medium_dark_skin_tone_beard:", ":man_beard::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏾‍♂
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏾‍♂", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "man: medium-dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏿‍♂️
     */
    Emoji MAN_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏿‍♂️", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":man_tone5_beard:", ":man_dark_skin_tone_beard:", ":man_beard::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "man: dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏿‍♂
     */
    Emoji MAN_DARK_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏿‍♂", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "man: dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔‍♀️
     */
    Emoji WOMAN_BEARD = new Emoji("🧔‍♀️", "\uD83E\uDDD4\u200D\u2640\uFE0F", Collections.singletonList(":woman_beard:"), Collections.emptyList(), Collections.singletonList(":woman_beard:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "woman: beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔‍♀
     */
    Emoji WOMAN_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔‍♀", "\uD83E\uDDD4\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏻‍♀️
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏻‍♀️", "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_tone1_beard:", ":woman_light_skin_tone_beard:", ":woman_beard::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "woman: light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏻‍♀
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏻‍♀", "\uD83E\uDDD4\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏼‍♀️
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD = new Emoji("🧔🏼‍♀️", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_tone2_beard:", ":woman_medium_light_skin_tone_beard:", ":woman_beard::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏼‍♀
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏼‍♀", "\uD83E\uDDD4\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: medium-light skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏽‍♀️
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_BEARD = new Emoji("🧔🏽‍♀️", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_tone3_beard:", ":woman_medium_skin_tone_beard:", ":woman_beard::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "woman: medium skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏽‍♀
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏽‍♀", "\uD83E\uDDD4\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: medium skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏾‍♀️
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏾‍♀️", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_tone4_beard:", ":woman_medium_dark_skin_tone_beard:", ":woman_beard::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏾‍♀
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏾‍♀", "\uD83E\uDDD4\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: medium-dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏿‍♀️
     */
    Emoji WOMAN_DARK_SKIN_TONE_BEARD = new Emoji("🧔🏿‍♀️", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":woman_tone5_beard:", ":woman_dark_skin_tone_beard:", ":woman_beard::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("fully-qualified"), "woman: dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧔🏿‍♀
     */
    Emoji WOMAN_DARK_SKIN_TONE_BEARD_MINIMALLY_QUALIFIED = new Emoji("🧔🏿‍♀", "\uD83E\uDDD4\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 13.1, Qualification.fromString("minimally-qualified"), "woman: dark skin tone, beard", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨‍🦰
     */
    Emoji MAN_RED_HAIR = new Emoji("👨‍🦰", "\uD83D\uDC68\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired:", ":man_red_hair:")), Collections.singletonList(":red_haired_man:"), Collections.singletonList(":red_haired_man:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "man: red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏻‍🦰
     */
    Emoji MAN_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("👨🏻‍🦰", "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired_tone1:", ":man_red_haired_light_skin_tone:", ":man_red_haired::skin-tone-1:", ":man_red_hair::skin-tone-1:")), Collections.singletonList(":red_haired_man::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏼‍🦰
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("👨🏼‍🦰", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired_tone2:", ":man_red_haired_medium_light_skin_tone:", ":man_red_haired::skin-tone-2:", ":man_red_hair::skin-tone-2:")), Collections.singletonList(":red_haired_man::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏽‍🦰
     */
    Emoji MAN_MEDIUM_SKIN_TONE_RED_HAIR = new Emoji("👨🏽‍🦰", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired_tone3:", ":man_red_haired_medium_skin_tone:", ":man_red_haired::skin-tone-3:", ":man_red_hair::skin-tone-3:")), Collections.singletonList(":red_haired_man::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏾‍🦰
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR = new Emoji("👨🏾‍🦰", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired_tone4:", ":man_red_haired_medium_dark_skin_tone:", ":man_red_haired::skin-tone-4:", ":man_red_hair::skin-tone-4:")), Collections.singletonList(":red_haired_man::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏿‍🦰
     */
    Emoji MAN_DARK_SKIN_TONE_RED_HAIR = new Emoji("👨🏿‍🦰", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":man_red_haired_tone5:", ":man_red_haired_dark_skin_tone:", ":man_red_haired::skin-tone-5:", ":man_red_hair::skin-tone-5:")), Collections.singletonList(":red_haired_man::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨‍🦱
     */
    Emoji MAN_CURLY_HAIR = new Emoji("👨‍🦱", "\uD83D\uDC68\u200D\uD83E\uDDB1", Collections.singletonList(":man_curly_haired:"), Collections.singletonList(":curly_haired_man:"), Collections.singletonList(":curly_haired_man:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "man: curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏻‍🦱
     */
    Emoji MAN_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("👨🏻‍🦱", "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":man_curly_haired_tone1:", ":man_curly_haired_light_skin_tone:", ":man_curly_haired::skin-tone-1:")), Collections.singletonList(":curly_haired_man::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏼‍🦱
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("👨🏼‍🦱", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":man_curly_haired_tone2:", ":man_curly_haired_medium_light_skin_tone:", ":man_curly_haired::skin-tone-2:")), Collections.singletonList(":curly_haired_man::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏽‍🦱
     */
    Emoji MAN_MEDIUM_SKIN_TONE_CURLY_HAIR = new Emoji("👨🏽‍🦱", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":man_curly_haired_tone3:", ":man_curly_haired_medium_skin_tone:", ":man_curly_haired::skin-tone-3:")), Collections.singletonList(":curly_haired_man::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏾‍🦱
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("👨🏾‍🦱", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":man_curly_haired_tone4:", ":man_curly_haired_medium_dark_skin_tone:", ":man_curly_haired::skin-tone-4:")), Collections.singletonList(":curly_haired_man::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏿‍🦱
     */
    Emoji MAN_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("👨🏿‍🦱", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":man_curly_haired_tone5:", ":man_curly_haired_dark_skin_tone:", ":man_curly_haired::skin-tone-5:")), Collections.singletonList(":curly_haired_man::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨‍🦳
     */
    Emoji MAN_WHITE_HAIR = new Emoji("👨‍🦳", "\uD83D\uDC68\u200D\uD83E\uDDB3", Collections.singletonList(":man_white_haired:"), Collections.singletonList(":white_haired_man:"), Collections.singletonList(":white_haired_man:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "man: white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏻‍🦳
     */
    Emoji MAN_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("👨🏻‍🦳", "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":man_white_haired_tone1:", ":man_white_haired_light_skin_tone:", ":man_white_haired::skin-tone-1:")), Collections.singletonList(":white_haired_man::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏼‍🦳
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("👨🏼‍🦳", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":man_white_haired_tone2:", ":man_white_haired_medium_light_skin_tone:", ":man_white_haired::skin-tone-2:")), Collections.singletonList(":white_haired_man::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏽‍🦳
     */
    Emoji MAN_MEDIUM_SKIN_TONE_WHITE_HAIR = new Emoji("👨🏽‍🦳", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":man_white_haired_tone3:", ":man_white_haired_medium_skin_tone:", ":man_white_haired::skin-tone-3:")), Collections.singletonList(":white_haired_man::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏾‍🦳
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("👨🏾‍🦳", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":man_white_haired_tone4:", ":man_white_haired_medium_dark_skin_tone:", ":man_white_haired::skin-tone-4:")), Collections.singletonList(":white_haired_man::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏿‍🦳
     */
    Emoji MAN_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("👨🏿‍🦳", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":man_white_haired_tone5:", ":man_white_haired_dark_skin_tone:", ":man_white_haired::skin-tone-5:")), Collections.singletonList(":white_haired_man::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨‍🦲
     */
    Emoji MAN_BALD = new Emoji("👨‍🦲", "\uD83D\uDC68\u200D\uD83E\uDDB2", Collections.singletonList(":man_bald:"), Collections.singletonList(":bald_man:"), Collections.singletonList(":bald_man:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "man: bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏻‍🦲
     */
    Emoji MAN_LIGHT_SKIN_TONE_BALD = new Emoji("👨🏻‍🦲", "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":man_bald_tone1:", ":man_bald_light_skin_tone:", ":man_bald::skin-tone-1:")), Collections.singletonList(":bald_man::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏼‍🦲
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_BALD = new Emoji("👨🏼‍🦲", "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":man_bald_tone2:", ":man_bald_medium_light_skin_tone:", ":man_bald::skin-tone-2:")), Collections.singletonList(":bald_man::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏽‍🦲
     */
    Emoji MAN_MEDIUM_SKIN_TONE_BALD = new Emoji("👨🏽‍🦲", "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":man_bald_tone3:", ":man_bald_medium_skin_tone:", ":man_bald::skin-tone-3:")), Collections.singletonList(":bald_man::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏾‍🦲
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_BALD = new Emoji("👨🏾‍🦲", "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":man_bald_tone4:", ":man_bald_medium_dark_skin_tone:", ":man_bald::skin-tone-4:")), Collections.singletonList(":bald_man::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👨🏿‍🦲
     */
    Emoji MAN_DARK_SKIN_TONE_BALD = new Emoji("👨🏿‍🦲", "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":man_bald_tone5:", ":man_bald_dark_skin_tone:", ":man_bald::skin-tone-5:")), Collections.singletonList(":bald_man::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "man: dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩
     */
    Emoji WOMAN = new Emoji("👩", "\uD83D\uDC69", Collections.singletonList(":woman:"), Collections.singletonList(":woman:"), Collections.singletonList(":woman:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "woman", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏻
     */
    Emoji WOMAN_LIGHT_SKIN_TONE = new Emoji("👩🏻", "\uD83D\uDC69\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":woman_tone1:", ":woman::skin-tone-1:")), Collections.singletonList(":woman::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "woman: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏼
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👩🏼", "\uD83D\uDC69\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":woman_tone2:", ":woman::skin-tone-2:")), Collections.singletonList(":woman::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏽
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE = new Emoji("👩🏽", "\uD83D\uDC69\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":woman_tone3:", ":woman::skin-tone-3:")), Collections.singletonList(":woman::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏾
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE = new Emoji("👩🏾", "\uD83D\uDC69\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":woman_tone4:", ":woman::skin-tone-4:")), Collections.singletonList(":woman::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏿
     */
    Emoji WOMAN_DARK_SKIN_TONE = new Emoji("👩🏿", "\uD83D\uDC69\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":woman_tone5:", ":woman::skin-tone-5:")), Collections.singletonList(":woman::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩‍🦰
     */
    Emoji WOMAN_RED_HAIR = new Emoji("👩‍🦰", "\uD83D\uDC69\u200D\uD83E\uDDB0", Collections.singletonList(":woman_red_haired:"), Collections.singletonList(":red_haired_woman:"), Collections.singletonList(":red_haired_woman:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "woman: red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏻‍🦰
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("👩🏻‍🦰", "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":woman_red_haired_tone1:", ":woman_red_haired_light_skin_tone:", ":woman_red_haired::skin-tone-1:")), Collections.singletonList(":red_haired_woman::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏼‍🦰
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("👩🏼‍🦰", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":woman_red_haired_tone2:", ":woman_red_haired_medium_light_skin_tone:", ":woman_red_haired::skin-tone-2:")), Collections.singletonList(":red_haired_woman::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏽‍🦰
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_RED_HAIR = new Emoji("👩🏽‍🦰", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":woman_red_haired_tone3:", ":woman_red_haired_medium_skin_tone:", ":woman_red_haired::skin-tone-3:")), Collections.singletonList(":red_haired_woman::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏾‍🦰
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR = new Emoji("👩🏾‍🦰", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":woman_red_haired_tone4:", ":woman_red_haired_medium_dark_skin_tone:", ":woman_red_haired::skin-tone-4:")), Collections.singletonList(":red_haired_woman::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏿‍🦰
     */
    Emoji WOMAN_DARK_SKIN_TONE_RED_HAIR = new Emoji("👩🏿‍🦰", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":woman_red_haired_tone5:", ":woman_red_haired_dark_skin_tone:", ":woman_red_haired::skin-tone-5:")), Collections.singletonList(":red_haired_woman::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑‍🦰
     */
    Emoji PERSON_RED_HAIR = new Emoji("🧑‍🦰", "\uD83E\uDDD1\u200D\uD83E\uDDB0", Collections.singletonList(":person_red_hair:"), Collections.singletonList(":red_haired_person:"), Collections.singletonList(":person_red_hair:"), false, true, 12.1, Qualification.fromString("fully-qualified"), "person: red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏻‍🦰
     */
    Emoji PERSON_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("🧑🏻‍🦰", "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":person_tone1_red_hair:", ":person_light_skin_tone_red_hair:", ":person_red_hair::skin-tone-1:")), Collections.singletonList(":red_haired_person::skin-tone-2:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏼‍🦰
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR = new Emoji("🧑🏼‍🦰", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":person_tone2_red_hair:", ":person_medium_light_skin_tone_red_hair:", ":person_red_hair::skin-tone-2:")), Collections.singletonList(":red_haired_person::skin-tone-3:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏽‍🦰
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_RED_HAIR = new Emoji("🧑🏽‍🦰", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":person_tone3_red_hair:", ":person_medium_skin_tone_red_hair:", ":person_red_hair::skin-tone-3:")), Collections.singletonList(":red_haired_person::skin-tone-4:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏾‍🦰
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_RED_HAIR = new Emoji("🧑🏾‍🦰", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":person_tone4_red_hair:", ":person_medium_dark_skin_tone_red_hair:", ":person_red_hair::skin-tone-4:")), Collections.singletonList(":red_haired_person::skin-tone-5:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏿‍🦰
     */
    Emoji PERSON_DARK_SKIN_TONE_RED_HAIR = new Emoji("🧑🏿‍🦰", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB0", Collections.unmodifiableList(Arrays.asList(":person_tone5_red_hair:", ":person_dark_skin_tone_red_hair:", ":person_red_hair::skin-tone-5:")), Collections.singletonList(":red_haired_person::skin-tone-6:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: dark skin tone, red hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩‍🦱
     */
    Emoji WOMAN_CURLY_HAIR = new Emoji("👩‍🦱", "\uD83D\uDC69\u200D\uD83E\uDDB1", Collections.singletonList(":woman_curly_haired:"), Collections.singletonList(":curly_haired_woman:"), Collections.singletonList(":curly_haired_woman:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "woman: curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏻‍🦱
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("👩🏻‍🦱", "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":woman_curly_haired_tone1:", ":woman_curly_haired_light_skin_tone:", ":woman_curly_haired::skin-tone-1:")), Collections.singletonList(":curly_haired_woman::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏼‍🦱
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("👩🏼‍🦱", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":woman_curly_haired_tone2:", ":woman_curly_haired_medium_light_skin_tone:", ":woman_curly_haired::skin-tone-2:")), Collections.singletonList(":curly_haired_woman::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏽‍🦱
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_CURLY_HAIR = new Emoji("👩🏽‍🦱", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":woman_curly_haired_tone3:", ":woman_curly_haired_medium_skin_tone:", ":woman_curly_haired::skin-tone-3:")), Collections.singletonList(":curly_haired_woman::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏾‍🦱
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("👩🏾‍🦱", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":woman_curly_haired_tone4:", ":woman_curly_haired_medium_dark_skin_tone:", ":woman_curly_haired::skin-tone-4:")), Collections.singletonList(":curly_haired_woman::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏿‍🦱
     */
    Emoji WOMAN_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("👩🏿‍🦱", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":woman_curly_haired_tone5:", ":woman_curly_haired_dark_skin_tone:", ":woman_curly_haired::skin-tone-5:")), Collections.singletonList(":curly_haired_woman::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑‍🦱
     */
    Emoji PERSON_CURLY_HAIR = new Emoji("🧑‍🦱", "\uD83E\uDDD1\u200D\uD83E\uDDB1", Collections.singletonList(":person_curly_hair:"), Collections.singletonList(":curly_haired_person:"), Collections.singletonList(":person_curly_hair:"), false, true, 12.1, Qualification.fromString("fully-qualified"), "person: curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏻‍🦱
     */
    Emoji PERSON_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("🧑🏻‍🦱", "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":person_tone1_curly_hair:", ":person_light_skin_tone_curly_hair:", ":person_curly_hair::skin-tone-1:")), Collections.singletonList(":curly_haired_person::skin-tone-2:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏼‍🦱
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR = new Emoji("🧑🏼‍🦱", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":person_tone2_curly_hair:", ":person_medium_light_skin_tone_curly_hair:", ":person_curly_hair::skin-tone-2:")), Collections.singletonList(":curly_haired_person::skin-tone-3:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏽‍🦱
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_CURLY_HAIR = new Emoji("🧑🏽‍🦱", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":person_tone3_curly_hair:", ":person_medium_skin_tone_curly_hair:", ":person_curly_hair::skin-tone-3:")), Collections.singletonList(":curly_haired_person::skin-tone-4:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏾‍🦱
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("🧑🏾‍🦱", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":person_tone4_curly_hair:", ":person_medium_dark_skin_tone_curly_hair:", ":person_curly_hair::skin-tone-4:")), Collections.singletonList(":curly_haired_person::skin-tone-5:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏿‍🦱
     */
    Emoji PERSON_DARK_SKIN_TONE_CURLY_HAIR = new Emoji("🧑🏿‍🦱", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB1", Collections.unmodifiableList(Arrays.asList(":person_tone5_curly_hair:", ":person_dark_skin_tone_curly_hair:", ":person_curly_hair::skin-tone-5:")), Collections.singletonList(":curly_haired_person::skin-tone-6:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: dark skin tone, curly hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩‍🦳
     */
    Emoji WOMAN_WHITE_HAIR = new Emoji("👩‍🦳", "\uD83D\uDC69\u200D\uD83E\uDDB3", Collections.singletonList(":woman_white_haired:"), Collections.singletonList(":white_haired_woman:"), Collections.singletonList(":white_haired_woman:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "woman: white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏻‍🦳
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("👩🏻‍🦳", "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":woman_white_haired_tone1:", ":woman_white_haired_light_skin_tone:", ":woman_white_haired::skin-tone-1:")), Collections.singletonList(":white_haired_woman::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏼‍🦳
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("👩🏼‍🦳", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":woman_white_haired_tone2:", ":woman_white_haired_medium_light_skin_tone:", ":woman_white_haired::skin-tone-2:")), Collections.singletonList(":white_haired_woman::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏽‍🦳
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_WHITE_HAIR = new Emoji("👩🏽‍🦳", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":woman_white_haired_tone3:", ":woman_white_haired_medium_skin_tone:", ":woman_white_haired::skin-tone-3:")), Collections.singletonList(":white_haired_woman::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏾‍🦳
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("👩🏾‍🦳", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":woman_white_haired_tone4:", ":woman_white_haired_medium_dark_skin_tone:", ":woman_white_haired::skin-tone-4:")), Collections.singletonList(":white_haired_woman::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏿‍🦳
     */
    Emoji WOMAN_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("👩🏿‍🦳", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":woman_white_haired_tone5:", ":woman_white_haired_dark_skin_tone:", ":woman_white_haired::skin-tone-5:")), Collections.singletonList(":white_haired_woman::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑‍🦳
     */
    Emoji PERSON_WHITE_HAIR = new Emoji("🧑‍🦳", "\uD83E\uDDD1\u200D\uD83E\uDDB3", Collections.singletonList(":person_white_hair:"), Collections.singletonList(":white_haired_person:"), Collections.singletonList(":person_white_hair:"), false, true, 12.1, Qualification.fromString("fully-qualified"), "person: white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏻‍🦳
     */
    Emoji PERSON_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("🧑🏻‍🦳", "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":person_tone1_white_hair:", ":person_light_skin_tone_white_hair:", ":person_white_hair::skin-tone-1:")), Collections.singletonList(":white_haired_person::skin-tone-2:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏼‍🦳
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR = new Emoji("🧑🏼‍🦳", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":person_tone2_white_hair:", ":person_medium_light_skin_tone_white_hair:", ":person_white_hair::skin-tone-2:")), Collections.singletonList(":white_haired_person::skin-tone-3:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏽‍🦳
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_WHITE_HAIR = new Emoji("🧑🏽‍🦳", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":person_tone3_white_hair:", ":person_medium_skin_tone_white_hair:", ":person_white_hair::skin-tone-3:")), Collections.singletonList(":white_haired_person::skin-tone-4:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏾‍🦳
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("🧑🏾‍🦳", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":person_tone4_white_hair:", ":person_medium_dark_skin_tone_white_hair:", ":person_white_hair::skin-tone-4:")), Collections.singletonList(":white_haired_person::skin-tone-5:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏿‍🦳
     */
    Emoji PERSON_DARK_SKIN_TONE_WHITE_HAIR = new Emoji("🧑🏿‍🦳", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB3", Collections.unmodifiableList(Arrays.asList(":person_tone5_white_hair:", ":person_dark_skin_tone_white_hair:", ":person_white_hair::skin-tone-5:")), Collections.singletonList(":white_haired_person::skin-tone-6:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: dark skin tone, white hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩‍🦲
     */
    Emoji WOMAN_BALD = new Emoji("👩‍🦲", "\uD83D\uDC69\u200D\uD83E\uDDB2", Collections.singletonList(":woman_bald:"), Collections.singletonList(":bald_woman:"), Collections.singletonList(":bald_woman:"), false, true, 11.0, Qualification.fromString("fully-qualified"), "woman: bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏻‍🦲
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_BALD = new Emoji("👩🏻‍🦲", "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":woman_bald_tone1:", ":woman_bald_light_skin_tone:", ":woman_bald::skin-tone-1:")), Collections.singletonList(":bald_woman::skin-tone-2:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏼‍🦲
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_BALD = new Emoji("👩🏼‍🦲", "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":woman_bald_tone2:", ":woman_bald_medium_light_skin_tone:", ":woman_bald::skin-tone-2:")), Collections.singletonList(":bald_woman::skin-tone-3:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏽‍🦲
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_BALD = new Emoji("👩🏽‍🦲", "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":woman_bald_tone3:", ":woman_bald_medium_skin_tone:", ":woman_bald::skin-tone-3:")), Collections.singletonList(":bald_woman::skin-tone-4:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏾‍🦲
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_BALD = new Emoji("👩🏾‍🦲", "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":woman_bald_tone4:", ":woman_bald_medium_dark_skin_tone:", ":woman_bald::skin-tone-4:")), Collections.singletonList(":bald_woman::skin-tone-5:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👩🏿‍🦲
     */
    Emoji WOMAN_DARK_SKIN_TONE_BALD = new Emoji("👩🏿‍🦲", "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":woman_bald_tone5:", ":woman_bald_dark_skin_tone:", ":woman_bald::skin-tone-5:")), Collections.singletonList(":bald_woman::skin-tone-6:"), Collections.emptyList(), true, true, 11.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑‍🦲
     */
    Emoji PERSON_BALD = new Emoji("🧑‍🦲", "\uD83E\uDDD1\u200D\uD83E\uDDB2", Collections.singletonList(":person_bald:"), Collections.singletonList(":bald_person:"), Collections.singletonList(":person_bald:"), false, true, 12.1, Qualification.fromString("fully-qualified"), "person: bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏻‍🦲
     */
    Emoji PERSON_LIGHT_SKIN_TONE_BALD = new Emoji("🧑🏻‍🦲", "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":person_tone1_bald:", ":person_light_skin_tone_bald:", ":person_bald::skin-tone-1:")), Collections.singletonList(":bald_person::skin-tone-2:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏼‍🦲
     */
    Emoji PERSON_MEDIUM_LIGHT_SKIN_TONE_BALD = new Emoji("🧑🏼‍🦲", "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":person_tone2_bald:", ":person_medium_light_skin_tone_bald:", ":person_bald::skin-tone-2:")), Collections.singletonList(":bald_person::skin-tone-3:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-light skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏽‍🦲
     */
    Emoji PERSON_MEDIUM_SKIN_TONE_BALD = new Emoji("🧑🏽‍🦲", "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":person_tone3_bald:", ":person_medium_skin_tone_bald:", ":person_bald::skin-tone-3:")), Collections.singletonList(":bald_person::skin-tone-4:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏾‍🦲
     */
    Emoji PERSON_MEDIUM_DARK_SKIN_TONE_BALD = new Emoji("🧑🏾‍🦲", "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":person_tone4_bald:", ":person_medium_dark_skin_tone_bald:", ":person_bald::skin-tone-4:")), Collections.singletonList(":bald_person::skin-tone-5:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: medium-dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧑🏿‍🦲
     */
    Emoji PERSON_DARK_SKIN_TONE_BALD = new Emoji("🧑🏿‍🦲", "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB2", Collections.unmodifiableList(Arrays.asList(":person_tone5_bald:", ":person_dark_skin_tone_bald:", ":person_bald::skin-tone-5:")), Collections.singletonList(":bald_person::skin-tone-6:"), Collections.emptyList(), true, true, 12.1, Qualification.fromString("fully-qualified"), "person: dark skin tone, bald", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱‍♀️
     */
    Emoji WOMAN_BLOND_HAIR = new Emoji("👱‍♀️", "\uD83D\uDC71\u200D\u2640\uFE0F", Collections.singletonList(":blond_haired_woman:"), Collections.singletonList(":blond-haired-woman:"), Collections.singletonList(":blond_haired_woman:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "woman: blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱‍♀
     */
    Emoji WOMAN_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱‍♀", "\uD83D\uDC71\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏻‍♀️
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏻‍♀️", "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_woman_tone1:", ":blond_haired_woman_light_skin_tone:", ":blond_haired_woman::skin-tone-1:")), Collections.singletonList(":blond-haired-woman::skin-tone-2:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "woman: light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏻‍♀
     */
    Emoji WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏻‍♀", "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏼‍♀️
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏼‍♀️", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_woman_tone2:", ":blond_haired_woman_medium_light_skin_tone:", ":blond_haired_woman::skin-tone-2:")), Collections.singletonList(":blond-haired-woman::skin-tone-3:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "woman: medium-light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏼‍♀
     */
    Emoji WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏼‍♀", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: medium-light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏽‍♀️
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏽‍♀️", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_woman_tone3:", ":blond_haired_woman_medium_skin_tone:", ":blond_haired_woman::skin-tone-3:")), Collections.singletonList(":blond-haired-woman::skin-tone-4:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "woman: medium skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏽‍♀
     */
    Emoji WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏽‍♀", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: medium skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏾‍♀️
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏾‍♀️", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_woman_tone4:", ":blond_haired_woman_medium_dark_skin_tone:", ":blond_haired_woman::skin-tone-4:")), Collections.singletonList(":blond-haired-woman::skin-tone-5:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "woman: medium-dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏾‍♀
     */
    Emoji WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏾‍♀", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: medium-dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏿‍♀️
     */
    Emoji WOMAN_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏿‍♀️", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_woman_tone5:", ":blond_haired_woman_dark_skin_tone:", ":blond_haired_woman::skin-tone-5:")), Collections.singletonList(":blond-haired-woman::skin-tone-6:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "woman: dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏿‍♀
     */
    Emoji WOMAN_DARK_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏿‍♀", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "woman: dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱‍♂️
     */
    Emoji MAN_BLOND_HAIR = new Emoji("👱‍♂️", "\uD83D\uDC71\u200D\u2642\uFE0F", Collections.singletonList(":blond_haired_man:"), Collections.singletonList(":blond-haired-man:"), Collections.singletonList(":blond_haired_man:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "man: blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱‍♂
     */
    Emoji MAN_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱‍♂", "\uD83D\uDC71\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 4.0, Qualification.fromString("minimally-qualified"), "man: blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏻‍♂️
     */
    Emoji MAN_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏻‍♂️", "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_man_tone1:", ":blond_haired_man_light_skin_tone:", ":blond_haired_man::skin-tone-1:")), Collections.singletonList(":blond-haired-man::skin-tone-2:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "man: light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏻‍♂
     */
    Emoji MAN_LIGHT_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏻‍♂", "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "man: light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏼‍♂️
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏼‍♂️", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_man_tone2:", ":blond_haired_man_medium_light_skin_tone:", ":blond_haired_man::skin-tone-2:")), Collections.singletonList(":blond-haired-man::skin-tone-3:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "man: medium-light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏼‍♂
     */
    Emoji MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏼‍♂", "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "man: medium-light skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏽‍♂️
     */
    Emoji MAN_MEDIUM_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏽‍♂️", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_man_tone3:", ":blond_haired_man_medium_skin_tone:", ":blond_haired_man::skin-tone-3:")), Collections.singletonList(":blond-haired-man::skin-tone-4:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "man: medium skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏽‍♂
     */
    Emoji MAN_MEDIUM_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏽‍♂", "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "man: medium skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏾‍♂️
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏾‍♂️", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_man_tone4:", ":blond_haired_man_medium_dark_skin_tone:", ":blond_haired_man::skin-tone-4:")), Collections.singletonList(":blond-haired-man::skin-tone-5:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "man: medium-dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏾‍♂
     */
    Emoji MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏾‍♂", "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "man: medium-dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏿‍♂️
     */
    Emoji MAN_DARK_SKIN_TONE_BLOND_HAIR = new Emoji("👱🏿‍♂️", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F", Collections.unmodifiableList(Arrays.asList(":blond_haired_man_tone5:", ":blond_haired_man_dark_skin_tone:", ":blond_haired_man::skin-tone-5:")), Collections.singletonList(":blond-haired-man::skin-tone-6:"), Collections.emptyList(), true, false, 4.0, Qualification.fromString("fully-qualified"), "man: dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👱🏿‍♂
     */
    Emoji MAN_DARK_SKIN_TONE_BLOND_HAIR_MINIMALLY_QUALIFIED = new Emoji("👱🏿‍♂", "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, false, 4.0, Qualification.fromString("minimally-qualified"), "man: dark skin tone, blond hair", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓
     */
    Emoji OLDER_PERSON = new Emoji("🧓", "\uD83E\uDDD3", Collections.unmodifiableList(Arrays.asList(":older_adult:", ":older_person:")), Collections.singletonList(":older_adult:"), Collections.singletonList(":older_adult:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "older person", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓🏻
     */
    Emoji OLDER_PERSON_LIGHT_SKIN_TONE = new Emoji("🧓🏻", "\uD83E\uDDD3\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":older_adult_tone1:", ":older_adult_light_skin_tone:", ":older_adult::skin-tone-1:", ":older_person::skin-tone-1:")), Collections.singletonList(":older_adult::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "older person: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓🏼
     */
    Emoji OLDER_PERSON_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🧓🏼", "\uD83E\uDDD3\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":older_adult_tone2:", ":older_adult_medium_light_skin_tone:", ":older_adult::skin-tone-2:", ":older_person::skin-tone-2:")), Collections.singletonList(":older_adult::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "older person: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓🏽
     */
    Emoji OLDER_PERSON_MEDIUM_SKIN_TONE = new Emoji("🧓🏽", "\uD83E\uDDD3\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":older_adult_tone3:", ":older_adult_medium_skin_tone:", ":older_adult::skin-tone-3:", ":older_person::skin-tone-3:")), Collections.singletonList(":older_adult::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "older person: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓🏾
     */
    Emoji OLDER_PERSON_MEDIUM_DARK_SKIN_TONE = new Emoji("🧓🏾", "\uD83E\uDDD3\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":older_adult_tone4:", ":older_adult_medium_dark_skin_tone:", ":older_adult::skin-tone-4:", ":older_person::skin-tone-4:")), Collections.singletonList(":older_adult::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "older person: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 🧓🏿
     */
    Emoji OLDER_PERSON_DARK_SKIN_TONE = new Emoji("🧓🏿", "\uD83E\uDDD3\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":older_adult_tone5:", ":older_adult_dark_skin_tone:", ":older_adult::skin-tone-5:", ":older_person::skin-tone-5:")), Collections.singletonList(":older_adult::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "older person: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴
     */
    Emoji OLD_MAN = new Emoji("👴", "\uD83D\uDC74", Collections.unmodifiableList(Arrays.asList(":older_man:", ":old_man:")), Collections.singletonList(":older_man:"), Collections.singletonList(":older_man:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "old man", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴🏻
     */
    Emoji OLD_MAN_LIGHT_SKIN_TONE = new Emoji("👴🏻", "\uD83D\uDC74\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":older_man_tone1:", ":older_man::skin-tone-1:", ":old_man::skin-tone-1:")), Collections.singletonList(":older_man::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old man: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴🏼
     */
    Emoji OLD_MAN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👴🏼", "\uD83D\uDC74\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":older_man_tone2:", ":older_man::skin-tone-2:", ":old_man::skin-tone-2:")), Collections.singletonList(":older_man::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old man: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴🏽
     */
    Emoji OLD_MAN_MEDIUM_SKIN_TONE = new Emoji("👴🏽", "\uD83D\uDC74\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":older_man_tone3:", ":older_man::skin-tone-3:", ":old_man::skin-tone-3:")), Collections.singletonList(":older_man::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old man: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴🏾
     */
    Emoji OLD_MAN_MEDIUM_DARK_SKIN_TONE = new Emoji("👴🏾", "\uD83D\uDC74\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":older_man_tone4:", ":older_man::skin-tone-4:", ":old_man::skin-tone-4:")), Collections.singletonList(":older_man::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old man: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👴🏿
     */
    Emoji OLD_MAN_DARK_SKIN_TONE = new Emoji("👴🏿", "\uD83D\uDC74\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":older_man_tone5:", ":older_man::skin-tone-5:", ":old_man::skin-tone-5:")), Collections.singletonList(":older_man::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old man: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵
     */
    Emoji OLD_WOMAN = new Emoji("👵", "\uD83D\uDC75", Collections.unmodifiableList(Arrays.asList(":older_woman:", ":grandma:", ":old_woman:")), Collections.singletonList(":older_woman:"), Collections.singletonList(":older_woman:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "old woman", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵🏻
     */
    Emoji OLD_WOMAN_LIGHT_SKIN_TONE = new Emoji("👵🏻", "\uD83D\uDC75\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":older_woman_tone1:", ":grandma_tone1:", ":older_woman::skin-tone-1:", ":grandma::skin-tone-1:", ":old_woman::skin-tone-1:")), Collections.singletonList(":older_woman::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old woman: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵🏼
     */
    Emoji OLD_WOMAN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👵🏼", "\uD83D\uDC75\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":older_woman_tone2:", ":grandma_tone2:", ":older_woman::skin-tone-2:", ":grandma::skin-tone-2:", ":old_woman::skin-tone-2:")), Collections.singletonList(":older_woman::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old woman: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵🏽
     */
    Emoji OLD_WOMAN_MEDIUM_SKIN_TONE = new Emoji("👵🏽", "\uD83D\uDC75\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":older_woman_tone3:", ":grandma_tone3:", ":older_woman::skin-tone-3:", ":grandma::skin-tone-3:", ":old_woman::skin-tone-3:")), Collections.singletonList(":older_woman::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old woman: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵🏾
     */
    Emoji OLD_WOMAN_MEDIUM_DARK_SKIN_TONE = new Emoji("👵🏾", "\uD83D\uDC75\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":older_woman_tone4:", ":grandma_tone4:", ":older_woman::skin-tone-4:", ":grandma::skin-tone-4:", ":old_woman::skin-tone-4:")), Collections.singletonList(":older_woman::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old woman: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);

    /**
     * 👵🏿
     */
    Emoji OLD_WOMAN_DARK_SKIN_TONE = new Emoji("👵🏿", "\uD83D\uDC75\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":older_woman_tone5:", ":grandma_tone5:", ":older_woman::skin-tone-5:", ":grandma::skin-tone-5:", ":old_woman::skin-tone-5:")), Collections.singletonList(":older_woman::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "old woman: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.PERSON, false);
}
